/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi;

import java.util.Enumeration;
import java.util.Vector;
import javax.sound.midi.ShortMessage;
import org.json.JSONObject;
import org.openstatic.midi.MidiControlListener;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;

public class MidiControl {
    private int channel;
    private int cc;
    private int note;
    private int value;
    private int settled_value;
    private String nickname;
    private boolean settled;
    private long lastChangeAt;
    private MidiPort lastReceivedFrom;
    private Vector<MidiControlListener> listeners = new Vector();

    public MidiControl(JSONObject jo) {
        this.channel = jo.optInt("channel", 0);
        this.cc = jo.optInt("cc", -1);
        this.note = jo.optInt("note", -1);
        this.nickname = jo.optString("nickname", MidiControl.nameControl(this.channel, this.cc));
        this.settled = true;
        this.lastChangeAt = System.currentTimeMillis();
        this.value = jo.optInt("value", 0);
        this.settled_value = jo.optInt("settledValue", 0);
    }

    public MidiControl(int channel, int cc) {
        this.channel = channel;
        this.cc = cc;
        this.note = -1;
        this.value = 0;
        this.nickname = MidiControl.nameControl(channel, cc);
        this.settled = true;
        this.lastChangeAt = System.currentTimeMillis();
    }

    public MidiControl(int channel, int note, boolean isNote) {
        this.channel = channel;
        this.cc = -1;
        this.note = note;
        this.value = 0;
        this.nickname = "Note - " + MidiPortManager.nameNote(note);
        this.settled = true;
        this.lastChangeAt = System.currentTimeMillis();
    }

    private static String nameControl(int channel, int cc) {
        MidiPort sourcePort = MidiPortManager.findTransmittingPortByChannelCC(channel, cc);
        if (sourcePort != null) {
            String name = sourcePort.getCCName(channel, cc);
            System.err.println("name Control found Source port for " + String.valueOf(channel) + " " + String.valueOf(cc));
            if (name != null) {
                System.err.println("Name Found " + name);
                return name;
            }
        }
        return MidiPortManager.nameCC(cc);
    }

    public String getNoteName() {
        return MidiPortManager.nameNote(this.note);
    }

    public int getNoteNumber() {
        return this.note;
    }

    public void addMidiControlListener(MidiControlListener mcl) {
        if (!this.listeners.contains(mcl)) {
            this.listeners.add(mcl);
        }
    }

    public void removeMidiControlListener(MidiControlListener mcl) {
        if (this.listeners.contains(mcl)) {
            this.listeners.remove(mcl);
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public boolean messageMatches(ShortMessage msg) {
        int incomingNote;
        return (msg.getChannel() + 1 == this.channel || this.channel == 0) && (msg.getCommand() == 176 ? msg.getData1() == this.cc : (msg.getCommand() == 144 ? (incomingNote = msg.getData1() % 12) == this.note : msg.getCommand() == 128 && (incomingNote = msg.getData1() % 12) == this.note));
    }

    public MidiPort getLastReceivedFromMidiPort() {
        return this.lastReceivedFrom;
    }

    public void processMessage(ShortMessage msg) {
        if (this.cc >= 0) {
            this.manualAdjust(msg.getData2());
            this.lastReceivedFrom = MidiPortManager.findTransmittingPortByChannelCC(this.getChannel(), this.getControlNumber());
        } else if (this.note >= 0) {
            this.lastReceivedFrom = MidiPortManager.findTransmittingPortByChannelNote(this.getChannel(), this.getNoteNumber());
            int incomingNote = msg.getData1() % 12;
            if (incomingNote == this.note) {
                if (msg.getCommand() == 144) {
                    this.manualAdjust(msg.getData2());
                } else if (msg.getCommand() == 128) {
                    this.manualAdjust(0);
                }
            }
        }
    }

    public synchronized void manualAdjust(int new_value) {
        int old_value;
        if (new_value <= 127 && new_value >= 0 && (old_value = this.value) != new_value) {
            this.value = new_value;
            this.lastChangeAt = System.currentTimeMillis();
            this.settled = false;
            Enumeration mcle = ((Vector)this.listeners.clone()).elements();
            while (mcle.hasMoreElements()) {
                MidiControlListener mcl = (MidiControlListener)mcle.nextElement();
                MidiPortManager.addTask(() -> mcl.controlValueChanged(this, old_value, new_value));
            }
        }
    }

    public int getChannel() {
        return this.channel;
    }

    public int getControlNumber() {
        return this.cc;
    }

    public int getValue() {
        return this.value;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isSettled() {
        return this.settled;
    }

    public long getLastChangeAt() {
        return this.lastChangeAt;
    }

    public void settle() {
        if (System.currentTimeMillis() - this.lastChangeAt > 250L && !this.settled) {
            this.settled = true;
            int old_value = this.settled_value;
            this.settled_value = this.value;
            int final_value = this.value;
            Enumeration mcle = ((Vector)this.listeners.clone()).elements();
            while (mcle.hasMoreElements()) {
                MidiControlListener mcl = (MidiControlListener)mcle.nextElement();
                MidiPortManager.addTask(() -> mcl.controlValueSettled(this, old_value, final_value));
            }
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jo = new JSONObject();
        if (this.cc >= 0) {
            jo.put("cc", this.cc);
        }
        if (this.note >= 0) {
            jo.put("note", this.note);
        }
        jo.put("channel", this.channel);
        jo.put("nickname", this.nickname);
        jo.put("value", this.value);
        jo.put("settledValue", this.settled_value);
        jo.put("lastChangeAt", this.lastChangeAt);
        return jo;
    }

    public JSONObject toSavableJSONObject() {
        JSONObject jo = new JSONObject();
        if (this.cc >= 0) {
            jo.put("cc", this.cc);
        }
        if (this.note >= 0) {
            jo.put("note", this.note);
        }
        jo.put("channel", this.channel);
        jo.put("nickname", this.nickname);
        return jo;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String toString() {
        if (this.nickname != null) {
            return this.nickname;
        }
        if (this.cc >= 0) {
            return "Control " + String.valueOf(this.cc) + " (CH-" + String.valueOf(this.channel) + ")";
        }
        if (this.note >= 0) {
            return MidiPortManager.nameNote(this.note) + " (CH-" + String.valueOf(this.channel) + ")";
        }
        return "";
    }
}

