/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.json.JSONObject;
import org.openstatic.midi.RandomizerRulesListener;
import org.openstatic.midi.ports.MidiRandomizerPort;

public class RandomizerListModel
implements ListModel<JSONObject>,
RandomizerRulesListener {
    private Vector<ListDataListener> listeners = new Vector();
    private MidiRandomizerPort randomizerPort;

    public RandomizerListModel(MidiRandomizerPort randomizerPort) {
        this.randomizerPort = randomizerPort;
        this.randomizerPort.addRandomizerRulesListener(this);
    }

    @Override
    public int getSize() {
        try {
            return this.randomizerPort.getAllRules().length();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public JSONObject getElementAt(int index) {
        try {
            return this.randomizerPort.getAllRules().getJSONObject(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        try {
            this.listeners.remove(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ruleAdded(int idx, JSONObject rule) {
        System.err.println("Rule Added(" + String.valueOf(idx) + "): " + rule.toString());
        Enumeration ldle = ((Vector)this.listeners.clone()).elements();
        while (ldle.hasMoreElements()) {
            try {
                ListDataListener ldl = (ListDataListener)ldle.nextElement();
                ListDataEvent lde = new ListDataEvent(rule, 1, idx, idx);
                ldl.intervalAdded(lde);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void ruleRemoved(int idx, JSONObject rule) {
        Enumeration ldle = ((Vector)this.listeners.clone()).elements();
        while (ldle.hasMoreElements()) {
            try {
                ListDataListener ldl = (ListDataListener)ldle.nextElement();
                ListDataEvent lde = new ListDataEvent(rule, 2, idx, idx);
                ldl.intervalRemoved(lde);
            }
            catch (Exception exception) {}
        }
    }
}

