/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi.ports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import javax.imageio.ImageIO;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;

public class LoggerMidiPort
extends JPanel
implements MidiPort,
ActionListener,
Runnable,
FocusListener {
    private boolean hasFocus;
    private boolean opened;
    private boolean keep_running;
    private String name;
    private JTextPane viewArea;
    private JScrollPane midi_log_scroller;
    private JToggleButton autoscroll;
    private JToggleButton portControl;
    private String initBody = "<html><body style=\"padding: 4px 4px 4px 4px; margin: 0px 0px 0px 0px; color: white; background-color: #222222; font-size: 14px; font-family: \"terminal\", monospace;\"><table style=\"width: 100%; text-align: left;\" cellspacing=\"0\" cellpadding=\"0\"></table></body></html>";
    private JButton clearLog;
    private JPanel buttonPanel;
    private ArrayBlockingQueue<Runnable> taskQueue = new ArrayBlockingQueue(10000);
    private Thread taskThread;
    private int beatPulse = 1;
    private long lastTxAt;
    private long txCount;
    private long rxCount;

    private void maybeScrollToBottom() {
        JScrollBar scrollBar;
        boolean scrollBarAtBottom;
        if (this.autoscroll != null && this.autoscroll.isSelected() && this.isVisible() && !(scrollBarAtBottom = this.isScrollBarFullyExtended(scrollBar = this.midi_log_scroller.getVerticalScrollBar()))) {
            this.taskQueue.add(() -> LoggerMidiPort.scrollToBottom(this.viewArea));
        }
    }

    private boolean isScrollBarFullyExtended(JScrollBar vScrollBar) {
        BoundedRangeModel model = vScrollBar.getModel();
        return model.getExtent() + model.getValue() == model.getMaximum();
    }

    public LoggerMidiPort(String name) {
        super(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.viewArea = new JTextPane();
        this.viewArea.setContentType("text/html");
        this.viewArea.setEditable(false);
        this.viewArea.setBackground(new Color(34, 34, 34));
        this.viewArea.setText(this.initBody);
        DefaultCaret caret = (DefaultCaret)this.viewArea.getCaret();
        caret.setUpdatePolicy(1);
        this.midi_log_scroller = new JScrollPane(this.viewArea);
        this.midi_log_scroller.setVerticalScrollBarPolicy(22);
        this.name = name;
        try {
            ImageIcon eraseIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/erase.png")));
            this.clearLog = new JButton(eraseIcon);
            this.clearLog.setActionCommand("clear");
            this.clearLog.addActionListener(this);
            this.clearLog.setToolTipText("Clear Log");
            ImageIcon scrollIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/scroll.png")));
            this.autoscroll = new JToggleButton(scrollIcon);
            this.autoscroll.setSelected(true);
            this.autoscroll.setToolTipText("Autoscroll");
            ImageIcon portIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/midi-small.png")));
            this.portControl = new JToggleButton(portIcon);
            this.portControl.setSelected(this.opened);
            this.portControl.setToolTipText("Open this MIDI port (literally to the logger)");
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
                    ButtonModel buttonModel = abstractButton.getModel();
                    boolean selected = buttonModel.isSelected();
                    if (LoggerMidiPort.this.isOpened() != selected) {
                        if (selected) {
                            LoggerMidiPort.this.open();
                        } else {
                            LoggerMidiPort.this.close();
                        }
                    }
                }
            };
            this.portControl.addChangeListener(changeListener);
            this.buttonPanel.add(this.portControl);
            this.buttonPanel.add(this.autoscroll);
            this.buttonPanel.add(this.clearLog);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.add((Component)this.midi_log_scroller, "Center");
        this.add((Component)this.buttonPanel, "West");
        this.start();
        this.addFocusListener(this);
    }

    public void hidePortControl() {
        try {
            this.buttonPanel.remove(this.portControl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void open() {
        if (!this.isOpened()) {
            this.opened = true;
            this.portControl.setSelected(true);
            MidiPortManager.firePortOpened(this);
        }
    }

    @Override
    public void close() {
        if (this.isOpened()) {
            MidiPortManager.firePortClosed(this);
            this.opened = false;
            this.portControl.setSelected(false);
        }
    }

    public void start() {
        this.keep_running = true;
        this.taskThread = new Thread(this);
        this.taskThread.start();
    }

    public void stop() {
        this.keep_running = false;
        this.taskThread = null;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("clear".equals(e.getActionCommand())) {
            this.viewArea.setText(this.initBody);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getMicrosecondPosition() {
        return System.currentTimeMillis() * 1000L;
    }

    @Override
    public boolean equals(MidiPort port) {
        return this.name.equals(port.getName());
    }

    @Override
    public boolean canTransmitMessages() {
        return false;
    }

    @Override
    public void addReceiver(Receiver r) {
    }

    @Override
    public void removeReceiver(Receiver r) {
    }

    @Override
    public boolean hasReceiver(Receiver r) {
        return false;
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return null;
    }

    @Override
    public boolean canReceiveMessages() {
        return true;
    }

    public static short toShort(byte msb, byte lsb) {
        return (short)(0xFF00 & (short)(msb << 8) | 0xFF & (short)lsb);
    }

    public static short toShort(byte[] data) {
        if (data == null || data.length != 2) {
            return 0;
        }
        return (short)((0xFF & data[0]) << 8 | 0xFF & data[1]);
    }

    public static float mapFloat(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public static String shortMessageToString(ShortMessage msg) {
        String channelText = "CH " + String.format("%02d", msg.getChannel() + 1);
        Object commandText = "";
        Object data1Value = "?";
        if (msg.getCommand() == 224) {
            int bendValue = msg.getData2() << 7 | msg.getData1();
            float bendAmount = LoggerMidiPort.mapFloat(bendValue, 0.0f, 16383.0f, -1.0f, 1.0f);
            commandText = "<b style=\"color: orange;\">PITCH BEND</b>";
            Object bendText = String.format("%1.2f", Float.valueOf(bendAmount));
            if (!((String)bendText).startsWith("-")) {
                bendText = "+" + (String)bendText;
            }
            return channelText + " " + (String)commandText + " " + (String)bendText;
        }
        if (msg.getCommand() == 176) {
            commandText = "<b style=\"color: yellow;\">CONTROL CHANGE " + String.format("%3d", msg.getData1()) + "</b>";
            return channelText + " " + (String)commandText + " = " + String.valueOf(msg.getData2());
        }
        if (msg.getCommand() == 144) {
            data1Value = MidiPortManager.noteNumberToString(msg.getData1());
            commandText = "<b style=\"color: green;\">NOTE ON</b>";
            return channelText + " " + (String)commandText + " " + (String)data1Value + " = " + String.valueOf(msg.getData2());
        }
        if (msg.getCommand() == 128) {
            data1Value = MidiPortManager.noteNumberToString(msg.getData1());
            commandText = "<b style=\"color: red;\">NOTE OFF</b>";
            return channelText + " " + (String)commandText + " " + (String)data1Value + " = " + String.valueOf(msg.getData2());
        }
        if (msg.getCommand() == 240) {
            byte[] data = msg.getMessage();
            data1Value = String.valueOf(Byte.toUnsignedInt(data[0]));
            for (int i = 1; i < msg.getLength(); ++i) {
                data1Value = (String)data1Value + ", " + String.valueOf(Byte.toUnsignedInt(data[i]));
            }
            commandText = "<b style=\"color: purple;\">SYSTEM EXCLUSIVE</b> [" + (String)data1Value + "]";
            int command = Byte.toUnsignedInt(data[0]);
            if (command == 251) {
                commandText = "<b style=\"color: purple;\">SYSEX CONTINUE</b>";
            } else if (command == 252) {
                commandText = "<b style=\"color: purple;\">SYSEX STOP</b>";
            } else if (command == 250) {
                commandText = "<b style=\"color: purple;\">SYSEX START</b>";
            } else if (command == 243) {
                commandText = "<b style=\"color: purple;\">SYSEX SONG SELECT</b>";
            } else if (command == 242) {
                short result = LoggerMidiPort.toShort(data[1], data[2]);
                commandText = "<b style=\"color: purple;\">SYSEX SONG POSITION</b> = " + String.valueOf(result) + " beats, " + String.valueOf(result / 1024) + " seconds";
            }
            return commandText;
        }
        commandText = "<b style=\"color: purple;\">MIDI COMMAND " + String.valueOf(msg.getCommand()) + "</b>";
        byte[] data = msg.getMessage();
        data1Value = "[" + String.valueOf(Byte.toUnsignedInt(data[0]));
        for (int i = 1; i < msg.getLength(); ++i) {
            data1Value = (String)data1Value + ", " + String.valueOf(Byte.toUnsignedInt(data[i]));
        }
        data1Value = (String)data1Value + "]";
        return channelText + " " + (String)commandText + " " + (String)data1Value;
    }

    public void printException(Exception e) {
        this.println("Exception - " + e.toString());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            this.println(baos.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void println(String text) {
        this.println(System.currentTimeMillis(), text);
    }

    public void println(long timeStamp, String text) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS");
        String date_time = df.format(new Date(timeStamp));
        this.addText("<i style=\"color: #777777;\">" + date_time + "</i>", text);
    }

    private void addText(final String timestamp, final String html_to_add) {
        this.taskQueue.add(new Runnable(){

            @Override
            public void run() {
                try {
                    HTMLDocument doc_html = (HTMLDocument)LoggerMidiPort.this.viewArea.getDocument();
                    Element[] roots = doc_html.getRootElements();
                    Element body = null;
                    Element table = null;
                    for (int i = 0; i < roots[0].getElementCount(); ++i) {
                        Element element = roots[0].getElement(i);
                        if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) continue;
                        body = element;
                        table = body.getElement(0);
                        break;
                    }
                    if (table != null) {
                        int elCount = table.getElementCount();
                        if (elCount > 2000) {
                            Element el = table.getElement(0);
                            doc_html.removeElement(el);
                        }
                        doc_html.insertBeforeEnd(table, "<tr><td style=\"width: 160px;\">" + timestamp + "</td><td style=\"text-align: left;\">" + html_to_add + "</td></tr>");
                    }
                }
                catch (Exception ins_exc) {
                    ins_exc.printStackTrace(System.err);
                }
            }
        });
    }

    @Override
    public void run() {
        while (this.keep_running) {
            try {
                if (this.taskQueue.size() > 0) {
                    ArrayList taskArray = new ArrayList();
                    this.taskQueue.drainTo(taskArray);
                    SwingUtilities.invokeAndWait(() -> {
                        for (Runnable swingTask : taskArray) {
                            swingTask.run();
                        }
                    });
                } else {
                    Thread.sleep(10L);
                }
                this.maybeScrollToBottom();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void scrollToBottom(JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        visibleRect.y = component.getHeight() - visibleRect.height;
        component.scrollRectToVisible(visibleRect);
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.lastTxAt = System.currentTimeMillis();
        if (message instanceof ShortMessage && this.opened) {
            ++this.txCount;
            ShortMessage smsg = (ShortMessage)message;
            if (smsg.getStatus() == 248) {
                if (this.beatPulse >= 24) {
                    this.beatPulse = 0;
                }
                ++this.beatPulse;
            } else {
                this.println(LoggerMidiPort.shortMessageToString(smsg));
            }
        }
    }

    @Override
    public long getLastRxAt() {
        return 0L;
    }

    @Override
    public long getLastTxAt() {
        return this.lastTxAt;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
    }

    @Override
    public String getCCName(int channel, int cc) {
        return null;
    }

    @Override
    public long getRxCount() {
        return this.rxCount;
    }

    @Override
    public long getTxCount() {
        return this.txCount;
    }
}

