/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi.providers;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortProvider;
import org.openstatic.midi.ports.DeviceMidiPort;

public class DeviceMidiPortProvider
implements MidiPortProvider {
    private LinkedHashMap<MidiDevice.Info, MidiPort> localDevices = new LinkedHashMap();

    public Collection<MidiPort> getMidiPorts() {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        Vector<MidiDevice.Info> newLocalDevices = new Vector<MidiDevice.Info>(Arrays.asList(infos));
        for (MidiDevice.Info di : newLocalDevices) {
            if (this.localDevices.containsKey(di)) continue;
            try {
                MidiDevice device = MidiSystem.getMidiDevice(di);
                DeviceMidiPort ms = new DeviceMidiPort(device);
                this.localDevices.put(di, ms);
            }
            catch (MidiUnavailableException e) {
                System.err.println(e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        for (MidiDevice.Info di : ((LinkedHashMap)this.localDevices.clone()).keySet()) {
            if (newLocalDevices.contains(di)) continue;
            this.localDevices.remove(di);
        }
        return this.localDevices.values();
    }
}

