/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutRemoteSession;
import org.openstatic.routeput.RoutePutServer;
import org.openstatic.routeput.RoutePutSession;
import org.openstatic.routeput.util.JSONTools;

public class RoutePutPropertyChangeMessage
extends RoutePutMessage {
    public static final String TYPE_CHANNEL = "channel";
    public static final String TYPE_SESSION = "session";

    public RoutePutPropertyChangeMessage(RoutePutMessage rpm) {
        this.setType("propertyChange");
        this.setSourceId(rpm.getSourceId());
        this.getRoutePutMeta().put("updates", rpm.getRoutePutMeta().optJSONArray("updates"));
    }

    public static List<RoutePutPropertyChangeMessage> buildSmallUpdatesFor(RoutePutChannel channel) {
        JSONObject properties = channel.getProperties();
        Set<String> keys = properties.keySet();
        ArrayList<RoutePutPropertyChangeMessage> messages = new ArrayList<RoutePutPropertyChangeMessage>(keys.size());
        keys.forEach(key -> {
            RoutePutPropertyChangeMessage rppcm = new RoutePutPropertyChangeMessage();
            rppcm.setChannel(channel);
            rppcm.addUpdate(channel, (String)key, (Object)null, properties.opt((String)key));
            messages.add(rppcm);
        });
        return messages;
    }

    public RoutePutPropertyChangeMessage forChannel(RoutePutChannel channel) {
        RoutePutPropertyChangeMessage rppcm = new RoutePutPropertyChangeMessage();
        List<Object> updates = JSONTools.listJSONArray(this.getRoutePutMeta().optJSONArray("updates"));
        updates.forEach(update -> {
            try {
                if (update instanceof JSONObject) {
                    JSONObject joUpdate = (JSONObject)update;
                    String objectType = joUpdate.optString("type");
                    String objectId = joUpdate.optString("id");
                    if (TYPE_CHANNEL.equals(objectType)) {
                        if (channel.getName().equals(objectId)) {
                            rppcm.addUpdate((JSONObject)update);
                        }
                    } else if (TYPE_SESSION.equals(objectType) && channel.hasMember(objectId)) {
                        rppcm.addUpdate((JSONObject)update);
                    }
                }
            }
            catch (Exception e) {
                RoutePutServer.logError(e);
            }
        });
        rppcm.setSourceId(this.getSourceId());
        rppcm.setChannel(channel);
        return rppcm;
    }

    private boolean nullSafeCompare(Object obj1, Object obj2) {
        if (obj1 != null && obj2 != null) {
            return obj1.equals(obj2);
        }
        if (obj1 == null && obj2 != null) {
            return false;
        }
        return obj1 == null || obj2 != null;
    }

    public RoutePutPropertyChangeMessage() {
        this.setType("propertyChange");
    }

    public void processUpdates(RoutePutSession receivingSession) {
        List<Object> updates = JSONTools.listJSONArray(this.getRoutePutMeta().optJSONArray("updates"));
        ArrayList<RoutePutChannel> channelsInvolved = new ArrayList<RoutePutChannel>();
        updates.forEach(update -> {
            try {
                if (update instanceof JSONObject) {
                    JSONObject joUpdate = (JSONObject)update;
                    String objectType = joUpdate.optString("type");
                    String objectId = joUpdate.optString("id");
                    String key = joUpdate.optString("key");
                    Object oldValue = joUpdate.opt("old");
                    Object newValue = joUpdate.opt("new");
                    if (TYPE_CHANNEL.equals(objectType)) {
                        RoutePutChannel channel2 = RoutePutChannel.getChannel(objectId);
                        channel2.firePropertyChange(key, oldValue, newValue);
                        if (!channelsInvolved.contains(channel2)) {
                            channelsInvolved.add(channel2);
                        }
                    } else if (TYPE_SESSION.equals(objectType)) {
                        JSONObject rsProp;
                        RoutePutRemoteSession rprs;
                        JSONObject rsProp2;
                        boolean handled = false;
                        if (receivingSession != null && receivingSession.getConnectionId().equals(objectId) && !this.nullSafeCompare(newValue, (rsProp2 = receivingSession.getProperties()).opt(key))) {
                            receivingSession.firePropertyChange(key, oldValue, newValue);
                            Collection<RoutePutChannel> rpcc = RoutePutChannel.channelsWithMember(receivingSession);
                            rpcc.forEach(channel -> {
                                if (!channelsInvolved.contains(channel)) {
                                    channelsInvolved.add((RoutePutChannel)channel);
                                }
                            });
                            handled = true;
                        }
                        if (!handled && (rprs = RoutePutRemoteSession.findRemoteSession(objectId)) != null && !this.nullSafeCompare(newValue, (rsProp = rprs.getProperties()).opt(key))) {
                            rprs.firePropertyChange(key, oldValue, newValue);
                            Collection<RoutePutChannel> rpcc = RoutePutChannel.channelsWithMember(rprs);
                            rpcc.forEach(channel -> {
                                if (!channelsInvolved.contains(channel)) {
                                    channelsInvolved.add((RoutePutChannel)channel);
                                }
                            });
                        }
                    }
                }
            }
            catch (Exception e) {
                RoutePutServer.logError(e);
            }
        });
        channelsInvolved.forEach(channel -> channel.broadcast(this.forChannel((RoutePutChannel)channel)));
    }

    public RoutePutPropertyChangeMessage addUpdate(RoutePutChannel channel, String key, Object oldValue, Object newValue) {
        JSONObject update = new JSONObject();
        update.put("type", TYPE_CHANNEL);
        update.put("id", channel.getName());
        update.put("key", key);
        if (oldValue != null) {
            update.put("old", oldValue);
        }
        update.put("new", newValue);
        return this.addUpdate(update);
    }

    public RoutePutPropertyChangeMessage addUpdate(RoutePutSession session, String key, Object oldValue, Object newValue) {
        JSONObject update = new JSONObject();
        update.put("type", TYPE_SESSION);
        update.put("id", session.getConnectionId());
        update.put("key", key);
        if (oldValue != null) {
            update.put("old", oldValue);
        }
        update.put("new", newValue);
        return this.addUpdate(update);
    }

    public RoutePutPropertyChangeMessage addUpdate(JSONObject update) {
        this.appendMetaArray("updates", update);
        return this;
    }
}

