/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput.midi;

import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import org.json.JSONArray;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutMessageListener;
import org.openstatic.routeput.RoutePutServer;
import org.openstatic.routeput.RoutePutSession;

public class RouteputMIDITransmitter
implements Transmitter,
RoutePutMessageListener {
    private Receiver receiver;
    private RoutePutChannel channel;
    private long clockPosition;
    private boolean enableTimestamps;

    public RouteputMIDITransmitter(RoutePutChannel channel) {
        this.channel = channel;
        this.channel.addMessageListener(this);
        this.clockPosition = -1L;
        this.enableTimestamps = true;
    }

    public void setEnableTimestamps(boolean v) {
        this.enableTimestamps = v;
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    @Override
    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public void close() {
        this.channel.removeMessageListener(this);
    }

    @Override
    public void onMessage(RoutePutSession session, RoutePutMessage message) {
        try {
            if (message.isType("midi")) {
                JSONArray data = message.getRoutePutMeta().getJSONArray("data");
                long timeStamp = message.getRoutePutMeta().optLong("ts", this.clockPosition);
                int data0 = data.optInt(0, 0);
                int data1 = data.optInt(1, 0);
                int data2 = data.optInt(2, 0);
                int command = data0 & 0xF0;
                int channel = data0 & 0xF;
                ShortMessage sm = new ShortMessage(command, channel, data1, data2);
                if (this.receiver != null) {
                    if (this.enableTimestamps) {
                        this.receiver.send(sm, timeStamp);
                    } else {
                        this.receiver.send(sm, -1L);
                    }
                }
            } else if (message.isType("pulse")) {
                long timeStamp;
                this.clockPosition = timeStamp = message.getRoutePutMeta().optLong("ts", -1L);
                ShortMessage sm = new ShortMessage(248);
                if (this.receiver != null) {
                    if (this.enableTimestamps) {
                        this.receiver.send(sm, timeStamp);
                    } else {
                        this.receiver.send(sm, -1L);
                    }
                }
            }
        }
        catch (Exception e) {
            RoutePutServer.logError(e);
        }
    }
}

