/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONTools {
    public static boolean matchesFilter(Object other, Object filter) {
        if (filter == other) {
            return true;
        }
        if (filter instanceof JSONArray) {
            return JSONTools.matchesFilter((Object)((JSONArray)filter), other);
        }
        if (filter instanceof JSONArray) {
            return JSONTools.matchesFilter((Object)((JSONObject)filter), other);
        }
        return filter.equals(other);
    }

    public static boolean matchesFilter(Object array, JSONArray filter) {
        try {
            if (!(array instanceof JSONArray)) {
            }
            JSONArray jArray = (JSONArray)array;
            List<Object> jArrayList = JSONTools.listJSONArray(jArray);
            for (Object valueFilter : filter) {
                if (valueFilter instanceof JSONObject) {
                    JSONObject valueFilterJSONObject = (JSONObject)valueFilter;
                    if (jArrayList.stream().filter(i -> JSONTools.matchesFilter(i, valueFilterJSONObject)).count() != 0L) continue;
                }
                if (valueFilter instanceof JSONArray) {
                    JSONArray valueFilterJSONArray = (JSONArray)valueFilter;
                    if (jArrayList.stream().filter(i -> JSONTools.matchesFilter(i, valueFilterJSONArray)).count() != 0L) continue;
                }
                if (jArrayList.contains(valueFilter)) continue;
            }
            return true;
        }
        finally {
            return false;
        }
    }

    public static boolean matchesFilter(Object object, JSONObject filter) {
        try {
            if (!(object instanceof JSONObject)) {
                System.err.println("Not a JSONObject");
            }
            JSONObject jObject = (JSONObject)object;
            Set<String> filterFieldSet = filter.keySet();
            Set<String> objectFieldSet = jObject.keySet();
            if (!objectFieldSet.containsAll(filterFieldSet)) {
            }
            for (String name : filterFieldSet) {
                Object valueFilter = filter.get(name);
                Object valueObject = jObject.get(name);
                if (valueFilter instanceof JSONObject) {
                    if (JSONTools.matchesFilter(valueObject, (JSONObject)valueFilter)) continue;
                }
                if (valueFilter instanceof JSONArray) {
                    if (JSONTools.matchesFilter(valueObject, (JSONArray)valueFilter)) continue;
                }
                if (valueFilter.equals(valueObject)) continue;
            }
            return true;
        }
        finally {
            return false;
        }
    }

    public static Object getPathValue(Object object, String path) {
        Object pointer = object;
        if (!"".equals(path) && path != null) {
            StringTokenizer st = new StringTokenizer(path, ".");
            while (st.hasMoreTokens()) {
                String pathNext = st.nextToken();
                if (pathNext.startsWith("value(")) {
                    pointer = JSONTools.evalStringMethod(null, pathNext);
                    continue;
                }
                if (pointer == null) {
                    return null;
                }
                if (pointer instanceof JSONObject) {
                    JSONObject joPointer = (JSONObject)pointer;
                    pointer = joPointer.opt(pathNext);
                    continue;
                }
                if (pointer instanceof JSONArray) {
                    JSONArray jaPointer = (JSONArray)pointer;
                    pointer = jaPointer.opt(Integer.valueOf(pathNext));
                    continue;
                }
                pointer = pointer instanceof String ? JSONTools.evalStringMethod((String)pointer, pathNext) : null;
            }
        }
        return pointer;
    }

    public static Object evalStringMethod(String source, String method) {
        Object rv = source;
        if (!"".equals(method) && method != null) {
            Pattern fnPattern = Pattern.compile("([a-z]+)\\((.*)\\)", 6);
            Matcher fnMatcher = fnPattern.matcher(method);
            while (fnMatcher.find()) {
                if (fnMatcher.groupCount() <= 1) continue;
                String methodName = fnMatcher.group(1);
                String[] params = fnMatcher.group(2).split(",(?=(?:[^']*'[^']*')*[^']*$)");
                int i = 0;
                while (i < params.length) {
                    params[i] = params[i].replaceAll("^'|'$", "");
                    ++i;
                }
                if (methodName.equals("toUpperCase")) {
                    rv = source.toUpperCase();
                    continue;
                }
                if (methodName.equals("toLowerCase")) {
                    rv = source.toLowerCase();
                    continue;
                }
                if (methodName.equals("contains") && params.length > 0) {
                    rv = source.contains(params[0]);
                    continue;
                }
                if (methodName.equals("replace") && params.length > 1) {
                    rv = source.replaceAll(Pattern.quote(params[0]), params[1]);
                    continue;
                }
                if (methodName.equals("value") && params.length > 0) {
                    rv = params[0];
                    continue;
                }
                if (methodName.equals("append") && params.length > 0) {
                    rv = source + params[0];
                    continue;
                }
                if (!methodName.equals("prefix") || params.length <= 0) continue;
                rv = params[0] + source;
            }
        }
        return rv;
    }

    public static List<Object> listJSONArray(JSONArray array) {
        if (array == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> al = new ArrayList<Object>(array.length());
        int i = 0;
        while (i < array.length()) {
            al.add(i, array.get(i));
            ++i;
        }
        return al;
    }

    public static JSONObject mergeJSONObjects(JSONObject a, JSONObject b) {
        Object value;
        String field;
        Iterator<String> fieldIterator;
        JSONObject ro = new JSONObject();
        if (a != null) {
            fieldIterator = a.keys();
            while (fieldIterator.hasNext()) {
                field = fieldIterator.next();
                value = a.get(field);
                ro.put(field, value);
            }
        }
        if (b != null) {
            fieldIterator = b.keys();
            while (fieldIterator.hasNext()) {
                field = fieldIterator.next();
                value = b.get(field);
                if (ro.opt(field) instanceof JSONObject && value instanceof JSONObject) {
                    ro.put(field, JSONTools.mergeJSONObjects((JSONObject)ro.opt(field), (JSONObject)value));
                    continue;
                }
                ro.put(field, value);
            }
        }
        return ro;
    }

    public static JSONObject diffJSONObjects(JSONObject a, JSONObject b) {
        JSONObject ro = new JSONObject();
        if (b != null) {
            String field;
            Iterator<String> fieldIterator = a.keys();
            while (fieldIterator.hasNext()) {
                field = fieldIterator.next();
                Object a_value = a.get(field);
                Object b_value = b.opt(field);
                if (a_value instanceof JSONObject && b_value instanceof JSONObject) {
                    JSONObject diffReturn = JSONTools.diffJSONObjects((JSONObject)a_value, (JSONObject)b_value);
                    if (diffReturn.length() <= 0) continue;
                    ro.put(field, diffReturn);
                    continue;
                }
                if (a_value.equals(b_value)) continue;
                ro.put(field, b_value);
            }
            fieldIterator = b.keys();
            while (fieldIterator.hasNext()) {
                field = fieldIterator.next();
                Object b_value = b.get(field);
                if (a.has(field)) continue;
                ro.put(field, b_value);
            }
        }
        return ro;
    }

    public static JSONObject filterJSONObjects(JSONObject a, JSONObject b) {
        JSONObject ro = new JSONObject();
        if (a != null && b != null) {
            Iterator<String> fieldIterator = b.keys();
            while (fieldIterator.hasNext()) {
                String field = fieldIterator.next();
                Object a_value = a.opt(field);
                Object b_value = b.opt(field);
                if (a_value instanceof JSONObject && b_value instanceof JSONObject) {
                    JSONObject diffReturn = JSONTools.filterJSONObjects((JSONObject)a_value, (JSONObject)b_value);
                    if (diffReturn.length() <= 0) continue;
                    ro.put(field, diffReturn);
                    continue;
                }
                if (a_value != null) {
                    if (a_value.equals(b_value)) continue;
                    ro.put(field, a_value);
                    continue;
                }
                if (a_value != null) continue;
                ro.put(field, a_value);
            }
        }
        return ro;
    }

    public static Collection<JSONObject> dissectJSONObject(JSONObject aJsonObject) {
        ArrayList<JSONObject> rList = new ArrayList<JSONObject>();
        if (aJsonObject != null) {
            Iterator<String> fieldIterator = aJsonObject.keys();
            while (fieldIterator.hasNext()) {
                String field = fieldIterator.next();
                Object aJsonObjectValue = aJsonObject.opt(field);
                if (aJsonObjectValue instanceof JSONObject) {
                    ArrayList<String> keys = new ArrayList<String>();
                    keys.add(field);
                    Collection<JSONObject> disectReturn = JSONTools.dissectJSONObject((JSONObject)aJsonObjectValue);
                    Collection remapped = disectReturn.stream().map(dr -> JSONTools.buildJSONPath(keys, dr)).collect(Collectors.toList());
                    rList.addAll(remapped);
                    continue;
                }
                JSONObject ro = new JSONObject();
                ro.put(field, aJsonObjectValue);
                rList.add(ro);
            }
        }
        return rList;
    }

    public static JSONObject buildJSONPath(List<String> keys, Object finalValue) {
        int endIndex;
        JSONObject ro = new JSONObject();
        String[] keysArray = keys.toArray(new String[keys.size()]);
        int i = endIndex = keysArray.length - 1;
        while (i > -1) {
            if (i == endIndex) {
                ro.put(keysArray[i], finalValue);
            } else {
                JSONObject levelDown = ro;
                ro = new JSONObject();
                ro.put(keysArray[i], levelDown);
            }
            --i;
        }
        return ro;
    }

    public static void main(String[] args) {
        JSONObject filter = new JSONObject();
        filter.put("person", new JSONObject("{\"age\": 27}"));
        filter.put("times", new JSONArray("[ 43 ]"));
        filter.put("classes", new JSONArray("[ {\"level\": 102} ]"));
        JSONObject data = new JSONObject();
        data.put("person", new JSONObject("{\"age\": 27, \"gender\": \"male\"}"));
        data.put("times", new JSONArray("[15, 25, 43, 22]"));
        data.put("place", "Ohio");
        JSONArray classes = new JSONArray();
        classes.put(new JSONObject("{\"level\": 101, \"name\": \"biology\"}"));
        classes.put(new JSONObject("{\"level\": 102, \"name\": \"math\"}"));
        classes.put(new JSONObject("{\"level\": 103, \"name\": \"science\"}"));
        data.put("classes", classes);
        System.err.println("Comparing: " + data.toString());
        System.err.println("Against Filter: " + filter.toString());
        System.err.println("");
        if (JSONTools.matchesFilter((Object)data, filter)) {
            System.err.println("matchesFilter() returned TRUE");
        } else {
            System.err.println("matchesFilter() returned FALSE");
        }
        System.err.println("");
        System.err.println("getPathValue person.gender (exists) = " + String.valueOf(JSONTools.getPathValue(data, "person.gender")));
        System.err.println("getPathValue times (exists) = " + String.valueOf(JSONTools.getPathValue(data, "times")));
        System.err.println("getPathValue value('hello,').append('world') (value) = " + String.valueOf(JSONTools.getPathValue(data, "value('hello, ').append('world')")));
        System.err.println("getPathValue classes.0.name.replace('log','boss') (exists) = " + String.valueOf(JSONTools.getPathValue(data, "classes.0.name.replace('log','boss')")));
        System.err.println("getPathValue times.0 (exists) = " + String.valueOf(JSONTools.getPathValue(data, "times.0")));
        System.err.println("getPathValue times.44 (not exists) = " + String.valueOf(JSONTools.getPathValue(data, "times.44")));
        System.err.println("getPathValue person.wonky (not exists) = " + String.valueOf(JSONTools.getPathValue(data, "person.wonky")));
        System.err.println("getPathValue classes.0.name.contra() (not exists) = " + String.valueOf(JSONTools.getPathValue(data, "classes.0.name.contra()")));
        System.err.println("getPathValue \"\" (blank) " + String.valueOf(JSONTools.getPathValue(data, "")));
        System.err.println("getPathValue null (null) " + String.valueOf(JSONTools.getPathValue(data, null)));
        JSONObject a = new JSONObject();
        a.put("Home", "Town");
        JSONObject job = new JSONObject();
        job.put("clerical", true);
        job.put("years", 15);
        job.put("other", new JSONObject().put("style", true).put("clever", true));
        a.put("JOB", job);
        JSONObject b = new JSONObject();
        b.put("Homers", "Towns");
        JSONObject jobb = new JSONObject();
        jobb.put("clericals", true);
        jobb.put("years", 3);
        jobb.put("other", new JSONObject().put("style", false).put("clever", true));
        b.put("JOB", jobb);
        System.err.println();
        JSONObject merge = JSONTools.mergeJSONObjects(a, b);
        System.err.println("MERGE A+B " + merge.toString(2));
        System.err.println();
        JSONObject diff = JSONTools.diffJSONObjects(a, b);
        System.err.println("DIFF A+B " + diff.toString(2));
        System.err.println();
        JSONObject doubleMerge = JSONTools.mergeJSONObjects(a, diff);
        System.err.println("MERGE2 A+DIFF " + doubleMerge.toString(2));
        System.err.println();
        JSONObject diffDoubleMerge = JSONTools.diffJSONObjects(merge, doubleMerge);
        System.err.println("DIFF merge+merge2 " + diffDoubleMerge.toString(2));
        System.err.println();
        JSONObject filterObjects = JSONTools.filterJSONObjects(doubleMerge, new JSONObject("{\"JOB\": {\"other\": { \"clever\":\"fuck\"}}}"));
        System.err.println("FILTER " + filterObjects.toString(2));
        System.err.println();
        Collection<JSONObject> disection = JSONTools.dissectJSONObject(doubleMerge);
        disection.forEach(jo -> System.err.println("DISECT " + jo.toString()));
    }
}

