/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.json.JSONObject;
import org.openstatic.MidiTools;

public class JSONObjectDialog
extends JDialog
implements ActionListener {
    private JSONObject jsonObject;
    private JSONObject editedJSONObject;
    private JPanel formPanel;
    private JButton saveButton;
    private JButton deleteButton;
    private int nextField = 1;

    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton) {
            this.jsonObject = null;
            this.dispose();
        }
        if (e.getSource() == this.saveButton) {
            Iterator<String> keyIterator = this.editedJSONObject.keys();
            while (keyIterator.hasNext()) {
                String key = keyIterator.next();
                this.jsonObject.put(key, this.editedJSONObject.get(key));
            }
            System.err.println(this.jsonObject.toString());
            this.dispose();
        }
    }

    public void createStringInput(final String field, String value) {
        final JTextField stringInput = new JTextField(value);
        stringInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                JSONObjectDialog.this.editedJSONObject.put(field, stringInput.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                JSONObjectDialog.this.editedJSONObject.put(field, stringInput.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                JSONObjectDialog.this.editedJSONObject.put(field, stringInput.getText());
            }
        });
        this.formPanel.add((Component)new JLabel(field, 2), this.gbc(1, 0.4));
        this.formPanel.add((Component)stringInput, this.gbc(2, 0.6));
        ++this.nextField;
    }

    public void createIntegerInput(final String field, int value) {
        NumberFormat longFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(longFormat);
        numberFormatter.setValueClass(Integer.class);
        numberFormatter.setAllowsInvalid(false);
        final JFormattedTextField integerInput = new JFormattedTextField(numberFormatter);
        integerInput.setText(String.valueOf(value));
        integerInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    JSONObjectDialog.this.editedJSONObject.put(field, (Integer)integerInput.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    JSONObjectDialog.this.editedJSONObject.put(field, (Integer)integerInput.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                try {
                    JSONObjectDialog.this.editedJSONObject.put(field, (Integer)integerInput.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.formPanel.add((Component)new JLabel(field, 2), this.gbc(1, 0.4));
        this.formPanel.add((Component)integerInput, this.gbc(2, 0.6));
        ++this.nextField;
    }

    public void createBooleanInput(final String field, boolean value) {
        Vector<String> booleanInputs = new Vector<String>();
        booleanInputs.add("true");
        booleanInputs.add("false");
        final JComboBox booleanInput = new JComboBox();
        booleanInput.setModel(new DefaultComboBoxModel(booleanInputs));
        if (value) {
            booleanInput.setSelectedIndex(0);
        } else {
            booleanInput.setSelectedIndex(1);
        }
        booleanInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (booleanInput.getSelectedIndex() == 0) {
                    JSONObjectDialog.this.editedJSONObject.put(field, true);
                } else {
                    JSONObjectDialog.this.editedJSONObject.put(field, false);
                }
            }
        });
        this.formPanel.add((Component)new JLabel(field, 2), this.gbc(1, 0.4));
        this.formPanel.add(booleanInput, this.gbc(2, 0.6));
        ++this.nextField;
    }

    public JSONObjectDialog(String title, JSONObject jsonObject) {
        super(MidiTools.instance, title, true);
        this.jsonObject = jsonObject;
        this.editedJSONObject = new JSONObject(jsonObject.toString());
        this.setLayout(new BorderLayout());
        this.formPanel = new JPanel(new GridBagLayout());
        Iterator<String> keyIterator = this.jsonObject.keys();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            try {
                boolean value = this.jsonObject.getBoolean(key);
                this.createBooleanInput(key, value);
            }
            catch (Exception e1) {
                try {
                    int value = this.jsonObject.getInt(key);
                    this.createIntegerInput(key, value);
                }
                catch (Exception e2) {
                    try {
                        String value = this.jsonObject.getString(key);
                        this.createStringInput(key, value);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.saveButton = new JButton("Save");
        this.deleteButton = new JButton("Cancel");
        this.saveButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.saveButton);
        this.formPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.formPanel, "First");
        this.add((Component)buttonPanel, "Last");
        this.centerWindow();
    }

    private GridBagConstraints gbc(int x, double weightx) {
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.weightx = weightx;
        g.gridx = x;
        g.gridy = this.nextField;
        g.ipady = 2;
        g.ipadx = 5;
        return g;
    }

    public JPanel labelComponent(String label, Component c) {
        JPanel x = new JPanel(new GridLayout(1, 2));
        x.add(new JLabel(label, 0));
        x.add(c);
        return x;
    }

    public void centerWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        float WIDTH = screenSize.width;
        float HEIGHT = screenSize.height;
        int wWidth = 400;
        int wHeight = 350;
        int x = (int)(WIDTH / 2.0f - (float)wWidth / 2.0f);
        int y = (int)(HEIGHT / 2.0f - (float)wHeight / 2.0f);
        this.setBounds(x, y, wWidth, wHeight);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.setVisible(true);
    }
}

