/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openstatic.routeput.BLOBFile;
import org.openstatic.routeput.BLOBManager;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutMessageListener;
import org.openstatic.routeput.RoutePutPropertyChangeMessage;
import org.openstatic.routeput.RoutePutRemoteSession;
import org.openstatic.routeput.RoutePutServer;
import org.openstatic.routeput.RoutePutSession;

public class ApiServlet
extends HttpServlet
implements RoutePutSession {
    private JSONObject properties = new JSONObject();
    private long rxPackets;
    private long txPackets;
    private Map<RoutePutChannel, Date> lastChannelInteraction;

    public ApiServlet() {
        this.properties.put("description", "Virtual Session for API GET/POST messages");
        this.rxPackets = 0L;
        this.txPackets = 0L;
        RoutePutServer.logIt("** API SERVLET INITIALIZED **");
        RoutePutServer.instance.apiServlet = this;
        this.lastChannelInteraction = new HashMap<RoutePutChannel, Date>();
        this.lastChannelInteraction = Collections.synchronizedMap(this.lastChannelInteraction);
    }

    public RoutePutMessage readRoutePutMessagePOST(HttpServletRequest request) {
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            RoutePutServer.logError(e);
        }
        try {
            RoutePutMessage jsonObject = new RoutePutMessage(jb.toString().trim());
            return jsonObject;
        }
        catch (JSONException e) {
            RoutePutServer.logError(e);
            return new RoutePutMessage();
        }
    }

    public JSONArray readJSONArrayPOST(HttpServletRequest request) {
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            RoutePutServer.logError(e);
        }
        try {
            JSONArray jsonArray = new JSONArray(jb.toString().trim());
            return jsonArray;
        }
        catch (JSONException e) {
            RoutePutServer.logError(e);
            return new JSONArray();
        }
    }

    public void everySecond() {
        long cTime = System.currentTimeMillis();
        ArrayList<RoutePutChannel> idleChannels = new ArrayList<RoutePutChannel>();
        this.lastChannelInteraction.forEach((k, v) -> {
            if (cTime - v.getTime() > 300000L) {
                idleChannels.add((RoutePutChannel)k);
            }
        });
        idleChannels.forEach(c -> {
            c.removeMember(this);
            this.lastChannelInteraction.remove(c);
        });
    }

    private synchronized void handleAPIMessage(String remoteIP, RoutePutMessage msg) {
        RoutePutChannel channel = msg.getRoutePutChannel();
        this.lastChannelInteraction.put(channel, new Date(System.currentTimeMillis()));
        String sourceId = msg.getSourceId();
        if (sourceId != null) {
            if (sourceId.equals(this.getConnectionId())) {
                if (!channel.hasMember(this)) {
                    channel.addMember(this);
                }
                channel.onMessage(this, msg);
            } else {
                boolean sendConnect = false;
                RoutePutRemoteSession remoteSession = RoutePutRemoteSession.findRemoteSession(sourceId);
                if (remoteSession == null) {
                    sendConnect = true;
                } else if (remoteSession.hasParent(this) && !channel.hasMember(remoteSession)) {
                    sendConnect = true;
                }
                if (sendConnect) {
                    RoutePutMessage cMsg = new RoutePutMessage();
                    cMsg.setSourceId(sourceId);
                    cMsg.setType("ConnectionStatus");
                    cMsg.setMetaField("connected", true);
                    cMsg.setMetaField("remoteIP", remoteIP);
                    JSONObject props = new JSONObject();
                    props.put("idleDestruct", msg.getRoutePutMeta().optLong("idleDestruct", 900000L));
                    props.put("description", "Virtual Connection for API messages");
                    cMsg.setMetaField("properties", props);
                    cMsg.setChannel(channel);
                    RoutePutRemoteSession.handleRoutedMessage(this, cMsg);
                }
                RoutePutRemoteSession.handleRoutedMessage(this, msg);
            }
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/javascript");
        httpServletResponse.setStatus(200);
        httpServletResponse.setCharacterEncoding("iso-8859-1");
        httpServletResponse.addHeader("Server", "Routeput 1.0");
        String target = request.getPathInfo().replace("+", " ");
        String remoteIP = request.getRemoteAddr();
        JSONObject response = new JSONObject();
        try {
            String sourceId = this.getConnectionId();
            if (target.startsWith("/post/")) {
                RoutePutMessage post = this.readRoutePutMessagePOST(request);
                StringTokenizer st = new StringTokenizer(target, "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals("channel") && st.hasMoreTokens()) {
                        post.setChannel(RoutePutChannel.getChannel(st.nextToken()));
                    }
                    if (!token.equals("id") || !st.hasMoreTokens()) continue;
                    sourceId = st.nextToken();
                }
                post.setSourceIdIfNull(sourceId);
                post.setMetaField("apiPost", true);
                RoutePutChannel chan = post.getRoutePutChannel();
                ++this.rxPackets;
                this.handleAPIMessage(remoteIP, post);
            } else if (target.startsWith("/batch/")) {
                RoutePutChannel channel = null;
                StringTokenizer st = new StringTokenizer(target, "/");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals("channel") && st.hasMoreTokens()) {
                        channel = RoutePutChannel.getChannel(st.nextToken());
                    }
                    if (!token.equals("id") || !st.hasMoreTokens()) continue;
                    sourceId = st.nextToken();
                }
                RoutePutChannel finalChannel = channel;
                String finalSourceId = sourceId;
                JSONArray post = this.readJSONArrayPOST(request);
                post.forEach(msg -> {
                    if (msg instanceof JSONObject) {
                        RoutePutMessage rMsg = new RoutePutMessage((JSONObject)msg);
                        rMsg.setChannelIfNull(finalChannel);
                        rMsg.setSourceIdIfNull(finalSourceId);
                        rMsg.setMetaField("apiBatch", true);
                        RoutePutChannel chan = rMsg.getRoutePutChannel();
                        ++this.rxPackets;
                        this.handleAPIMessage(remoteIP, rMsg);
                    }
                });
            }
        }
        catch (Exception e) {
            RoutePutServer.logError("doPOST API", e);
        }
        httpServletResponse.getWriter().println(response.toString());
    }

    public static boolean isNumber(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block19: {
            httpServletResponse.setContentType("text/javascript");
            httpServletResponse.setStatus(200);
            httpServletResponse.setCharacterEncoding("iso-8859-1");
            httpServletResponse.addHeader("Server", "Routeput 1.0");
            target = request.getPathInfo().replace("+", " ");
            remoteIP = request.getRemoteAddr();
            response = new JSONObject();
            try {
                if (target.startsWith("/channel/")) {
                    st = new StringTokenizer(target, "/");
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        if (!token.equals("channel") || !st.hasMoreTokens()) continue;
                        channelName = st.nextToken();
                        channel = RoutePutChannel.getChannel(channelName);
                        response = channel.toJSONObject();
                        if (!st.hasMoreTokens()) continue;
                        token = st.nextToken();
                        if ("removeProperty".equals(token) && st.hasMoreTokens()) {
                            token = st.nextToken();
                            channel.removeProperty(this, token);
                            response = channel.toJSONObject();
                            continue;
                        }
                        if ("properties".equals(token)) {
                            response = channel.getProperties();
                            continue;
                        }
                        if ("members".equals(token)) {
                            response = channel.membersAsJSONObject();
                            continue;
                        }
                        if ("setProperty".equals(token)) {
                            rppcm = new RoutePutPropertyChangeMessage();
                            channelProperties = channel.getProperties();
                            request.getParameterMap().forEach((BiConsumer<String, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$3(org.openstatic.routeput.RoutePutPropertyChangeMessage org.openstatic.routeput.RoutePutChannel org.json.JSONObject java.lang.String java.lang.String[] ), (Ljava/lang/String;[Ljava/lang/String;)V)((RoutePutPropertyChangeMessage)rppcm, (RoutePutChannel)channel, (JSONObject)channelProperties));
                            rppcm.processUpdates(this);
                            continue;
                        }
                        if ("transmit".equals(token)) {
                            ++this.rxPackets;
                            msg = new RoutePutMessage();
                            msg.setChannel(channel);
                            request.getParameterMap().forEach((BiConsumer<String, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$4(org.openstatic.routeput.RoutePutMessage java.lang.String java.lang.String[] ), (Ljava/lang/String;[Ljava/lang/String;)V)((RoutePutMessage)msg));
                            msg.setSourceIdIfNull(this.getConnectionId());
                            this.handleAPIMessage(remoteIP, msg);
                            continue;
                        }
                        if (!"blob".equals(token)) continue;
                        token = st.nextToken();
                        contentType = BLOBManager.getContentTypeFor(token);
                        httpServletResponse.setContentType(contentType);
                        httpServletResponse.setStatus(200);
                        httpServletResponse.setCharacterEncoding("iso-8859-1");
                        inputStream = new FileInputStream(new File(channel.getBlobFolder(), token));
                        output = httpServletResponse.getOutputStream();
                        inputStream.transferTo(output);
                        output.flush();
                        inputStream.close();
                        return;
                    }
                    break block19;
                }
                if (!target.startsWith("/blob/")) ** GOTO lbl94
                st = new StringTokenizer(target, "/");
                context = null;
                token = st.nextToken();
                blobContext = BLOBManager.getBlobRoot();
                while (blobContext.isDirectory() && st.hasMoreTokens()) {
                    token = st.nextToken();
                    blobContext = new File(blobContext, token);
                }
                if (blobContext.isDirectory()) {
                    if (!"blob".equals(token)) {
                        context = token;
                    }
                    ja = new JSONArray();
                    ja = new JSONArray();
                    names = blobContext.list();
                    i = 0;
                    while (i < names.length) {
                        file = new BLOBFile(blobContext, context, names[i]);
                        ja.put(file.toJSONObject());
                        ++i;
                    }
                    response.put(token, ja);
                } else {
                    contentType = BLOBManager.getContentTypeFor(token);
                    httpServletResponse.setContentType(contentType);
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setCharacterEncoding("iso-8859-1");
                    inputStream = new FileInputStream(blobContext);
                    output = httpServletResponse.getOutputStream();
                    inputStream.transferTo(output);
                    output.flush();
                    inputStream.close();
                    return;
lbl94:
                    // 1 sources

                    if ("/channels/".equals(target)) {
                        response.put("channels", RoutePutChannel.channelBreakdown());
                    } else if ("/channels/stats/".equals(target)) {
                        response.put("channels", RoutePutServer.instance.channelStats());
                    } else if ("/upstream/".equals(target)) {
                        channel = RoutePutChannel.getChannel(request.getParameter("channel"));
                        uri = request.getParameter("uri");
                        session = RoutePutServer.instance.connectUpstream(channel, uri);
                        response.put("session", session.toJSONObject());
                    }
                }
            }
            catch (Exception x) {
                RoutePutServer.logError("doGET API", x);
            }
        }
        httpServletResponse.getWriter().println(response.toString());
    }

    @Override
    public void send(RoutePutMessage jo) {
        ++this.txPackets;
    }

    @Override
    public String getConnectionId() {
        return "api-" + RoutePutChannel.getHostname();
    }

    @Override
    public RoutePutChannel getDefaultChannel() {
        return null;
    }

    @Override
    public String getRemoteIP() {
        return null;
    }

    @Override
    public JSONObject getProperties() {
        this.properties.put("_class", "ApiServlet");
        return this.properties;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jo = new JSONObject();
        jo.put("connectionId", this.getConnectionId());
        List channels = RoutePutChannel.channelsWithMember(this).stream().map(c -> c.getName()).collect(Collectors.toList());
        jo.put("channels", new JSONArray(channels));
        if (this.rxPackets > 0L) {
            jo.put("rx", this.rxPackets);
        }
        if (this.txPackets > 0L) {
            jo.put("tx", this.txPackets);
        }
        jo.put("properties", this.properties);
        return jo;
    }

    @Override
    public boolean isConnected() {
        return RoutePutServer.instance.apiServlet == this;
    }

    @Override
    public boolean isRootConnection() {
        return true;
    }

    @Override
    public boolean containsConnectionId(String connectionId) {
        return RoutePutRemoteSession.isChild(this, connectionId) || this.getConnectionId().equals(connectionId);
    }

    @Override
    public void addMessageListener(RoutePutMessageListener r) {
    }

    @Override
    public void removeMessageListener(RoutePutMessageListener r) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void firePropertyChange(String key, Object oldValue, Object newValue) {
    }

    private static /* synthetic */ void lambda$3(RoutePutPropertyChangeMessage routePutPropertyChangeMessage, RoutePutChannel routePutChannel, JSONObject jSONObject, String key, String[] value) {
        if ("true".equals(value[0])) {
            routePutPropertyChangeMessage.addUpdate(routePutChannel, key, jSONObject.opt(key), (Object)true);
        } else if ("false".equals(value[0])) {
            routePutPropertyChangeMessage.addUpdate(routePutChannel, key, jSONObject.opt(key), (Object)false);
        } else if (ApiServlet.isNumber(value[0])) {
            routePutPropertyChangeMessage.addUpdate(routePutChannel, key, jSONObject.opt(key), (Object)Double.valueOf(value[0]));
        } else {
            routePutPropertyChangeMessage.addUpdate(routePutChannel, key, jSONObject.opt(key), (Object)value[0]);
        }
    }

    private static /* synthetic */ void lambda$4(RoutePutMessage routePutMessage, String key, String[] value) {
        Object realValue = value[0];
        if ("true".equals(value[0])) {
            realValue = true;
        } else if ("false".equals(value[0])) {
            realValue = false;
        } else if (ApiServlet.isNumber(value[0])) {
            realValue = Double.valueOf(value[0]);
        }
        if ("srcId".equals(key)) {
            routePutMessage.setSourceId(value[0]);
        } else if ("dstId".equals(key)) {
            routePutMessage.setTargetId(value[0]);
        } else if ("type".equals(key)) {
            routePutMessage.setType(value[0]);
        } else if ("idleDestruct".equals(key)) {
            routePutMessage.getRoutePutMeta().put("idleDestruct", Long.valueOf(value[0]));
        } else if (key.startsWith("where_")) {
            JSONObject where = routePutMessage.getRoutePutMeta().optJSONObject("where");
            if (where == null) {
                where = new JSONObject();
            }
            where.put(key.substring(6), realValue);
            routePutMessage.getRoutePutMeta().put("where", where);
        } else {
            routePutMessage.put(key, realValue);
        }
    }
}

