/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutSession;

public class RoutePutOutputStream
extends OutputStream
implements Runnable {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private RoutePutSession session;
    private Thread autoFlush;
    private boolean closed;
    private RoutePutChannel channel;
    private String targetId;

    public RoutePutOutputStream(RoutePutSession session) {
        this.session = session;
        this.channel = session.getDefaultChannel();
        this.closed = false;
        this.targetId = null;
        this.autoFlush = new Thread(this);
        this.autoFlush.start();
    }

    public RoutePutOutputStream(RoutePutSession session, RoutePutChannel channel) {
        this.session = session;
        this.channel = channel;
        this.closed = false;
        this.targetId = null;
        this.autoFlush = new Thread(this);
        this.autoFlush.start();
    }

    public void setTargetId(String connectionId) {
        this.targetId = connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        RoutePutOutputStream routePutOutputStream = this;
        synchronized (routePutOutputStream) {
            this.baos.write(b);
        }
        if (this.baos.size() >= 256) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        RoutePutOutputStream routePutOutputStream = this;
        synchronized (routePutOutputStream) {
            RoutePutMessage msg = new RoutePutMessage();
            msg.setType("binary");
            msg.setChannel(this.channel);
            if (this.targetId != null) {
                msg.setTargetId(this.targetId);
            }
            msg.put("data", Base64.getEncoder().encodeToString(this.baos.toByteArray()));
            this.baos.reset();
            this.session.send(msg);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }
}

