/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi;

import io.github.leovr.rtipmidi.JavaxAppleMidiSession;
import io.github.leovr.rtipmidi.error.AppleMidiSessionInstantiationException;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationAccepted;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationDeclined;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class MidiTransmitterAppleMidiSession
extends JavaxAppleMidiSession {
    private final List<Transmitter> transmitters;

    public MidiTransmitterAppleMidiSession(@Nonnull Transmitter transmitter) throws AppleMidiSessionInstantiationException {
        this(Collections.singletonList(transmitter));
    }

    public MidiTransmitterAppleMidiSession(@Nonnull List<Transmitter> transmitters) {
        this.transmitters = transmitters;
        for (Transmitter transmitter : transmitters) {
            transmitter.setReceiver(new SimpleReceiver());
        }
    }

    public void onMidiInvitationAccepted(@Nonnull AppleMidiInvitationAccepted acceptance, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    public void onMidiInvitationDeclined(@Nonnull AppleMidiInvitationDeclined decline, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    private class SimpleReceiver
    implements Receiver {
        private SimpleReceiver() {
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            MidiTransmitterAppleMidiSession.this.sendMidiMessage(message, timeStamp);
        }

        @Override
        public void close() {
        }
    }
}

