/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.plugins.jinput.xinput;

import de.ralleytn.plugins.jinput.xinput.XIComponent;
import de.ralleytn.plugins.jinput.xinput.XIEventFactory;
import de.ralleytn.plugins.jinput.xinput.XIPollData;
import de.ralleytn.plugins.jinput.xinput.XIRumbler;
import de.ralleytn.plugins.jinput.xinput.XInputEnvironmentPlugin;
import de.ralleytn.wrapper.microsoft.xinput.XInputState;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import net.java.games.input.AbstractController;
import net.java.games.input.Controller;
import net.java.games.input.Event;

final class XIController
extends AbstractController {
    private final int dwUserIndex;
    private XInputState oldState;
    private Queue<Event> events = new ArrayBlockingQueue<Event>(this.eventQueueSize);
    private int eventQueueSize = 32;

    protected XIController(int dwUserIndex, String name, XIComponent[] components, XIRumbler[] rumblers) {
        super(name, components, null, rumblers);
        this.dwUserIndex = dwUserIndex;
        this.oldState = new XInputState();
    }

    @Override
    public final Controller.Type getType() {
        return Controller.Type.GAMEPAD;
    }

    protected final int getEventQueueSize() {
        return this.eventQueueSize;
    }

    protected final int getUserIndex() {
        return this.dwUserIndex;
    }

    @Override
    protected final synchronized void setDeviceEventQueueSize(int size) throws IOException {
        this.eventQueueSize = size;
        ArrayBlockingQueue<Event> events = new ArrayBlockingQueue<Event>(size);
        while (!this.events.isEmpty()) {
            events.offer(this.events.poll());
        }
        this.events = events;
    }

    @Override
    protected final synchronized void pollDevice() throws IOException {
        XInputState newState = new XInputState();
        int code = XInputEnvironmentPlugin.XINPUT.XInputGetState(this.dwUserIndex, newState);
        if (code == 0) {
            if (newState.dwPacketNumber != this.oldState.dwPacketNumber) {
                XIPollData oldPollData = new XIPollData(this.oldState.Gamepad);
                XIPollData newPollData = new XIPollData(newState.Gamepad);
                XIEventFactory difference = new XIEventFactory(this, oldPollData, newPollData);
                List<Event> events = difference.createEvents();
                for (Event event : events) {
                    if (this.events.size() >= this.eventQueueSize) continue;
                    this.events.offer(event);
                }
                this.oldState = newState;
            }
        } else {
            throw new IOException("XUser" + this.dwUserIndex);
        }
    }

    @Override
    protected final synchronized boolean getNextDeviceEvent(Event event) throws IOException {
        if (!this.events.isEmpty()) {
            event.set(this.events.poll());
            return true;
        }
        return false;
    }
}

