/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.plugins.jinput.xinput;

import de.ralleytn.plugins.jinput.xinput.XIButton;
import de.ralleytn.plugins.jinput.xinput.XIComponent;
import de.ralleytn.plugins.jinput.xinput.XIController;
import de.ralleytn.plugins.jinput.xinput.XILeftThumbStick;
import de.ralleytn.plugins.jinput.xinput.XIPOV;
import de.ralleytn.plugins.jinput.xinput.XIRightThumbStick;
import de.ralleytn.plugins.jinput.xinput.XIRumbler;
import de.ralleytn.plugins.jinput.xinput.XITrigger;
import de.ralleytn.wrapper.microsoft.xinput.XInput;
import de.ralleytn.wrapper.microsoft.xinput.XInputCapabilities;
import de.ralleytn.wrapper.microsoft.xinput.XInputState;
import de.ralleytn.wrapper.microsoft.xinput.XInputVibration;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DirectAndRawInputEnvironmentPlugin;
import net.java.games.util.plugins.Plugin;

public final class XInputEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    protected static final XInput XINPUT = XInputEnvironmentPlugin.isWindows() ? XInput.create() : null;
    private Controller[] controllers;
    private boolean supported;
    private List<Integer> alreadyUsedUserIndices;

    public XInputEnvironmentPlugin() {
        boolean bl = this.supported = XINPUT != null;
        if (this.supported) {
            this.alreadyUsedUserIndices = new ArrayList<Integer>();
            this.controllers = this.createControllers();
        }
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    private final int getNextUserIndex() {
        for (int dwUserIndex = 0; dwUserIndex < 4; ++dwUserIndex) {
            boolean connected;
            int code = XINPUT.XInputGetState(dwUserIndex, new XInputState());
            boolean bl = connected = code == 0;
            if (this.alreadyUsedUserIndices.contains(dwUserIndex) || !connected) continue;
            this.alreadyUsedUserIndices.add(dwUserIndex);
            return dwUserIndex;
        }
        return -1;
    }

    private final Controller[] createControllers() {
        Controller[] defaultControllers = new DirectAndRawInputEnvironmentPlugin().getControllers();
        Controller[] controllers = new Controller[defaultControllers.length];
        for (int index = 0; index < defaultControllers.length; ++index) {
            XInputCapabilities capabilities;
            int code;
            int dwUserIndex;
            boolean replaced = false;
            Controller controller = defaultControllers[index];
            if (XInputEnvironmentPlugin.isXInput(controller) && (dwUserIndex = this.getNextUserIndex()) != -1 && (code = XINPUT.XInputGetCapabilities(dwUserIndex, 1, capabilities = new XInputCapabilities())) == 0) {
                boolean hasLeftMotor = capabilities.Vibration.wLeftMotorSpeed > 0;
                boolean hasRightMotor = capabilities.Vibration.wRightMotorSpeed > 0;
                boolean noNavigation = (capabilities.Flags & 0x10) != 0;
                XIComponent[] components = this.createComponents(noNavigation);
                XIRumbler[] rumblers = this.createRumblers(dwUserIndex, hasLeftMotor, hasRightMotor);
                controllers[index] = new XIController(dwUserIndex, controller.getName(), components, rumblers);
                replaced = true;
            }
            if (replaced) continue;
            controllers[index] = controller;
        }
        return controllers;
    }

    private final XIComponent[] createComponents(boolean noNavigation) {
        ArrayList<XIComponent> components = new ArrayList<XIComponent>();
        components.add(new XIButton("a", Component.Identifier.Button._0));
        components.add(new XIButton("b", Component.Identifier.Button._1));
        components.add(new XIButton("x", Component.Identifier.Button._2));
        components.add(new XIButton("y", Component.Identifier.Button._3));
        components.add(new XIButton("lb", Component.Identifier.Button._4));
        components.add(new XIButton("rb", Component.Identifier.Button._5));
        if (noNavigation) {
            components.add(new XIButton("lthumb", Component.Identifier.Button._6));
            components.add(new XIButton("rthumb", Component.Identifier.Button._7));
        } else {
            components.add(new XIButton("back", Component.Identifier.Button._6));
            components.add(new XIButton("start", Component.Identifier.Button._7));
            components.add(new XIButton("lthumb", Component.Identifier.Button._8));
            components.add(new XIButton("rthumb", Component.Identifier.Button._9));
            components.add(new XIPOV());
        }
        components.add(new XITrigger(Component.Identifier.Axis.Z));
        components.add(new XITrigger(Component.Identifier.Axis.RZ));
        components.add(new XILeftThumbStick(Component.Identifier.Axis.X));
        components.add(new XILeftThumbStick(Component.Identifier.Axis.Y));
        components.add(new XIRightThumbStick(Component.Identifier.Axis.RX));
        components.add(new XIRightThumbStick(Component.Identifier.Axis.RY));
        return components.toArray(new XIComponent[components.size()]);
    }

    private final XIRumbler[] createRumblers(int userIndex, boolean hasLeftMotor, boolean hasRightMotor) {
        XInputVibration vibration = new XInputVibration();
        ArrayList<XIRumbler> rumblers = new ArrayList<XIRumbler>();
        if (hasLeftMotor) {
            rumblers.add(new XIRumbler(Component.Identifier.Axis.X, vibration, userIndex));
        }
        if (hasRightMotor) {
            rumblers.add(new XIRumbler(Component.Identifier.Axis.RX, vibration, userIndex));
        }
        return rumblers.toArray(new XIRumbler[rumblers.size()]);
    }

    private static final boolean isXInput(Controller controller) {
        Component[] components = controller.getComponents();
        boolean hasXAxis = false;
        boolean hasYAxis = false;
        boolean hasZAxis = false;
        boolean hasRXAxis = false;
        boolean hasRYAxis = false;
        boolean hasPOV = false;
        for (Component component : components) {
            Component.Identifier id = component.getIdentifier();
            if (Component.Identifier.Axis.X.equals(id)) {
                hasXAxis = true;
                continue;
            }
            if (Component.Identifier.Axis.Y.equals(id)) {
                hasYAxis = true;
                continue;
            }
            if (Component.Identifier.Axis.RX.equals(id)) {
                hasRXAxis = true;
                continue;
            }
            if (Component.Identifier.Axis.RY.equals(id)) {
                hasRYAxis = true;
                continue;
            }
            if (Component.Identifier.Axis.Z.equals(id)) {
                hasZAxis = true;
                continue;
            }
            if (!Component.Identifier.Axis.POV.equals(id)) continue;
            hasPOV = true;
        }
        return controller.getType() == Controller.Type.GAMEPAD && hasPOV && hasRXAxis && hasRYAxis && hasXAxis && hasYAxis && hasZAxis;
    }

    private static final boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }
}

