/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi;

import io.github.leovr.rtipmidi.JavaxAppleMidiSession;
import io.github.leovr.rtipmidi.MidiDeviceMode;
import io.github.leovr.rtipmidi.MidiDeviceModePair;
import io.github.leovr.rtipmidi.error.AppleMidiSessionInstantiationException;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationAccepted;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationDeclined;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;

public class MidiDeviceAppleMidiSession
extends JavaxAppleMidiSession {
    private final List<MidiDevice> midiDevices = new ArrayList<MidiDevice>();
    private List<Receiver> receivers = new ArrayList<Receiver>();

    public MidiDeviceAppleMidiSession(@Nonnull MidiDeviceModePair midiDeviceModePair) {
        this(Collections.singletonList(midiDeviceModePair));
    }

    public MidiDeviceAppleMidiSession(Collection<MidiDeviceModePair> midiDeviceModePairs) {
        for (MidiDeviceModePair pair : midiDeviceModePairs) {
            MidiDevice device = pair.getDevice();
            MidiDeviceMode mode = pair.getMode();
            this.openMidiDevice(device);
            this.initReading(device, mode);
            this.initWriting(device, mode);
            this.midiDevices.add(device);
        }
    }

    private void initWriting(@Nonnull MidiDevice midiDevice, @Nonnull MidiDeviceMode deviceMode) {
        if (deviceMode == MidiDeviceMode.BIDIRECTIONAL || deviceMode == MidiDeviceMode.WRITE_ONLY) {
            if (midiDevice.getMaxTransmitters() == 0) {
                throw new AppleMidiSessionInstantiationException("MIDI-Device cannot have any more transmitters or does not support transmitters");
            }
            try {
                midiDevice.getTransmitter().setReceiver(new MidiDeviceReceiver());
            }
            catch (MidiUnavailableException e) {
                throw new AppleMidiSessionInstantiationException("Error getting transmitter", e);
            }
        }
    }

    private void initReading(@Nonnull MidiDevice midiDevice, @Nonnull MidiDeviceMode deviceMode) {
        if (deviceMode == MidiDeviceMode.BIDIRECTIONAL || deviceMode == MidiDeviceMode.READ_ONLY) {
            if (midiDevice.getMaxReceivers() == 0) {
                throw new AppleMidiSessionInstantiationException("MIDI-Device cannot have any more receivers or does not support receivers");
            }
            try {
                this.receivers.add(midiDevice.getReceiver());
            }
            catch (MidiUnavailableException e) {
                throw new AppleMidiSessionInstantiationException("Error getting receiver", e);
            }
        }
    }

    private void openMidiDevice(@Nonnull MidiDevice midiDevice) {
        if (midiDevice.isOpen()) {
            throw new AppleMidiSessionInstantiationException("MIDI-Device is already open");
        }
        try {
            midiDevice.open();
        }
        catch (MidiUnavailableException e) {
            throw new AppleMidiSessionInstantiationException("Error opening MIDI device", e);
        }
    }

    @Override
    protected void onMidiMessage(MidiMessage message, long timestamp) {
        if (this.receivers.isEmpty()) {
            return;
        }
        for (Receiver receiver : this.receivers) {
            receiver.send(message, timestamp);
        }
    }

    @Override
    public long getCurrentTimestamp() {
        for (MidiDevice device : this.midiDevices) {
            long microsecondPosition = device.getMicrosecondPosition();
            if (microsecondPosition == -1L) continue;
            return (long)this.timestampOffset + microsecondPosition / 100L;
        }
        return -1L;
    }

    @Override
    protected void onEndSession() {
        for (MidiDevice device : this.midiDevices) {
            device.close();
        }
    }

    @Override
    public void onMidiInvitationAccepted(@Nonnull AppleMidiInvitationAccepted acceptance, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    @Override
    public void onMidiInvitationDeclined(@Nonnull AppleMidiInvitationDeclined decline, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    private class MidiDeviceReceiver
    implements Receiver {
        private MidiDeviceReceiver() {
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            MidiDeviceAppleMidiSession.this.sendMidiMessage(message, timeStamp);
        }

        @Override
        public void close() {
        }
    }
}

