/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.handler;

import io.github.leovr.rtipmidi.AppleMidiMessageListener;
import io.github.leovr.rtipmidi.handler.AppleMidiMessageLogListener;
import io.github.leovr.rtipmidi.messages.AppleMidiMessage;
import io.github.leovr.rtipmidi.messages.MidiCommandHeader;
import io.github.leovr.rtipmidi.messages.MidiTimestampPair;
import io.github.leovr.rtipmidi.messages.RtpHeader;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import io.github.leovr.rtipmidi.model.ShortMessage;
import io.github.leovr.rtipmidi.model.SysexMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleMidiMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiMessageHandler.class);
    private static final int RTP_MIDI = 97;
    private final List<AppleMidiMessageListener> listeners = new ArrayList<AppleMidiMessageListener>();

    public AppleMidiMessageHandler() {
        this.listeners.add(new AppleMidiMessageLogListener());
    }

    public void handle(@Nonnull byte[] data, @Nonnull AppleMidiServerAddress appleMidiServer) {
        try (DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(data));){
            short length;
            boolean p;
            byte header1 = dataInputStream.readByte();
            byte version = (byte)(header1 >> 6 & 3);
            boolean paddingFlag = (header1 >> 5 & 1) == 1;
            boolean extensionFlag = (header1 >> 4 & 1) == 1;
            byte contributingSourceIdentifiersCount = (byte)(header1 & 0xF);
            byte header2 = dataInputStream.readByte();
            boolean markerFlag = (header2 >> 7 & 1) == 1;
            byte payloadType = (byte)(header2 & 0x7F);
            if (payloadType != 97) {
                return;
            }
            short sequenceNumber = dataInputStream.readShort();
            int timestamp = dataInputStream.readInt();
            int ssrc = dataInputStream.readInt();
            RtpHeader rtpHeader = new RtpHeader(version, paddingFlag, extensionFlag, contributingSourceIdentifiersCount, markerFlag, payloadType, sequenceNumber, timestamp, ssrc);
            byte midiCommandHeader1 = dataInputStream.readByte();
            boolean b = (midiCommandHeader1 >> 7 & 1) == 1;
            boolean j = (midiCommandHeader1 >> 6 & 1) == 1;
            boolean z = (midiCommandHeader1 >> 5 & 1) == 1;
            boolean bl = p = (midiCommandHeader1 >> 4 & 1) == 1;
            if (b) {
                byte midiCommandHeader2 = dataInputStream.readByte();
                length = (short)((midiCommandHeader1 << 8 | midiCommandHeader2) & 0xFFF);
            } else {
                length = (short)(midiCommandHeader1 & 0xF);
            }
            MidiCommandHeader midiCommandHeader = new MidiCommandHeader(b, j, z, p, length, rtpHeader);
            byte[] midiCommandBuffer = new byte[length];
            int midiCommandBytesRead = dataInputStream.read(midiCommandBuffer);
            if ((short)midiCommandBytesRead != length) {
                return;
            }
            ArrayList<MidiTimestampPair> messages = new ArrayList<MidiTimestampPair>();
            try (DataInputStream midiInputStream = new DataInputStream(new ByteArrayInputStream(midiCommandBuffer));){
                messages.addAll(this.readMidiMessages(midiCommandHeader, midiInputStream));
            }
            this.handleMessage(new AppleMidiMessage(midiCommandHeader, messages));
        }
        catch (IOException e) {
            log.error("IOException while processing MIDI message", e);
        }
    }

    private void handleMessage(AppleMidiMessage message) {
        for (MidiTimestampPair midiPair : message.getMessages()) {
            for (AppleMidiMessageListener listener : this.listeners) {
                listener.onMidiMessage(message.getMidiCommandHeader(), midiPair.getMidiMessage(), midiPair.getTimestamp());
            }
        }
    }

    private List<MidiTimestampPair> readMidiMessages(MidiCommandHeader midiCommandHeader, DataInputStream midiInputStream) throws IOException {
        ArrayList<MidiTimestampPair> result = new ArrayList<MidiTimestampPair>();
        int status = -1;
        ByteArrayOutputStream sysexDataStream = null;
        int deltaTimeSum = midiCommandHeader.getRtpHeader().getTimestamp();
        while (midiInputStream.available() > 0) {
            int deltaTime = midiCommandHeader.isZ() ? this.readDeltaTime(midiInputStream) : 0;
            deltaTimeSum += deltaTime;
            byte midiOctet1 = midiInputStream.readByte();
            boolean systemCommonMessage = (midiOctet1 & 0xF0) == 240;
            int possibleStatus = midiOctet1 & 0xFF;
            if (systemCommonMessage) {
                if (midiOctet1 == -16) {
                    sysexDataStream = new ByteArrayOutputStream();
                    sysexDataStream.write(midiOctet1);
                    boolean partial = this.readSysexData(midiInputStream, sysexDataStream);
                    if (partial) continue;
                    result.add(new MidiTimestampPair(deltaTimeSum, new SysexMessage(sysexDataStream.toByteArray(), sysexDataStream.size())));
                    continue;
                }
                if (midiOctet1 == -9) {
                    boolean partial = this.readSysexData(midiInputStream, sysexDataStream);
                    if (partial) continue;
                    result.add(new MidiTimestampPair(deltaTimeSum, new SysexMessage(sysexDataStream.toByteArray(), sysexDataStream.size())));
                    continue;
                }
                if (midiOctet1 == -12) {
                    sysexDataStream.reset();
                    continue;
                }
                ShortMessage shortMessage = null;
                switch (possibleStatus) {
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 254: 
                    case 255: {
                        status = possibleStatus;
                        shortMessage = new ShortMessage((byte)(status & 0xFF));
                        break;
                    }
                    case 241: 
                    case 243: {
                        status = possibleStatus;
                        shortMessage = new ShortMessage((byte)(status & 0xFF), midiInputStream.readByte());
                        break;
                    }
                    case 242: {
                        status = possibleStatus;
                        shortMessage = new ShortMessage((byte)(status & 0xFF), midiInputStream.readByte(), midiInputStream.readByte());
                        break;
                    }
                    default: {
                        log.error("Invalid Message-status: {}", (Object)possibleStatus);
                    }
                }
                if (shortMessage == null) continue;
                result.add(new MidiTimestampPair(deltaTimeSum, shortMessage));
                continue;
            }
            ShortMessage shortMessage = null;
            switch (midiOctet1 & 0xF0) {
                case 128: 
                case 144: 
                case 160: 
                case 176: 
                case 224: {
                    status = possibleStatus;
                    shortMessage = new ShortMessage((byte)(status & 0xFF), midiInputStream.readByte(), midiInputStream.readByte());
                    break;
                }
                case 192: 
                case 208: {
                    status = possibleStatus;
                    shortMessage = new ShortMessage((byte)(status & 0xFF), midiInputStream.readByte());
                    break;
                }
                default: {
                    log.error("Invalid ShortMessage-status: {}", (Object)(midiOctet1 & 0xF0));
                }
            }
            if (shortMessage == null) continue;
            result.add(new MidiTimestampPair(deltaTimeSum, shortMessage));
        }
        return result;
    }

    private boolean readSysexData(DataInputStream midiInputStream, ByteArrayOutputStream sysexData) throws IOException {
        boolean sysexStart;
        boolean sysexEnd;
        do {
            byte tmpByte;
            sysexEnd = (tmpByte = midiInputStream.readByte()) == -9;
            boolean bl = sysexStart = tmpByte == -16;
            if (sysexStart) continue;
            sysexData.write(tmpByte);
        } while (!sysexEnd && !sysexStart);
        return sysexStart;
    }

    private int readDeltaTime(DataInputStream midiInputStream) throws IOException {
        byte deltaTimeOctet = midiInputStream.readByte();
        int deltaTime = deltaTimeOctet & 0x7F;
        for (int numberOfOctets = 1; (deltaTimeOctet >> 7 & 1) == 1 || numberOfOctets < 4; ++numberOfOctets) {
            deltaTimeOctet = midiInputStream.readByte();
            deltaTime = deltaTimeOctet << 8 & 0x7F | deltaTimeOctet;
        }
        return deltaTime;
    }

    public void registerListener(@Nonnull AppleMidiMessageListener appleMidiMessageListener) {
        this.listeners.add(appleMidiMessageListener);
    }

    public void unregisterListener(@Nonnull AppleMidiMessageListener appleMidiMessageListener) {
        this.listeners.remove(appleMidiMessageListener);
    }
}

