/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.messages;

import io.github.leovr.rtipmidi.messages.AppleMidiCommand;
import io.github.leovr.rtipmidi.messages.CommandWord;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class AppleMidiEndSession
extends AppleMidiCommand {
    private final int protocolVersion;
    private final int initiatorToken;

    public AppleMidiEndSession(int protocolVersion, int initiatorToken, int ssrc) {
        super(CommandWord.BY, ssrc);
        this.protocolVersion = protocolVersion;
        this.initiatorToken = initiatorToken;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(-1);
        dataOutputStream.write(-1);
        dataOutputStream.write(this.getCommandWord().name().getBytes(StandardCharsets.UTF_8));
        dataOutputStream.writeInt(this.protocolVersion);
        dataOutputStream.writeInt(this.initiatorToken);
        dataOutputStream.writeInt(this.getSsrc());
        dataOutputStream.flush();
        return outputStream.toByteArray();
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getInitiatorToken() {
        return this.initiatorToken;
    }

    @Override
    public String toString() {
        return "AppleMidiEndSession(super=" + super.toString() + ", protocolVersion=" + this.getProtocolVersion() + ", initiatorToken=" + this.getInitiatorToken() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppleMidiEndSession)) {
            return false;
        }
        AppleMidiEndSession other = (AppleMidiEndSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getProtocolVersion() != other.getProtocolVersion()) {
            return false;
        }
        return this.getInitiatorToken() == other.getInitiatorToken();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AppleMidiEndSession;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getProtocolVersion();
        result = result * 59 + this.getInitiatorToken();
        return result;
    }
}

