/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.session;

import io.github.leovr.rtipmidi.AppleMidiCommandListener;
import io.github.leovr.rtipmidi.AppleMidiMessageListener;
import io.github.leovr.rtipmidi.messages.AppleMidiClockSynchronization;
import io.github.leovr.rtipmidi.messages.AppleMidiEndSession;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationRequest;
import io.github.leovr.rtipmidi.messages.MidiCommandHeader;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import io.github.leovr.rtipmidi.model.MidiMessage;
import io.github.leovr.rtipmidi.session.AppleMidiSessionSender;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppleMidiSession
implements AppleMidiMessageListener,
AppleMidiCommandListener {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiSession.class);
    private long offsetEstimate;
    private ArrayList<AppleMidiSessionSender> senders = new ArrayList();
    protected int timestampOffset = new Random().nextInt();

    public long getCurrentTimestamp() {
        return (long)this.timestampOffset + ManagementFactory.getRuntimeMXBean().getUptime() * 10L;
    }

    @Override
    public final void onMidiMessage(MidiCommandHeader midiCommandHeader, MidiMessage message, int timestamp) {
        this.onMidiMessage(message, (long)timestamp + this.offsetEstimate);
    }

    protected abstract void onMidiMessage(MidiMessage var1, long var2);

    public void sendMidiMessage(MidiMessage message, long timestamp) {
        this.senders.forEach(sender -> sender.sendMidiMessage(message, timestamp));
    }

    public void addSender(AppleMidiSessionSender sender) {
        if (!this.senders.contains(sender)) {
            this.senders.add(sender);
        }
    }

    public void removeSender(AppleMidiSessionSender sender) {
        if (this.senders.contains(sender)) {
            this.senders.remove(sender);
        }
    }

    @Override
    public void onMidiInvitation(@Nonnull AppleMidiInvitationRequest invitation, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    @Override
    public final void onClockSynchronization(@Nonnull AppleMidiClockSynchronization clockSynchronization, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    @Override
    public final void onEndSession(@Nonnull AppleMidiEndSession appleMidiEndSession, @Nonnull AppleMidiServerAddress appleMidiServer) {
        this.onEndSession();
    }

    protected void onEndSession() {
    }

    public long getOffsetEstimate() {
        return this.offsetEstimate;
    }

    public ArrayList<AppleMidiSessionSender> getSenders() {
        return this.senders;
    }

    public int getTimestampOffset() {
        return this.timestampOffset;
    }

    public void setOffsetEstimate(long offsetEstimate) {
        this.offsetEstimate = offsetEstimate;
    }

    public void setSenders(ArrayList<AppleMidiSessionSender> senders) {
        this.senders = senders;
    }

    public void setTimestampOffset(int timestampOffset) {
        this.timestampOffset = timestampOffset;
    }
}

