/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.NameRegister;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostInfo
implements DNSStatefulObject {
    private static Logger logger = LoggerFactory.getLogger(HostInfo.class.getName());
    protected String _name;
    protected InetAddress _address;
    protected NetworkInterface _interfaze;
    private final HostInfoState _state;

    public static HostInfo newHostInfo(InetAddress address, JmDNSImpl dns, String jmdnsName) {
        HostInfo localhost = null;
        String aName = jmdnsName != null ? jmdnsName : "";
        InetAddress addr = address;
        try {
            if (addr == null) {
                String ip = System.getProperty("net.mdns.interface");
                if (ip != null) {
                    addr = InetAddress.getByName(ip);
                } else {
                    InetAddress[] addresses;
                    addr = InetAddress.getLocalHost();
                    if (addr.isLoopbackAddress() && (addresses = NetworkTopologyDiscovery.Factory.getInstance().getInetAddresses()).length > 0) {
                        addr = addresses[0];
                    }
                }
                if (addr.isLoopbackAddress()) {
                    logger.warn("Could not find any address beside the loopback.");
                }
            }
            if (aName.length() == 0) {
                aName = addr.getHostName();
            }
            if (aName.contains("in-addr.arpa") || aName.equals(addr.getHostAddress())) {
                aName = jmdnsName != null && jmdnsName.length() > 0 ? jmdnsName : addr.getHostAddress();
            }
        }
        catch (IOException e) {
            logger.warn("Could not initialize the host network interface on " + address + "because of an error: " + e.getMessage(), e);
            addr = HostInfo.loopbackAddress();
            aName = jmdnsName != null && jmdnsName.length() > 0 ? jmdnsName : "computer";
        }
        int index = aName.indexOf(".local");
        if (index > 0) {
            aName = aName.substring(0, index);
        }
        aName = aName.replaceAll("[:%\\.]", "-");
        aName = aName + ".local.";
        localhost = new HostInfo(addr, aName, dns);
        return localhost;
    }

    private static InetAddress loopbackAddress() {
        try {
            return InetAddress.getByName(null);
        }
        catch (UnknownHostException exception) {
            return null;
        }
    }

    private HostInfo(InetAddress address, String name, JmDNSImpl dns) {
        this._state = new HostInfoState(dns);
        this._address = address;
        this._name = name;
        if (address != null) {
            try {
                this._interfaze = NetworkInterface.getByInetAddress(address);
            }
            catch (Exception exception) {
                logger.warn("LocalHostInfo() exception ", exception);
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public InetAddress getInetAddress() {
        return this._address;
    }

    Inet4Address getInet4Address() {
        if (this.getInetAddress() instanceof Inet4Address) {
            return (Inet4Address)this._address;
        }
        return null;
    }

    Inet6Address getInet6Address() {
        if (this.getInetAddress() instanceof Inet6Address) {
            return (Inet6Address)this._address;
        }
        return null;
    }

    public NetworkInterface getInterface() {
        return this._interfaze;
    }

    public boolean conflictWithRecord(DNSRecord.Address record) {
        DNSRecord.Address hostAddress = this.getDNSAddressRecord(record.getRecordType(), record.isUnique(), 3600);
        if (hostAddress != null) {
            return hostAddress.sameType(record) && hostAddress.sameName(record) && !hostAddress.sameValue(record);
        }
        return false;
    }

    synchronized String incrementHostName() {
        this._name = NameRegister.Factory.getRegistry().incrementName(this.getInetAddress(), this._name, NameRegister.NameType.HOST);
        return this._name;
    }

    boolean shouldIgnorePacket(DatagramPacket packet) {
        InetAddress from;
        boolean result = false;
        if (this.getInetAddress() != null && (from = packet.getAddress()) != null) {
            if ((this.getInetAddress().isLinkLocalAddress() || this.getInetAddress().isMCLinkLocal()) && !from.isLinkLocalAddress()) {
                result = true;
            }
            if (from.isLoopbackAddress() && !this.getInetAddress().isLoopbackAddress()) {
                result = true;
            }
        }
        return result;
    }

    DNSRecord.Address getDNSAddressRecord(DNSRecordType type, boolean unique, int ttl) {
        switch (type) {
            case TYPE_A: {
                return this.getDNS4AddressRecord(unique, ttl);
            }
            case TYPE_A6: 
            case TYPE_AAAA: {
                return this.getDNS6AddressRecord(unique, ttl);
            }
        }
        return null;
    }

    private DNSRecord.Address getDNS4AddressRecord(boolean unique, int ttl) {
        if (this.getInetAddress() instanceof Inet4Address) {
            return new DNSRecord.IPv4Address(this.getName(), DNSRecordClass.CLASS_IN, unique, ttl, this.getInetAddress());
        }
        return null;
    }

    private DNSRecord.Address getDNS6AddressRecord(boolean unique, int ttl) {
        if (this.getInetAddress() instanceof Inet6Address) {
            return new DNSRecord.IPv6Address(this.getName(), DNSRecordClass.CLASS_IN, unique, ttl, this.getInetAddress());
        }
        return null;
    }

    DNSRecord.Pointer getDNSReverseAddressRecord(DNSRecordType type, boolean unique, int ttl) {
        switch (type) {
            case TYPE_A: {
                return this.getDNS4ReverseAddressRecord(unique, ttl);
            }
            case TYPE_A6: 
            case TYPE_AAAA: {
                return this.getDNS6ReverseAddressRecord(unique, ttl);
            }
        }
        return null;
    }

    private DNSRecord.Pointer getDNS4ReverseAddressRecord(boolean unique, int ttl) {
        if (this.getInetAddress() instanceof Inet4Address) {
            return new DNSRecord.Pointer(this.getInetAddress().getHostAddress() + ".in-addr.arpa.", DNSRecordClass.CLASS_IN, unique, ttl, this.getName());
        }
        return null;
    }

    private DNSRecord.Pointer getDNS6ReverseAddressRecord(boolean unique, int ttl) {
        if (this.getInetAddress() instanceof Inet6Address) {
            return new DNSRecord.Pointer(this.getInetAddress().getHostAddress() + ".ip6.arpa.", DNSRecordClass.CLASS_IN, unique, ttl, this.getName());
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("local host info[");
        buf.append(this.getName() != null ? this.getName() : "no name");
        buf.append(", ");
        buf.append(this.getInterface() != null ? this.getInterface().getDisplayName() : "???");
        buf.append(":");
        buf.append(this.getInetAddress() != null ? this.getInetAddress().getHostAddress() : "no address");
        buf.append(", ");
        buf.append(this._state);
        buf.append("]");
        return buf.toString();
    }

    public Collection<DNSRecord> answers(DNSRecordClass recordClass, boolean unique, int ttl) {
        ArrayList<DNSRecord> list = new ArrayList<DNSRecord>();
        DNSRecord.Address answer = this.getDNS4AddressRecord(unique, ttl);
        if (answer != null && answer.matchRecordClass(recordClass)) {
            list.add(answer);
        }
        if ((answer = this.getDNS6AddressRecord(unique, ttl)) != null && answer.matchRecordClass(recordClass)) {
            list.add(answer);
        }
        return list;
    }

    @Override
    public JmDNSImpl getDns() {
        return this._state.getDns();
    }

    @Override
    public boolean advanceState(DNSTask task) {
        return this._state.advanceState(task);
    }

    @Override
    public void removeAssociationWithTask(DNSTask task) {
        this._state.removeAssociationWithTask(task);
    }

    @Override
    public boolean revertState() {
        return this._state.revertState();
    }

    @Override
    public void associateWithTask(DNSTask task, DNSState state) {
        this._state.associateWithTask(task, state);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
        return this._state.isAssociatedWithTask(task, state);
    }

    @Override
    public boolean cancelState() {
        return this._state.cancelState();
    }

    @Override
    public boolean closeState() {
        return this._state.closeState();
    }

    @Override
    public boolean recoverState() {
        return this._state.recoverState();
    }

    @Override
    public boolean isProbing() {
        return this._state.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this._state.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this._state.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this._state.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this._state.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this._state.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this._state.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long timeout) {
        return this._state.waitForAnnounced(timeout);
    }

    @Override
    public boolean waitForCanceled(long timeout) {
        if (this._address == null) {
            return true;
        }
        return this._state.waitForCanceled(timeout);
    }

    private static final class HostInfoState
    extends DNSStatefulObject.DefaultImplementation {
        private static final long serialVersionUID = -8191476803620402088L;

        public HostInfoState(JmDNSImpl dns) {
            this.setDns(dns);
        }
    }
}

