/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.DNSTaskStarter;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.ListenerStatus;
import javax.jmdns.impl.NameRegister;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.SocketListener;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;
import javax.jmdns.impl.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmDNSImpl
extends JmDNS
implements DNSStatefulObject,
DNSTaskStarter {
    private static Logger logger = LoggerFactory.getLogger(JmDNSImpl.class.getName());
    private volatile InetAddress _group;
    private volatile MulticastSocket _socket;
    private final List<DNSListener> _listeners;
    final ConcurrentMap<String, List<ListenerStatus.ServiceListenerStatus>> _serviceListeners;
    private final Set<ListenerStatus.ServiceTypeListenerStatus> _typeListeners;
    private final DNSCache _cache;
    private final ConcurrentMap<String, ServiceInfo> _services;
    private final ConcurrentMap<String, ServiceTypeEntry> _serviceTypes;
    private volatile JmDNS.Delegate _delegate;
    protected Thread _shutdown;
    private HostInfo _localHost;
    private Thread _incomingListener;
    private int _throttle;
    private long _lastThrottleIncrement;
    private final ExecutorService _executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("JmDNS"));
    private static final Random _random = new Random();
    private final ReentrantLock _ioLock = new ReentrantLock();
    private DNSIncoming _plannedAnswer;
    private final ConcurrentMap<String, ServiceCollector> _serviceCollectors;
    private final String _name;
    private final Object _recoverLock = new Object();

    public static void main(String[] argv) {
        String version = null;
        try {
            Properties pomProperties = new Properties();
            pomProperties.load(JmDNSImpl.class.getResourceAsStream("/META-INF/maven/javax.jmdns/jmdns/pom.properties"));
            version = pomProperties.getProperty("version");
        }
        catch (Exception e) {
            version = "RUNNING.IN.IDE.FULL";
        }
        System.out.println("JmDNS version \"" + version + "\"");
        System.out.println(" ");
        System.out.println("Running on java version \"" + System.getProperty("java.version") + "\"" + " (build " + System.getProperty("java.runtime.version") + ")" + " from " + System.getProperty("java.vendor"));
        System.out.println("Operating environment \"" + System.getProperty("os.name") + "\"" + " version " + System.getProperty("os.version") + " on " + System.getProperty("os.arch"));
        System.out.println("For more information on JmDNS please visit http://jmdns.org");
    }

    public JmDNSImpl(InetAddress address, String name) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("JmDNS instance created");
        }
        this._cache = new DNSCache(100);
        this._listeners = Collections.synchronizedList(new ArrayList());
        this._serviceListeners = new ConcurrentHashMap<String, List<ListenerStatus.ServiceListenerStatus>>();
        this._typeListeners = Collections.synchronizedSet(new HashSet());
        this._serviceCollectors = new ConcurrentHashMap<String, ServiceCollector>();
        this._services = new ConcurrentHashMap<String, ServiceInfo>(20);
        this._serviceTypes = new ConcurrentHashMap<String, ServiceTypeEntry>(20);
        this._localHost = HostInfo.newHostInfo(address, this, name);
        this._name = name != null ? name : this._localHost.getName();
        this.openMulticastSocket(this.getLocalHost());
        this.start(this.getServices().values());
        this.startReaper();
    }

    private void start(Collection<? extends ServiceInfo> serviceInfos) {
        if (this._incomingListener == null) {
            this._incomingListener = new SocketListener(this);
            this._incomingListener.start();
        }
        this.startProber();
        for (ServiceInfo serviceInfo : serviceInfos) {
            try {
                this.registerService(new ServiceInfoImpl(serviceInfo));
            }
            catch (Exception exception) {
                logger.warn("start() Registration exception ", exception);
            }
        }
    }

    private void openMulticastSocket(HostInfo hostInfo) throws IOException {
        block5: {
            if (this._group == null) {
                this._group = hostInfo.getInetAddress() instanceof Inet6Address ? InetAddress.getByName("FF02::FB") : InetAddress.getByName("224.0.0.251");
            }
            if (this._socket != null) {
                this.closeMulticastSocket();
            }
            this._socket = new MulticastSocket(DNSConstants.MDNS_PORT);
            if (hostInfo != null && hostInfo.getInterface() != null) {
                try {
                    this._socket.setNetworkInterface(hostInfo.getInterface());
                }
                catch (SocketException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("openMulticastSocket() Set network interface exception: " + e.getMessage());
                }
            }
        }
        this._socket.setTimeToLive(255);
        this._socket.joinGroup(this._group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMulticastSocket() {
        if (logger.isDebugEnabled()) {
            logger.debug("closeMulticastSocket()");
        }
        if (this._socket != null) {
            try {
                try {
                    this._socket.leaveGroup(this._group);
                }
                catch (SocketException exception) {
                    // empty catch block
                }
                this._socket.close();
                while (this._incomingListener != null && this._incomingListener.isAlive()) {
                    JmDNSImpl exception = this;
                    synchronized (exception) {
                        try {
                            if (this._incomingListener != null && this._incomingListener.isAlive()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("closeMulticastSocket(): waiting for jmDNS monitor");
                                }
                                this.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this._incomingListener = null;
            }
            catch (Exception exception) {
                logger.warn("closeMulticastSocket() Close socket exception ", exception);
            }
            this._socket = null;
        }
    }

    @Override
    public boolean advanceState(DNSTask task) {
        return this._localHost.advanceState(task);
    }

    @Override
    public boolean revertState() {
        return this._localHost.revertState();
    }

    @Override
    public boolean cancelState() {
        return this._localHost.cancelState();
    }

    @Override
    public boolean closeState() {
        return this._localHost.closeState();
    }

    @Override
    public boolean recoverState() {
        return this._localHost.recoverState();
    }

    @Override
    public JmDNSImpl getDns() {
        return this;
    }

    @Override
    public void associateWithTask(DNSTask task, DNSState state) {
        this._localHost.associateWithTask(task, state);
    }

    @Override
    public void removeAssociationWithTask(DNSTask task) {
        this._localHost.removeAssociationWithTask(task);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
        return this._localHost.isAssociatedWithTask(task, state);
    }

    @Override
    public boolean isProbing() {
        return this._localHost.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this._localHost.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this._localHost.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this._localHost.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this._localHost.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this._localHost.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this._localHost.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long timeout) {
        return this._localHost.waitForAnnounced(timeout);
    }

    @Override
    public boolean waitForCanceled(long timeout) {
        return this._localHost.waitForCanceled(timeout);
    }

    public DNSCache getCache() {
        return this._cache;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getHostName() {
        return this._localHost.getName();
    }

    public HostInfo getLocalHost() {
        return this._localHost;
    }

    @Override
    public InetAddress getInetAddress() throws IOException {
        return this._localHost.getInetAddress();
    }

    @Override
    @Deprecated
    public InetAddress getInterface() throws IOException {
        return this._socket.getInterface();
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name) {
        return this.getServiceInfo(type, name, false, 6000L);
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name, long timeout) {
        return this.getServiceInfo(type, name, false, timeout);
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name, boolean persistent) {
        return this.getServiceInfo(type, name, persistent, 6000L);
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name, boolean persistent, long timeout) {
        ServiceInfoImpl info = this.resolveServiceInfo(type, name, "", persistent);
        this.waitForInfoData(info, timeout);
        return info.hasData() ? info : null;
    }

    ServiceInfoImpl resolveServiceInfo(String type, String name, String subtype, boolean persistent) {
        this.cleanCache();
        String loType = type.toLowerCase();
        this.registerServiceType(type);
        if (this._serviceCollectors.putIfAbsent(loType, new ServiceCollector(type)) == null) {
            this.addServiceListener(loType, (ServiceListener)this._serviceCollectors.get(loType), true);
        }
        ServiceInfoImpl info = this.getServiceInfoFromCache(type, name, subtype, persistent);
        this.startServiceInfoResolver(info);
        return info;
    }

    ServiceInfoImpl getServiceInfoFromCache(String type, String name, String subtype, boolean persistent) {
        ServiceInfoImpl cachedInfo;
        ServiceInfoImpl info = new ServiceInfoImpl(type, name, subtype, 0, 0, 0, persistent, (byte[])null);
        DNSEntry pointerEntry = this.getCache().getDNSEntry(new DNSRecord.Pointer(type, DNSRecordClass.CLASS_ANY, false, 0, info.getQualifiedName()));
        if (pointerEntry instanceof DNSRecord && (cachedInfo = (ServiceInfoImpl)((DNSRecord)pointerEntry).getServiceInfo(persistent)) != null) {
            ServiceInfo serviceInfo;
            ServiceInfo cachedAddressInfo;
            ServiceInfo cachedServiceEntryInfo;
            Map<ServiceInfo.Fields, String> map = cachedInfo.getQualifiedNameMap();
            byte[] srvBytes = null;
            String server = "";
            DNSEntry serviceEntry = this.getCache().getDNSEntry(info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_ANY);
            if (serviceEntry instanceof DNSRecord && (cachedServiceEntryInfo = ((DNSRecord)serviceEntry).getServiceInfo(persistent)) != null) {
                cachedInfo = new ServiceInfoImpl(map, cachedServiceEntryInfo.getPort(), cachedServiceEntryInfo.getWeight(), cachedServiceEntryInfo.getPriority(), persistent, (byte[])null);
                srvBytes = cachedServiceEntryInfo.getTextBytes();
                server = cachedServiceEntryInfo.getServer();
            }
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(server, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_ANY)) {
                if (!(dNSEntry instanceof DNSRecord) || (cachedAddressInfo = ((DNSRecord)dNSEntry).getServiceInfo(persistent)) == null) continue;
                for (Inet4Address inet4Address : cachedAddressInfo.getInet4Addresses()) {
                    cachedInfo.addAddress(inet4Address);
                }
                cachedInfo._setText(cachedAddressInfo.getTextBytes());
            }
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(server, DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_ANY)) {
                if (!(dNSEntry instanceof DNSRecord) || (cachedAddressInfo = ((DNSRecord)dNSEntry).getServiceInfo(persistent)) == null) continue;
                for (InetAddress inetAddress : cachedAddressInfo.getInet6Addresses()) {
                    cachedInfo.addAddress((Inet6Address)inetAddress);
                }
                cachedInfo._setText(cachedAddressInfo.getTextBytes());
            }
            DNSEntry textEntry = this.getCache().getDNSEntry(cachedInfo.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_ANY);
            if (textEntry instanceof DNSRecord && (serviceInfo = ((DNSRecord)textEntry).getServiceInfo(persistent)) != null) {
                cachedInfo._setText(serviceInfo.getTextBytes());
            }
            if (cachedInfo.getTextBytes().length == 0) {
                cachedInfo._setText(srvBytes);
            }
            if (cachedInfo.hasData()) {
                info = cachedInfo;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInfoData(ServiceInfo info, long timeout) {
        ServiceInfo serviceInfo = info;
        synchronized (serviceInfo) {
            long loops = timeout / 200L;
            if (loops < 1L) {
                loops = 1L;
            }
            int i = 0;
            while ((long)i < loops && !info.hasData()) {
                try {
                    info.wait(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    @Override
    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, boolean persistent) {
        this.requestServiceInfo(type, name, persistent, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, long timeout) {
        this.requestServiceInfo(type, name, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, boolean persistent, long timeout) {
        ServiceInfoImpl info = this.resolveServiceInfo(type, name, "", persistent);
        this.waitForInfoData(info, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleServiceResolved(ServiceEvent event) {
        List list = (List)this._serviceListeners.get(event.getType().toLowerCase());
        if (list != null && !list.isEmpty() && event.getInfo() != null && event.getInfo().hasData()) {
            ArrayList listCopy;
            final ServiceEvent localEvent = event;
            List list2 = list;
            synchronized (list2) {
                listCopy = new ArrayList(list);
            }
            for (final ListenerStatus.ServiceListenerStatus listener : listCopy) {
                this._executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        listener.serviceResolved(localEvent);
                    }
                });
            }
        }
    }

    @Override
    public void addServiceTypeListener(ServiceTypeListener listener) throws IOException {
        ListenerStatus.ServiceTypeListenerStatus status = new ListenerStatus.ServiceTypeListenerStatus(listener, false);
        this._typeListeners.add(status);
        for (String type : this._serviceTypes.keySet()) {
            status.serviceTypeAdded(new ServiceEventImpl(this, type, "", null));
        }
        this.startTypeResolver();
    }

    @Override
    public void removeServiceTypeListener(ServiceTypeListener listener) {
        ListenerStatus.ServiceTypeListenerStatus status = new ListenerStatus.ServiceTypeListenerStatus(listener, false);
        this._typeListeners.remove(status);
    }

    @Override
    public void addServiceListener(String type, ServiceListener listener) {
        this.addServiceListener(type, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceListener(String type, ServiceListener listener, boolean synch) {
        ListenerStatus.ServiceListenerStatus status = new ListenerStatus.ServiceListenerStatus(listener, synch);
        String loType = type.toLowerCase();
        List list = (List)this._serviceListeners.get(loType);
        if (list == null) {
            if (this._serviceListeners.putIfAbsent(loType, new LinkedList()) == null && this._serviceCollectors.putIfAbsent(loType, new ServiceCollector(type)) == null) {
                this.addServiceListener(loType, (ServiceListener)this._serviceCollectors.get(loType), true);
            }
            list = (List)this._serviceListeners.get(loType);
        }
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                if (!list.contains(status)) {
                    list.add(status);
                }
            }
        }
        ArrayList<ServiceEventImpl> serviceEvents = new ArrayList<ServiceEventImpl>();
        Collection<DNSEntry> dnsEntryLits = this.getCache().allValues();
        for (DNSEntry dNSEntry : dnsEntryLits) {
            DNSRecord record = (DNSRecord)dNSEntry;
            if (record.getRecordType() != DNSRecordType.TYPE_SRV || !record.getKey().endsWith(loType)) continue;
            serviceEvents.add(new ServiceEventImpl(this, record.getType(), JmDNSImpl.toUnqualifiedName(record.getType(), record.getName()), record.getServiceInfo()));
        }
        for (ServiceEvent serviceEvent : serviceEvents) {
            status.serviceAdded(serviceEvent);
        }
        this.startServiceResolver(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(String type, ServiceListener listener) {
        String loType = type.toLowerCase();
        List list = (List)this._serviceListeners.get(loType);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                ListenerStatus.ServiceListenerStatus status = new ListenerStatus.ServiceListenerStatus(listener, false);
                list.remove(status);
                if (list.isEmpty()) {
                    this._serviceListeners.remove(loType, list);
                }
            }
        }
    }

    @Override
    public void registerService(ServiceInfo infoAbstract) throws IOException {
        if (this.isClosing() || this.isClosed()) {
            throw new IllegalStateException("This DNS is closed.");
        }
        ServiceInfoImpl info = (ServiceInfoImpl)infoAbstract;
        if (info.getDns() != null) {
            if (info.getDns() != this) {
                throw new IllegalStateException("A service information can only be registered with a single instamce of JmDNS.");
            }
            if (this._services.get(info.getKey()) != null) {
                throw new IllegalStateException("A service information can only be registered once.");
            }
        }
        info.setDns(this);
        this.registerServiceType(info.getTypeWithSubtype());
        info.recoverState();
        info.setServer(this._localHost.getName());
        info.addAddress(this._localHost.getInet4Address());
        info.addAddress(this._localHost.getInet6Address());
        this.waitForAnnounced(6000L);
        this.makeServiceNameUnique(info);
        while (this._services.putIfAbsent(info.getKey(), info) != null) {
            this.makeServiceNameUnique(info);
        }
        this.startProber();
        info.waitForAnnounced(6000L);
        if (logger.isDebugEnabled()) {
            logger.debug("registerService() JmDNS registered service as " + info);
        }
    }

    @Override
    public void unregisterService(ServiceInfo infoAbstract) {
        ServiceInfoImpl info = (ServiceInfoImpl)this._services.get(infoAbstract.getKey());
        if (info != null) {
            info.cancelState();
            this.startCanceler();
            info.waitForCanceled(5000L);
            this._services.remove(info.getKey(), info);
            if (logger.isDebugEnabled()) {
                logger.debug("unregisterService() JmDNS " + this.getName() + " unregistered service as " + info);
            }
        } else {
            logger.warn(this.getName() + " removing unregistered service info: " + infoAbstract.getKey());
        }
    }

    @Override
    public void unregisterAllServices() {
        ServiceInfoImpl info;
        if (logger.isDebugEnabled()) {
            logger.debug("unregisterAllServices()");
        }
        for (String name : this._services.keySet()) {
            info = (ServiceInfoImpl)this._services.get(name);
            if (info == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Cancelling service info: " + info);
            }
            info.cancelState();
        }
        this.startCanceler();
        for (String name : this._services.keySet()) {
            info = (ServiceInfoImpl)this._services.get(name);
            if (info == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Wait for service info cancel: " + info);
            }
            info.waitForCanceled(5000L);
            this._services.remove(name, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerServiceType(String type) {
        ServiceTypeEntry subtypes;
        boolean typeAdded = false;
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(type);
        String domain = map.get((Object)ServiceInfo.Fields.Domain);
        String protocol = map.get((Object)ServiceInfo.Fields.Protocol);
        String application = map.get((Object)ServiceInfo.Fields.Application);
        String subtype = map.get((Object)ServiceInfo.Fields.Subtype);
        String name = (application.length() > 0 ? "_" + application + "." : "") + (protocol.length() > 0 ? "_" + protocol + "." : "") + domain + ".";
        String loname = name.toLowerCase();
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + ".registering service type: " + type + " as: " + name + (subtype.length() > 0 ? " subtype: " + subtype : ""));
        }
        if (!(this._serviceTypes.containsKey(loname) || application.toLowerCase().equals("dns-sd") || domain.toLowerCase().endsWith("in-addr.arpa") || domain.toLowerCase().endsWith("ip6.arpa"))) {
            boolean bl = typeAdded = this._serviceTypes.putIfAbsent(loname, new ServiceTypeEntry(name)) == null;
            if (typeAdded) {
                ListenerStatus.ServiceTypeListenerStatus[] list = this._typeListeners.toArray(new ListenerStatus.ServiceTypeListenerStatus[this._typeListeners.size()]);
                final ServiceEventImpl event = new ServiceEventImpl(this, name, "", null);
                for (final ListenerStatus.ServiceTypeListenerStatus status : list) {
                    this._executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            status.serviceTypeAdded(event);
                        }
                    });
                }
            }
        }
        if (subtype.length() > 0 && (subtypes = (ServiceTypeEntry)this._serviceTypes.get(loname)) != null && !subtypes.contains(subtype)) {
            ServiceTypeEntry serviceTypeEntry = subtypes;
            synchronized (serviceTypeEntry) {
                if (!subtypes.contains(subtype)) {
                    typeAdded = true;
                    subtypes.add(subtype);
                    ListenerStatus.ServiceTypeListenerStatus[] list = this._typeListeners.toArray(new ListenerStatus.ServiceTypeListenerStatus[this._typeListeners.size()]);
                    final ServiceEventImpl event = new ServiceEventImpl(this, "_" + subtype + "._sub." + name, "", null);
                    for (final ListenerStatus.ServiceTypeListenerStatus status : list) {
                        this._executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                status.subTypeForServiceTypeAdded(event);
                            }
                        });
                    }
                }
            }
        }
        return typeAdded;
    }

    private boolean makeServiceNameUnique(ServiceInfoImpl info) {
        boolean collision;
        String originalQualifiedName = info.getKey();
        long now = System.currentTimeMillis();
        do {
            ServiceInfo selfService;
            collision = false;
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(info.getKey())) {
                DNSRecord.Service s;
                if (!DNSRecordType.TYPE_SRV.equals((Object)dNSEntry.getRecordType()) || dNSEntry.isExpired(now) || (s = (DNSRecord.Service)dNSEntry).getPort() == info.getPort() && s.getServer().equals(this._localHost.getName())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("makeServiceNameUnique() JmDNS.makeServiceNameUnique srv collision:" + dNSEntry + " s.server=" + s.getServer() + " " + this._localHost.getName() + " equals:" + s.getServer().equals(this._localHost.getName()));
                }
                info.setName(NameRegister.Factory.getRegistry().incrementName(this._localHost.getInetAddress(), info.getName(), NameRegister.NameType.SERVICE));
                collision = true;
                break;
            }
            if ((selfService = (ServiceInfo)this._services.get(info.getKey())) == null || selfService == info) continue;
            info.setName(NameRegister.Factory.getRegistry().incrementName(this._localHost.getInetAddress(), info.getName(), NameRegister.NameType.SERVICE));
            collision = true;
        } while (collision);
        return !originalQualifiedName.equals(info.getKey());
    }

    public void addListener(DNSListener listener, DNSQuestion question) {
        long now = System.currentTimeMillis();
        this._listeners.add(listener);
        if (question != null) {
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(question.getName().toLowerCase())) {
                if (!question.answeredBy(dNSEntry) || dNSEntry.isExpired(now)) continue;
                listener.updateRecord(this.getCache(), now, dNSEntry);
            }
        }
    }

    public void removeListener(DNSListener listener) {
        this._listeners.remove(listener);
    }

    public void renewServiceCollector(String type) {
        if (this._serviceCollectors.containsKey(type.toLowerCase())) {
            this.startServiceResolver(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(long now, DNSRecord rec, Operation operation) {
        ArrayList<DNSListener> listenerList = null;
        List<DNSListener> list = this._listeners;
        synchronized (list) {
            listenerList = new ArrayList<DNSListener>(this._listeners);
        }
        for (DNSListener listener : listenerList) {
            listener.updateRecord(this.getCache(), now, rec);
        }
        if (DNSRecordType.TYPE_PTR.equals((Object)rec.getRecordType())) {
            List<ListenerStatus.ServiceListenerStatus> serviceListenerList;
            List list2;
            ServiceInfoImpl info;
            ServiceEvent event = rec.getServiceEvent(this);
            if ((event.getInfo() == null || !event.getInfo().hasData()) && ((ServiceInfo)(info = this.getServiceInfoFromCache(event.getType(), event.getName(), "", false))).hasData()) {
                event = new ServiceEventImpl(this, event.getType(), event.getName(), info);
            }
            if ((list2 = (List)this._serviceListeners.get(event.getType().toLowerCase())) != null) {
                List list3 = list2;
                synchronized (list3) {
                    serviceListenerList = new ArrayList<ListenerStatus.ServiceListenerStatus>(list2);
                }
            } else {
                serviceListenerList = Collections.emptyList();
            }
            if (logger.isTraceEnabled()) {
                logger.trace(this.getName() + ".updating record for event: " + event + " list " + serviceListenerList + " operation: " + (Object)((Object)operation));
            }
            if (!serviceListenerList.isEmpty()) {
                final ServiceEvent localEvent = event;
                switch (operation) {
                    case Add: {
                        for (final ListenerStatus.ServiceListenerStatus listener : serviceListenerList) {
                            if (listener.isSynchronous()) {
                                listener.serviceAdded(localEvent);
                                continue;
                            }
                            this._executor.submit(new Runnable(){

                                @Override
                                public void run() {
                                    listener.serviceAdded(localEvent);
                                }
                            });
                        }
                        break;
                    }
                    case Remove: {
                        for (final ListenerStatus.ServiceListenerStatus listener : serviceListenerList) {
                            if (listener.isSynchronous()) {
                                listener.serviceRemoved(localEvent);
                                continue;
                            }
                            this._executor.submit(new Runnable(){

                                @Override
                                public void run() {
                                    listener.serviceRemoved(localEvent);
                                }
                            });
                        }
                        break;
                    }
                }
            }
        }
    }

    void handleRecord(DNSRecord record, long now) {
        DNSRecord newRecord = record;
        Operation cacheOperation = Operation.Noop;
        boolean expired = newRecord.isExpired(now);
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + " handle response: " + newRecord);
        }
        if (!newRecord.isServicesDiscoveryMetaQuery() && !newRecord.isDomainDiscoveryQuery()) {
            boolean unique = newRecord.isUnique();
            DNSRecord cachedRecord = (DNSRecord)this.getCache().getDNSEntry(newRecord);
            if (logger.isDebugEnabled()) {
                logger.debug(this.getName() + " handle response cached record: " + cachedRecord);
            }
            if (unique) {
                for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(newRecord.getKey())) {
                    if (!newRecord.getRecordType().equals((Object)dNSEntry.getRecordType()) || !newRecord.getRecordClass().equals((Object)dNSEntry.getRecordClass()) || dNSEntry == cachedRecord) continue;
                    ((DNSRecord)dNSEntry).setWillExpireSoon(now);
                }
            }
            if (cachedRecord != null) {
                if (expired) {
                    if (newRecord.getTTL() == 0) {
                        cacheOperation = Operation.Noop;
                        cachedRecord.setWillExpireSoon(now);
                    } else {
                        cacheOperation = Operation.Remove;
                        this.getCache().removeDNSEntry(cachedRecord);
                    }
                } else if (!newRecord.sameValue(cachedRecord) || !newRecord.sameSubtype(cachedRecord) && newRecord.getSubtype().length() > 0) {
                    if (newRecord.isSingleValued()) {
                        cacheOperation = Operation.Update;
                        this.getCache().replaceDNSEntry(newRecord, cachedRecord);
                    } else {
                        cacheOperation = Operation.Add;
                        this.getCache().addDNSEntry(newRecord);
                    }
                } else {
                    cachedRecord.resetTTL(newRecord);
                    newRecord = cachedRecord;
                }
            } else if (!expired) {
                cacheOperation = Operation.Add;
                this.getCache().addDNSEntry(newRecord);
            }
        }
        if (newRecord.getRecordType() == DNSRecordType.TYPE_PTR) {
            boolean typeAdded = false;
            if (newRecord.isServicesDiscoveryMetaQuery()) {
                if (!expired) {
                    typeAdded = this.registerServiceType(((DNSRecord.Pointer)newRecord).getAlias());
                }
                return;
            }
            if ((typeAdded |= this.registerServiceType(newRecord.getName())) && cacheOperation == Operation.Noop) {
                cacheOperation = Operation.RegisterServiceType;
            }
        }
        if (cacheOperation != Operation.Noop) {
            this.updateRecord(now, newRecord, cacheOperation);
        }
    }

    void handleResponse(DNSIncoming msg) throws IOException {
        long now = System.currentTimeMillis();
        boolean hostConflictDetected = false;
        boolean serviceConflictDetected = false;
        List<DNSRecord> allAnswers = msg.getAllAnswers();
        allAnswers = this.aRecordsLast(allAnswers);
        for (DNSRecord newRecord : allAnswers) {
            this.handleRecord(newRecord, now);
            if (DNSRecordType.TYPE_A.equals((Object)newRecord.getRecordType()) || DNSRecordType.TYPE_AAAA.equals((Object)newRecord.getRecordType())) {
                hostConflictDetected |= newRecord.handleResponse(this);
                continue;
            }
            serviceConflictDetected |= newRecord.handleResponse(this);
        }
        if (hostConflictDetected || serviceConflictDetected) {
            this.startProber();
        }
    }

    private List<DNSRecord> aRecordsLast(List<DNSRecord> allAnswers) {
        ArrayList<DNSRecord> ret = new ArrayList<DNSRecord>(allAnswers.size());
        ArrayList<DNSRecord> arecords = new ArrayList<DNSRecord>();
        for (DNSRecord answer : allAnswers) {
            if (answer.getRecordType().equals((Object)DNSRecordType.TYPE_A) || answer.getRecordType().equals((Object)DNSRecordType.TYPE_AAAA)) {
                arecords.add(answer);
                continue;
            }
            ret.add(answer);
        }
        ret.addAll(arecords);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleQuery(DNSIncoming in, InetAddress addr, int port) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + ".handle query: " + in);
        }
        boolean conflictDetected = false;
        long expirationTime = System.currentTimeMillis() + 120L;
        for (DNSRecord answer : in.getAllAnswers()) {
            conflictDetected |= answer.handleQuery(this, expirationTime);
        }
        this.ioLock();
        try {
            if (this._plannedAnswer != null) {
                this._plannedAnswer.append(in);
            } else {
                DNSIncoming plannedAnswer = in.clone();
                if (in.isTruncated()) {
                    this._plannedAnswer = plannedAnswer;
                }
                this.startResponder(plannedAnswer, addr, port);
            }
        }
        finally {
            this.ioUnlock();
        }
        long now = System.currentTimeMillis();
        for (DNSRecord dNSRecord : in.getAnswers()) {
            this.handleRecord(dNSRecord, now);
        }
        if (conflictDetected) {
            this.startProber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respondToQuery(DNSIncoming in) {
        this.ioLock();
        try {
            if (this._plannedAnswer == in) {
                this._plannedAnswer = null;
            }
        }
        finally {
            this.ioUnlock();
        }
    }

    public DNSOutgoing addAnswer(DNSIncoming in, InetAddress addr, int port, DNSOutgoing out, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        if (newOut == null) {
            newOut = new DNSOutgoing(33792, false, in.getSenderUDPPayload());
        }
        try {
            newOut.addAnswer(in, rec);
        }
        catch (IOException e) {
            newOut.setFlags(newOut.getFlags() | 0x200);
            newOut.setId(in.getId());
            this.send(newOut);
            newOut = new DNSOutgoing(33792, false, in.getSenderUDPPayload());
            newOut.addAnswer(in, rec);
        }
        return newOut;
    }

    public void send(DNSOutgoing out) throws IOException {
        if (!out.isEmpty()) {
            MulticastSocket ms;
            int port;
            InetAddress addr;
            if (out.getDestination() != null) {
                addr = out.getDestination().getAddress();
                port = out.getDestination().getPort();
            } else {
                addr = this._group;
                port = DNSConstants.MDNS_PORT;
            }
            byte[] message = out.data();
            DatagramPacket packet = new DatagramPacket(message, message.length, addr, port);
            if (logger.isTraceEnabled()) {
                try {
                    DNSIncoming msg = new DNSIncoming(packet);
                    if (logger.isTraceEnabled()) {
                        logger.trace("send(" + this.getName() + ") JmDNS out:" + msg.print(true));
                    }
                }
                catch (IOException e) {
                    logger.debug(this.getClass().toString(), (Object)("send(" + this.getName() + ") - JmDNS can not parse what it sends!!!"), (Object)e);
                }
            }
            if ((ms = this._socket) != null && !ms.isClosed()) {
                ms.send(packet);
            }
        }
    }

    @Override
    public void purgeTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).purgeTimer();
    }

    @Override
    public void purgeStateTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).purgeStateTimer();
    }

    @Override
    public void cancelTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).cancelTimer();
    }

    @Override
    public void cancelStateTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).cancelStateTimer();
    }

    @Override
    public void startProber() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startProber();
    }

    @Override
    public void startAnnouncer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startAnnouncer();
    }

    @Override
    public void startRenewer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startRenewer();
    }

    @Override
    public void startCanceler() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startCanceler();
    }

    @Override
    public void startReaper() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startReaper();
    }

    @Override
    public void startServiceInfoResolver(ServiceInfoImpl info) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startServiceInfoResolver(info);
    }

    @Override
    public void startTypeResolver() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startTypeResolver();
    }

    @Override
    public void startServiceResolver(String type) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startServiceResolver(type);
    }

    @Override
    public void startResponder(DNSIncoming in, InetAddress addr, int port) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startResponder(in, addr, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        logger.debug(this.getName() + "recover()");
        if (this.isClosing() || this.isClosed() || this.isCanceling() || this.isCanceled()) {
            return;
        }
        Object object = this._recoverLock;
        synchronized (object) {
            if (this.cancelState()) {
                logger.debug(this.getName() + "recover() thread " + Thread.currentThread().getName());
                Thread recover = new Thread(this.getName() + ".recover()"){

                    @Override
                    public void run() {
                        JmDNSImpl.this.__recover();
                    }
                };
                recover.start();
            }
        }
    }

    void __recover() {
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + "recover() Cleanning up");
        }
        logger.warn("RECOVERING");
        this.purgeTimer();
        ArrayList<ServiceInfo> oldServiceInfos = new ArrayList<ServiceInfo>(this.getServices().values());
        this.unregisterAllServices();
        this.disposeServiceCollectors();
        this.waitForCanceled(5000L);
        this.purgeStateTimer();
        this.closeMulticastSocket();
        this.getCache().clear();
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + "recover() All is clean");
        }
        if (this.isCanceled()) {
            for (ServiceInfo info : oldServiceInfos) {
                ((ServiceInfoImpl)info).recoverState();
            }
            this.recoverState();
            try {
                this.openMulticastSocket(this.getLocalHost());
                this.start(oldServiceInfos);
            }
            catch (Exception exception) {
                logger.warn(this.getName() + "recover() Start services exception ", exception);
            }
            logger.warn(this.getName() + "recover() We are back!");
        } else {
            logger.warn(this.getName() + "recover() Could not recover we are Down!");
            if (this.getDelegate() != null) {
                this.getDelegate().cannotRecoverFromIOError(this.getDns(), oldServiceInfos);
            }
        }
    }

    public void cleanCache() {
        long now = System.currentTimeMillis();
        HashSet<String> staleServiceTypesForRefresh = new HashSet<String>();
        for (DNSEntry entry : this.getCache().allValues()) {
            try {
                DNSRecord record = (DNSRecord)entry;
                if (record.isExpired(now)) {
                    this.updateRecord(now, record, Operation.Remove);
                    this.getCache().removeDNSEntry(record);
                    continue;
                }
                if (!record.isStaleAndShouldBeRefreshed(now)) continue;
                record.incrementRefreshPercentage();
                String type = record.getServiceInfo().getType().toLowerCase();
                if (!staleServiceTypesForRefresh.add(type)) continue;
                this.renewServiceCollector(type);
            }
            catch (Exception exception) {
                logger.warn(this.getName() + ".Error while reaping records: " + entry, exception);
                logger.warn(this.toString());
            }
        }
    }

    @Override
    public void close() {
        if (this.isClosing()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cancelling JmDNS: " + this);
        }
        if (this.closeState()) {
            logger.debug("Canceling the timer");
            this.cancelTimer();
            this.unregisterAllServices();
            this.disposeServiceCollectors();
            if (logger.isDebugEnabled()) {
                logger.debug("Wait for JmDNS cancel: " + this);
            }
            this.waitForCanceled(5000L);
            logger.debug("Canceling the state timer");
            this.cancelStateTimer();
            this._executor.shutdown();
            this.closeMulticastSocket();
            if (this._shutdown != null) {
                Runtime.getRuntime().removeShutdownHook(this._shutdown);
            }
            DNSTaskStarter.Factory.getInstance().disposeStarter(this.getDns());
            if (logger.isDebugEnabled()) {
                logger.debug("JmDNS closed.");
            }
        }
        this.advanceState(null);
    }

    @Override
    @Deprecated
    public void printServices() {
        System.err.println(this.toString());
    }

    public String toString() {
        StringBuilder aLog = new StringBuilder(2048);
        aLog.append("\n");
        aLog.append("\t---- Local Host -----");
        aLog.append("\n\t");
        aLog.append(this._localHost);
        aLog.append("\n\t---- Services -----");
        for (String key : this._services.keySet()) {
            aLog.append("\n\t\tService: ");
            aLog.append(key);
            aLog.append(": ");
            aLog.append(this._services.get(key));
        }
        aLog.append("\n");
        aLog.append("\t---- Types ----");
        for (String key : this._serviceTypes.keySet()) {
            ServiceTypeEntry subtypes = (ServiceTypeEntry)this._serviceTypes.get(key);
            aLog.append("\n\t\tType: ");
            aLog.append(subtypes.getType());
            aLog.append(": ");
            aLog.append(subtypes.isEmpty() ? "no subtypes" : subtypes);
        }
        aLog.append("\n");
        aLog.append(this._cache.toString());
        aLog.append("\n");
        aLog.append("\t---- Service Collectors ----");
        for (String key : this._serviceCollectors.keySet()) {
            aLog.append("\n\t\tService Collector: ");
            aLog.append(key);
            aLog.append(": ");
            aLog.append(this._serviceCollectors.get(key));
        }
        aLog.append("\n");
        aLog.append("\t---- Service Listeners ----");
        for (String key : this._serviceListeners.keySet()) {
            aLog.append("\n\t\tService Listener: ");
            aLog.append(key);
            aLog.append(": ");
            aLog.append(this._serviceListeners.get(key));
        }
        return aLog.toString();
    }

    @Override
    public ServiceInfo[] list(String type) {
        return this.list(type, 6000L);
    }

    @Override
    public ServiceInfo[] list(String type, long timeout) {
        this.cleanCache();
        String loType = type.toLowerCase();
        boolean newCollectorCreated = false;
        if (this.isCanceling() || this.isCanceled()) {
            System.out.println("JmDNS Cancelling.");
            return new ServiceInfo[0];
        }
        ServiceCollector collector = (ServiceCollector)this._serviceCollectors.get(loType);
        if (collector == null) {
            newCollectorCreated = this._serviceCollectors.putIfAbsent(loType, new ServiceCollector(type)) == null;
            collector = (ServiceCollector)this._serviceCollectors.get(loType);
            if (newCollectorCreated) {
                this.addServiceListener(type, collector, true);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getName() + "-collector: " + collector);
        }
        return collector != null ? collector.list(timeout) : new ServiceInfo[]{};
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String type) {
        return this.listBySubtype(type, 6000L);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String type, long timeout) {
        HashMap map = new HashMap(5);
        for (ServiceInfo info : this.list(type, timeout)) {
            String subtype = info.getSubtype().toLowerCase();
            if (!map.containsKey(subtype)) {
                map.put(subtype, new ArrayList(10));
            }
            ((List)map.get(subtype)).add(info);
        }
        HashMap<String, ServiceInfo[]> result = new HashMap<String, ServiceInfo[]>(map.size());
        for (String subtype : map.keySet()) {
            List infoForSubType = (List)map.get(subtype);
            result.put(subtype, infoForSubType.toArray(new ServiceInfo[infoForSubType.size()]));
        }
        return result;
    }

    private void disposeServiceCollectors() {
        if (logger.isDebugEnabled()) {
            logger.debug("disposeServiceCollectors()");
        }
        for (String type : this._serviceCollectors.keySet()) {
            ServiceCollector collector = (ServiceCollector)this._serviceCollectors.get(type);
            if (collector == null) continue;
            this.removeServiceListener(type, collector);
            this._serviceCollectors.remove(type, collector);
        }
    }

    static String toUnqualifiedName(String type, String qualifiedName) {
        String loType = type.toLowerCase();
        String loQualifiedName = qualifiedName.toLowerCase();
        if (loQualifiedName.endsWith(loType) && !loQualifiedName.equals(loType)) {
            return qualifiedName.substring(0, qualifiedName.length() - type.length() - 1);
        }
        return qualifiedName;
    }

    public Map<String, ServiceInfo> getServices() {
        return this._services;
    }

    public void setLastThrottleIncrement(long lastThrottleIncrement) {
        this._lastThrottleIncrement = lastThrottleIncrement;
    }

    public long getLastThrottleIncrement() {
        return this._lastThrottleIncrement;
    }

    public void setThrottle(int throttle) {
        this._throttle = throttle;
    }

    public int getThrottle() {
        return this._throttle;
    }

    public static Random getRandom() {
        return _random;
    }

    public void ioLock() {
        this._ioLock.lock();
    }

    public void ioUnlock() {
        this._ioLock.unlock();
    }

    public void setPlannedAnswer(DNSIncoming plannedAnswer) {
        this._plannedAnswer = plannedAnswer;
    }

    public DNSIncoming getPlannedAnswer() {
        return this._plannedAnswer;
    }

    void setLocalHost(HostInfo localHost) {
        this._localHost = localHost;
    }

    public Map<String, ServiceTypeEntry> getServiceTypes() {
        return this._serviceTypes;
    }

    public MulticastSocket getSocket() {
        return this._socket;
    }

    public InetAddress getGroup() {
        return this._group;
    }

    @Override
    public JmDNS.Delegate getDelegate() {
        return this._delegate;
    }

    @Override
    public JmDNS.Delegate setDelegate(JmDNS.Delegate delegate) {
        JmDNS.Delegate previous = this._delegate;
        this._delegate = delegate;
        return previous;
    }

    private static class ServiceCollector
    implements ServiceListener {
        private final ConcurrentMap<String, ServiceInfo> _infos = new ConcurrentHashMap<String, ServiceInfo>();
        private final ConcurrentMap<String, ServiceEvent> _events = new ConcurrentHashMap<String, ServiceEvent>();
        private final String _type;
        private volatile boolean _needToWaitForInfos;

        public ServiceCollector(String type) {
            this._type = type;
            this._needToWaitForInfos = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceAdded(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                ServiceInfo info = event.getInfo();
                if (info != null && info.hasData()) {
                    this._infos.put(event.getName(), info);
                } else {
                    String subtype = info != null ? info.getSubtype() : "";
                    info = ((JmDNSImpl)event.getDNS()).resolveServiceInfo(event.getType(), event.getName(), subtype, true);
                    if (info != null) {
                        this._infos.put(event.getName(), info);
                    } else {
                        this._events.put(event.getName(), event);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceRemoved(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                this._infos.remove(event.getName());
                this._events.remove(event.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceResolved(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                this._infos.put(event.getName(), event.getInfo());
                this._events.remove(event.getName());
            }
        }

        public ServiceInfo[] list(long timeout) {
            if (this._infos.isEmpty() || !this._events.isEmpty() || this._needToWaitForInfos) {
                long loops = timeout / 200L;
                if (loops < 1L) {
                    loops = 1L;
                }
                int i = 0;
                while ((long)i < loops) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this._events.isEmpty() && !this._infos.isEmpty() && !this._needToWaitForInfos) break;
                    ++i;
                }
            }
            this._needToWaitForInfos = false;
            return this._infos.values().toArray(new ServiceInfo[this._infos.size()]);
        }

        public String toString() {
            StringBuffer aLog = new StringBuffer();
            aLog.append("\n\tType: ");
            aLog.append(this._type);
            if (this._infos.isEmpty()) {
                aLog.append("\n\tNo services collected.");
            } else {
                aLog.append("\n\tServices");
                for (String key : this._infos.keySet()) {
                    aLog.append("\n\t\tService: ");
                    aLog.append(key);
                    aLog.append(": ");
                    aLog.append(this._infos.get(key));
                }
            }
            if (this._events.isEmpty()) {
                aLog.append("\n\tNo event queued.");
            } else {
                aLog.append("\n\tEvents");
                for (String key : this._events.keySet()) {
                    aLog.append("\n\t\tEvent: ");
                    aLog.append(key);
                    aLog.append(": ");
                    aLog.append(this._events.get(key));
                }
            }
            return aLog.toString();
        }
    }

    protected class Shutdown
    implements Runnable {
        protected Shutdown() {
        }

        @Override
        public void run() {
            try {
                JmDNSImpl.this._shutdown = null;
                JmDNSImpl.this.close();
            }
            catch (Throwable exception) {
                System.err.println("Error while shuting down. " + exception);
            }
        }
    }

    public static class ServiceTypeEntry
    extends AbstractMap<String, String>
    implements Cloneable {
        private final Set<Map.Entry<String, String>> _entrySet;
        private final String _type;

        public ServiceTypeEntry(String type) {
            this._type = type;
            this._entrySet = new HashSet<Map.Entry<String, String>>();
        }

        public String getType() {
            return this._type;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this._entrySet;
        }

        public boolean contains(String subtype) {
            return subtype != null && this.containsKey(subtype.toLowerCase());
        }

        public boolean add(String subtype) {
            if (subtype == null || this.contains(subtype)) {
                return false;
            }
            this._entrySet.add(new SubTypeEntry(subtype));
            return true;
        }

        public Iterator<String> iterator() {
            return this.keySet().iterator();
        }

        @Override
        public ServiceTypeEntry clone() {
            ServiceTypeEntry entry = new ServiceTypeEntry(this.getType());
            for (Map.Entry<String, String> subTypeEntry : this.entrySet()) {
                entry.add(subTypeEntry.getValue());
            }
            return entry;
        }

        @Override
        public String toString() {
            StringBuilder aLog = new StringBuilder(200);
            if (this.isEmpty()) {
                aLog.append("empty");
            } else {
                for (String value : this.values()) {
                    aLog.append(value);
                    aLog.append(", ");
                }
                aLog.setLength(aLog.length() - 2);
            }
            return aLog.toString();
        }

        private static class SubTypeEntry
        implements Map.Entry<String, String>,
        Serializable,
        Cloneable {
            private static final long serialVersionUID = 9188503522395855322L;
            private final String _key;
            private final String _value;

            public SubTypeEntry(String subtype) {
                this._value = subtype != null ? subtype : "";
                this._key = this._value.toLowerCase();
            }

            @Override
            public String getKey() {
                return this._key;
            }

            @Override
            public String getValue() {
                return this._value;
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object entry) {
                if (!(entry instanceof Map.Entry)) {
                    return false;
                }
                return this.getKey().equals(((Map.Entry)entry).getKey()) && this.getValue().equals(((Map.Entry)entry).getValue());
            }

            @Override
            public int hashCode() {
                return (this._key == null ? 0 : this._key.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
            }

            public SubTypeEntry clone() {
                return this;
            }

            public String toString() {
                return this._key + "=" + this._value;
            }
        }
    }

    public static enum Operation {
        Remove,
        Update,
        Add,
        RegisterServiceType,
        Noop;

    }
}

