/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.tasks.DNSTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Responder
extends DNSTask {
    static Logger logger = LoggerFactory.getLogger(Responder.class.getName());
    private final DNSIncoming _in;
    private final InetAddress _addr;
    private final int _port;
    private final boolean _unicast;

    public Responder(JmDNSImpl jmDNSImpl, DNSIncoming in, InetAddress addr, int port) {
        super(jmDNSImpl);
        this._in = in;
        this._addr = addr;
        this._port = port;
        this._unicast = port != DNSConstants.MDNS_PORT;
    }

    @Override
    public String getName() {
        return "Responder(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public String toString() {
        return super.toString() + " incomming: " + this._in;
    }

    @Override
    public void start(Timer timer) {
        int delay;
        boolean iAmTheOnlyOne = true;
        for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
            if (logger.isTraceEnabled()) {
                logger.trace(this.getName() + "start() question=" + dNSQuestion);
            }
            if (iAmTheOnlyOne = dNSQuestion.iAmTheOnlyOne(this.getDns())) continue;
            break;
        }
        int n = delay = iAmTheOnlyOne && !this._in.isTruncated() ? 0 : 20 + JmDNSImpl.getRandom().nextInt(96) - this._in.elapseSinceArrival();
        if (delay < 0) {
            delay = 0;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(this.getName() + "start() Responder chosen delay=" + delay);
        }
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, delay);
        }
    }

    @Override
    public void run() {
        this.getDns().respondToQuery(this._in);
        HashSet<DNSQuestion> questions = new HashSet<DNSQuestion>();
        HashSet<DNSRecord> answers = new HashSet<DNSRecord>();
        if (this.getDns().isAnnounced()) {
            try {
                for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.getName() + "run() JmDNS responding to: " + dNSQuestion);
                    }
                    if (this._unicast) {
                        questions.add(dNSQuestion);
                    }
                    dNSQuestion.addAnswers(this.getDns(), answers);
                }
                long now = System.currentTimeMillis();
                for (DNSRecord dNSRecord : this._in.getAnswers()) {
                    if (!dNSRecord.isStale(now)) continue;
                    answers.remove(dNSRecord);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(this.getName() + "JmDNS Responder Known Answer Removed");
                }
                if (!answers.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.getName() + "run() JmDNS responding");
                    }
                    DNSOutgoing out = new DNSOutgoing(33792, !this._unicast, this._in.getSenderUDPPayload());
                    if (this._unicast) {
                        out.setDestination(new InetSocketAddress(this._addr, this._port));
                    }
                    out.setId(this._in.getId());
                    for (DNSQuestion question : questions) {
                        if (question == null) continue;
                        out = this.addQuestion(out, question);
                    }
                    for (DNSRecord answer : answers) {
                        if (answer == null) continue;
                        out = this.addAnswer(out, this._in, answer);
                    }
                    if (!out.isEmpty()) {
                        this.getDns().send(out);
                    }
                }
            }
            catch (Throwable e) {
                logger.warn(this.getName() + "run() exception ", e);
                this.getDns().close();
            }
        }
    }
}

