/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack;

import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackPort;
import org.jaudiolibs.jnajack.lowlevel.JackLibrary;

public class JackMidi {
    private JackMidi() {
    }

    public static int getEventCount(JackPort port) throws JackException {
        try {
            return port.jackLib.jack_midi_get_event_count(port.bufferPtr);
        }
        catch (Throwable e) {
            throw new JackException(e);
        }
    }

    public static void eventGet(Event event, JackPort port, int index) throws JackException {
        try {
            JackLibrary.jack_midi_event_t nativeEvent = event.nativeEvent;
            int result = port.jackLib.jack_midi_event_get(nativeEvent, port.bufferPtr, index);
            if (result == 0) {
                return;
            }
        }
        catch (Throwable e) {
            throw new JackException(e);
        }
        throw new JackException("ENOBUF");
    }

    public static void clearBuffer(JackPort port) throws JackException {
        try {
            port.jackLib.jack_midi_clear_buffer(port.bufferPtr);
        }
        catch (Throwable e) {
            throw new JackException(e);
        }
    }

    public static int maxEventSize(JackPort port) throws JackException {
        try {
            return port.jackLib.jack_midi_max_event_size(port.bufferPtr);
        }
        catch (Throwable e) {
            throw new JackException(e);
        }
    }

    public static void eventWrite(JackPort port, int time, byte[] data, int data_size) throws JackException {
        try {
            port.jackLib.jack_midi_event_write(port.bufferPtr, time, data, data_size);
        }
        catch (Throwable e) {
            throw new JackException(e);
        }
    }

    public static int getLostEventCount(JackPort port) throws JackException {
        try {
            return port.jackLib.jack_midi_get_lost_event_count(port.bufferPtr);
        }
        catch (Throwable e) {
            throw new JackException(e);
        }
    }

    public static class Event {
        private final JackLibrary.jack_midi_event_t nativeEvent = new JackLibrary.jack_midi_event_t();

        public int time() {
            return this.nativeEvent.time;
        }

        public int size() {
            return this.nativeEvent.size.intValue();
        }

        public void read(byte[] data) throws JackException {
            try {
                this.nativeEvent.buffer.read(0L, data, 0, this.size());
            }
            catch (Throwable e) {
                throw new JackException(e);
            }
        }
    }
}

