/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.jnajack.lowlevel;

import com.sun.jna.Callback;
import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.List;

public interface JackLibrary
extends Library {
    public static final String JACK_DEFAULT_MIDI_TYPE = "8 bit raw midi";
    public static final String JACK_DEFAULT_AUDIO_TYPE = "32 bit float mono audio";
    public static final int JACK_LOAD_INIT_LIMIT = 1024;
    public static final long JACK_MAX_FRAMES = 0xFFFFFFFFL;

    public _jack_client jack_client_open(String var1, int var2, IntByReference var3);

    public int jack_client_close(_jack_client var1);

    public int jack_client_name_size();

    public String jack_get_client_name(_jack_client var1);

    public int jack_is_realtime(_jack_client var1);

    public void jack_on_shutdown(_jack_client var1, JackShutdownCallback var2, Pointer var3);

    public int jack_set_process_callback(_jack_client var1, JackProcessCallback var2, Pointer var3);

    public int jack_cycle_wait(_jack_client var1);

    public void jack_cycle_signal(_jack_client var1, int var2);

    public int jack_set_process_thread(_jack_client var1, JackThreadCallback var2, Pointer var3);

    public int jack_set_thread_init_callback(_jack_client var1, JackThreadInitCallback var2, Pointer var3);

    public int jack_set_freewheel_callback(_jack_client var1, JackFreewheelCallback var2, Pointer var3);

    public int jack_set_freewheel(_jack_client var1, int var2);

    public int jack_set_buffer_size(_jack_client var1, int var2);

    public int jack_set_buffer_size_callback(_jack_client var1, JackBufferSizeCallback var2, Pointer var3);

    public int jack_set_sample_rate_callback(_jack_client var1, JackSampleRateCallback var2, Pointer var3);

    public int jack_set_client_registration_callback(_jack_client var1, JackClientRegistrationCallback var2, Pointer var3);

    public int jack_set_port_registration_callback(_jack_client var1, JackPortRegistrationCallback var2, Pointer var3);

    public int jack_set_port_connect_callback(_jack_client var1, JackPortConnectCallback var2, Pointer var3);

    public int jack_set_graph_order_callback(_jack_client var1, JackGraphOrderCallback var2, Pointer var3);

    public int jack_set_xrun_callback(_jack_client var1, JackXRunCallback var2, Pointer var3);

    public int jack_activate(_jack_client var1);

    public int jack_deactivate(_jack_client var1);

    public _jack_port jack_port_register(_jack_client var1, String var2, String var3, NativeLong var4, NativeLong var5);

    public int jack_port_unregister(_jack_client var1, _jack_port var2);

    public Pointer jack_port_get_buffer(_jack_port var1, int var2);

    public String jack_port_name(_jack_port var1);

    public ByteByReference jack_port_short_name(_jack_port var1);

    public int jack_port_flags(_jack_port var1);

    public ByteByReference jack_port_type(_jack_port var1);

    public int jack_port_is_mine(_jack_client var1, _jack_port var2);

    public int jack_port_connected(_jack_port var1);

    public int jack_port_connected_to(_jack_port var1, String var2);

    public Pointer jack_port_get_connections(_jack_port var1);

    public Pointer jack_port_get_all_connections(_jack_client var1, _jack_port var2);

    public int jack_port_tie(_jack_port var1, _jack_port var2);

    public int jack_port_untie(_jack_port var1);

    public int jack_port_get_latency(_jack_port var1);

    public int jack_port_get_total_latency(_jack_client var1, _jack_port var2);

    public void jack_port_set_latency(_jack_port var1);

    public int jack_recompute_total_latency(_jack_client var1, _jack_port var2);

    public int jack_recompute_total_latencies(_jack_client var1);

    public int jack_port_set_name(_jack_port var1, String var2);

    public int jack_port_set_alias(_jack_port var1, String var2);

    public int jack_port_unset_alias(_jack_port var1, String var2);

    public int jack_port_request_monitor(_jack_port var1, int var2);

    public int jack_port_request_monitor_by_name(_jack_client var1, String var2, int var3);

    public int jack_port_ensure_monitor(_jack_port var1, int var2);

    public int jack_port_monitoring_input(_jack_port var1);

    public int jack_connect(_jack_client var1, String var2, String var3);

    public int jack_disconnect(_jack_client var1, String var2, String var3);

    public int jack_port_disconnect(_jack_client var1, _jack_port var2);

    public int jack_port_name_size();

    public int jack_port_type_size();

    public int jack_get_sample_rate(_jack_client var1);

    public int jack_get_buffer_size(_jack_client var1);

    public Pointer jack_get_ports(_jack_client var1, String var2, String var3, NativeLong var4);

    public _jack_port jack_port_by_name(_jack_client var1, String var2);

    public _jack_port jack_port_by_id(_jack_client var1, int var2);

    public void jack_port_get_latency_range(_jack_port var1, int var2, jack_latency_range_t var3);

    public int jack_frames_since_cycle_start(_jack_client var1);

    public int jack_frame_time(_jack_client var1);

    public int jack_last_frame_time(_jack_client var1);

    public int jack_time_to_frames(_jack_client var1);

    public float jack_cpu_load(_jack_client var1);

    public void jack_set_error_function(func var1);

    public void jack_set_info_function(func var1);

    public NativeLong jack_get_time();

    public void jack_free(Pointer var1);

    public void jack_midi_clear_buffer(Pointer var1);

    public int jack_midi_event_get(jack_midi_event_t var1, Pointer var2, int var3);

    public Pointer jack_midi_event_reserve(Pointer var1, int var2, int var3);

    public int jack_midi_event_write(Pointer var1, int var2, Pointer var3, int var4);

    public int jack_midi_event_write(Pointer var1, int var2, byte[] var3, int var4);

    public int jack_midi_get_event_count(Pointer var1);

    public int jack_midi_get_lost_event_count(Pointer var1);

    public int jack_midi_max_event_size(Pointer var1);

    public int jack_release_timebase(_jack_client var1);

    public int jack_get_current_transport_frame(_jack_client var1);

    public int jack_set_sync_callback(_jack_client var1, JackSyncCallback var2, Pointer var3);

    public int jack_set_sync_timeout(_jack_client var1, long var2);

    public int jack_set_timebase_callback(_jack_client var1, int var2, JackTimebaseCallback var3, Pointer var4);

    public int jack_transport_locate(_jack_client var1, int var2);

    public int jack_transport_query(_jack_client var1, jack_position_t var2);

    public int jack_transport_reposition(_jack_client var1, jack_position_t var2);

    public void jack_transport_start(_jack_client var1);

    public void jack_transport_stop(_jack_client var1);

    public static class jack_latency_range_t
    extends Structure {
        public int min;
        public int max;

        public jack_latency_range_t() {
        }

        public jack_latency_range_t(Pointer pointer, int offset) {
            this.useMemory(pointer, offset);
            this.read();
        }

        public jack_latency_range_t(jack_latency_range_t struct) {
            this(struct.getPointer(), 0);
        }

        protected List getFieldOrder() {
            return Arrays.asList("min", "max");
        }

        public static class ByValue
        extends jack_latency_range_t
        implements Structure.ByValue {
            public ByValue() {
            }

            public ByValue(jack_latency_range_t struct) {
                super(struct.getPointer(), 0);
            }
        }

        public static class ByReference
        extends jack_latency_range_t
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(jack_latency_range_t struct) {
                super(struct.getPointer(), 0);
            }
        }
    }

    public static interface jack_latency_callback_mode {
        public static final int JackCaptureLatency = 0;
        public static final int JackPlaybackLatency = 1;
    }

    public static class size_t
    extends IntegerType {
        public size_t() {
            this(0L);
        }

        public size_t(long value) {
            super(Native.SIZE_T_SIZE, value);
        }
    }

    public static class jack_midi_event_t
    extends Structure {
        public int time;
        public size_t size;
        public Pointer buffer;

        protected List getFieldOrder() {
            return Arrays.asList("time", "size", "buffer");
        }
    }

    public static class _jack_port
    extends PointerType {
        public _jack_port(Pointer pointer) {
            super(pointer);
        }

        public _jack_port() {
        }
    }

    public static class _jack_client
    extends PointerType {
        public _jack_client(Pointer pointer) {
            super(pointer);
        }

        public _jack_client() {
        }
    }

    public static interface func2
    extends Callback {
        public void invoke(ByteByReference var1);
    }

    public static interface jack_info_callback
    extends Callback {
        public void invoke(ByteByReference var1);
    }

    public static interface func
    extends Callback {
        public void invoke(ByteByReference var1);
    }

    public static interface jack_error_callback
    extends Callback {
        public void invoke(ByteByReference var1);
    }

    public static interface JackTimebaseCallback
    extends Callback {
        public void invoke(int var1, int var2, Pointer var3, int var4, Pointer var5);
    }

    public static interface JackSyncCallback
    extends Callback {
        public int invoke(int var1, Pointer var2, Pointer var3);
    }

    public static interface JackShutdownCallback
    extends Callback {
        public void invoke(Pointer var1);
    }

    public static interface JackFreewheelCallback
    extends Callback {
        public void invoke(int var1, Pointer var2);
    }

    public static interface JackPortRenameCallback
    extends Callback {
        public int invoke(int var1, ByteByReference var2, Pointer var3);
    }

    public static interface JackPortConnectCallback
    extends Callback {
        public void invoke(int var1, int var2, int var3, Pointer var4);
    }

    public static interface JackClientRegistrationCallback
    extends Callback {
        public void invoke(ByteByReference var1, int var2, Pointer var3);
    }

    public static interface JackPortRegistrationCallback
    extends Callback {
        public void invoke(int var1, int var2, Pointer var3);
    }

    public static interface JackSampleRateCallback
    extends Callback {
        public int invoke(int var1, Pointer var2);
    }

    public static interface JackBufferSizeCallback
    extends Callback {
        public int invoke(int var1, Pointer var2);
    }

    public static interface JackXRunCallback
    extends Callback {
        public int invoke(Pointer var1);
    }

    public static interface JackGraphOrderCallback
    extends Callback {
        public int invoke(Pointer var1);
    }

    public static interface JackThreadInitCallback
    extends Callback {
        public void invoke(Pointer var1);
    }

    public static interface JackThreadCallback
    extends Callback {
        public Pointer invoke(Pointer var1);
    }

    public static interface JackProcessCallback
    extends Callback {
        public int invoke(int var1);
    }

    public static class jack_position_t
    extends Structure {
        public long unique_1;
        public long usecs;
        public int frame_rate;
        public int frame;
        public int valid;
        public int bar;
        public int beat;
        public int tick;
        public double bar_start_tick;
        public float beats_per_bar;
        public float beat_type;
        public double ticks_per_beat;
        public double beats_per_minute;
        public double frame_time;
        public double next_time;
        public int bbt_offset;
        public float audio_frames_per_video_frame;
        public int video_offset;
        public int[] padding = new int[7];
        public long unique_2;

        public jack_position_t() {
        }

        public jack_position_t(Pointer pointer, int offset) {
            this.useMemory(pointer, offset);
            this.read();
        }

        public jack_position_t(jack_position_t struct) {
            this(struct.getPointer(), 0);
        }

        protected List getFieldOrder() {
            return Arrays.asList("unique_1", "usecs", "frame_rate", "frame", "valid", "bar", "beat", "tick", "bar_start_tick", "beats_per_bar", "beat_type", "ticks_per_beat", "beats_per_minute", "frame_time", "next_time", "bbt_offset", "audio_frames_per_video_frame", "video_offset", "padding", "unique_2");
        }

        public static class ByValue
        extends jack_position_t
        implements Structure.ByValue {
            public ByValue() {
            }

            public ByValue(jack_position_t struct) {
                super(struct.getPointer(), 0);
            }
        }

        public static class ByReference
        extends jack_position_t
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(jack_position_t struct) {
                super(struct.getPointer(), 0);
            }
        }
    }

    public static interface JackStatus {
        public static final int JackFailure = 1;
        public static final int JackInvalidOption = 2;
        public static final int JackNameNotUnique = 4;
        public static final int JackServerStarted = 8;
        public static final int JackServerFailed = 16;
        public static final int JackServerError = 32;
        public static final int JackNoSuchClient = 64;
        public static final int JackLoadFailure = 128;
        public static final int JackInitFailure = 256;
        public static final int JackShmFailure = 512;
        public static final int JackVersionError = 1024;
    }

    public static interface JackOptions {
        public static final int JackNullOption = 0;
        public static final int JackNoStartServer = 1;
        public static final int JackUseExactName = 2;
        public static final int JackServerName = 4;
        public static final int JackLoadName = 8;
        public static final int JackLoadInit = 16;
    }

    public static interface JackPortFlags {
        public static final int JackPortIsInput = 1;
        public static final int JackPortIsOutput = 2;
        public static final int JackPortIsPhysical = 4;
        public static final int JackPortCanMonitor = 8;
        public static final int JackPortIsTerminal = 16;
    }

    public static interface jack_transport_bits_t {
        public static final int JackTransportState = 1;
        public static final int JackTransportPosition = 2;
        public static final int JackTransportLoop = 4;
        public static final int JackTransportSMPTE = 8;
        public static final int JackTransportBBT = 16;
    }

    public static interface jack_position_bits_t {
        public static final int JackPositionBBT = 16;
        public static final int JackPositionTimecode = 32;
        public static final int JackBBTFrameOffset = 64;
        public static final int JackAudioVideoRatio = 128;
        public static final int JackVideoFrameOffset = 256;
    }

    public static interface jack_transport_state_t {
        public static final int JackTransportStopped = 0;
        public static final int JackTransportRolling = 1;
        public static final int JackTransportLooping = 2;
        public static final int JackTransportStarting = 3;
        public static final int JackTransportNetStarting = 4;
    }
}

