/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import io.github.leovr.rtipmidi.session.AppleMidiSessionClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.openstatic.midi.ports.RTPMidiPort;

public class AppleMidiSessionClientCellRenderer
extends JPanel
implements ListCellRenderer<AppleMidiSessionClient> {
    private Border selectedBorder;
    private Border regularBorder;
    private JCheckBox checkBox;
    private ImageIcon urlIcon;
    private RTPMidiPort rtpPort;

    public AppleMidiSessionClientCellRenderer(RTPMidiPort rtpPort) {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.rtpPort = rtpPort;
        this.selectedBorder = BorderFactory.createLineBorder(Color.RED, 1);
        this.checkBox = new JCheckBox("");
        this.checkBox.setOpaque(false);
        this.add((Component)this.checkBox, "Center");
        try {
            this.urlIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/rtpnet32.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends AppleMidiSessionClient> list, AppleMidiSessionClient client, int index, boolean isSelected, boolean cellHasFocus) {
        this.checkBox.setIcon(this.urlIcon);
        Object ipString = client.getRemoteAddress().toString() + ":" + String.valueOf(client.getControlPort());
        if (((String)ipString).startsWith("/")) {
            ipString = ((String)ipString).substring(1);
        }
        if (client.isConnected() || client.hasServerConnection(this.rtpPort.getAppleMidiServer())) {
            this.checkBox.setText("<html><body style=\"padding: 3px 3px 3px 3px;\"><b style=\"font-size: 14px;\">" + client.getRemoteName() + "</b><br />" + (String)ipString + " (Connected)</body></html>");
        } else {
            this.checkBox.setText("<html><body style=\"padding: 3px 3px 3px 3px;\"><span style=\"font-size: 14px;\">" + client.getRemoteName() + "</span><br />" + (String)ipString + " (Not Connected)</body></html>");
        }
        this.checkBox.setSelected(client.isConnected());
        this.setBackground(Color.WHITE);
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        if (isSelected) {
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(this.regularBorder);
        }
        return this;
    }
}

