/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstatic.MidiTools;
import org.openstatic.midi.MidiControl;

public class CreateControlDialog
extends JDialog
implements ActionListener {
    private JTextField nicknameField;
    private JComboBox<Integer> selectChannel;
    private JComboBox<Integer> selectCC;
    private JButton saveButton;
    private JButton deleteButton;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton) {
            this.dispose();
        }
        if (e.getSource() == this.saveButton) {
            int cc;
            int channel = (Integer)this.selectChannel.getSelectedItem();
            MidiControl mc = MidiTools.getMidiControlByChannelCC(channel, cc = ((Integer)this.selectCC.getSelectedItem()).intValue());
            if (mc == null) {
                mc = new MidiControl(channel, cc);
                mc.setNickname(this.nicknameField.getText());
                final MidiControl fmc = mc;
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        MidiTools.handleNewMidiControl(fmc);
                    }
                };
                t.start();
                this.dispose();
            } else {
                int n = JOptionPane.showConfirmDialog(null, "Control already exists! Update Nickname?", "Control Exists", 0);
                if (n == 0) {
                    mc.setNickname(this.nicknameField.getText());
                    MidiTools.repaintControls();
                    this.dispose();
                }
            }
        }
    }

    public CreateControlDialog() {
        super(MidiTools.instance, "Control Creator", true);
        this.setLayout(new BorderLayout());
        this.nicknameField = new JTextField("");
        Vector<Integer> midiChannels = new Vector<Integer>();
        for (int i = 1; i < 17; ++i) {
            midiChannels.add(i);
        }
        this.selectChannel = new JComboBox(midiChannels);
        this.selectChannel.addActionListener(this);
        Vector<Integer> controlChangeNumbers = new Vector<Integer>();
        for (int i = 0; i < 128; ++i) {
            controlChangeNumbers.add(i);
        }
        this.selectCC = new JComboBox(controlChangeNumbers);
        this.selectCC.addActionListener(this);
        JPanel formPanel = new JPanel(new GridBagLayout());
        formPanel.add((Component)new JLabel("Control Name", 2), this.gbc(1, 1, 0.4));
        formPanel.add((Component)this.nicknameField, this.gbc(2, 1, 0.6));
        formPanel.add((Component)new JLabel("MIDI Channel", 2), this.gbc(1, 2, 0.4));
        formPanel.add(this.selectChannel, this.gbc(2, 2, 0.6));
        formPanel.add((Component)new JLabel("Select Control Change#", 2), this.gbc(1, 3, 0.4));
        formPanel.add(this.selectCC, this.gbc(2, 3, 0.6));
        this.saveButton = new JButton("Create Control");
        this.deleteButton = new JButton("Cancel");
        this.saveButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.saveButton);
        formPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)formPanel, "First");
        this.add((Component)buttonPanel, "Last");
        this.centerWindow();
    }

    private GridBagConstraints gbc(int x, int y, double weightx) {
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.weightx = weightx;
        g.gridx = x;
        g.gridy = y;
        g.ipady = 2;
        g.ipadx = 5;
        return g;
    }

    public JPanel labelComponent(String label, Component c) {
        JPanel x = new JPanel(new GridLayout(1, 2));
        x.add(new JLabel(label, 0));
        x.add(c);
        return x;
    }

    public void centerWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        float WIDTH = screenSize.width;
        float HEIGHT = screenSize.height;
        int wWidth = 400;
        int wHeight = 250;
        int x = (int)(WIDTH / 2.0f - (float)wWidth / 2.0f);
        int y = (int)(HEIGHT / 2.0f - (float)wHeight / 2.0f);
        this.setBounds(x, y, wWidth, wHeight);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setVisible(true);
    }
}

