/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstatic.CreateMappingDialog;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.MidiPortMapping;
import org.openstatic.midi.MidiPortMappingCellRenderer;
import org.openstatic.midi.MidiPortMappingListModel;

public class MappingControlBox
extends JPanel
implements ActionListener {
    private JList<MidiPortMapping> mappingList;
    private MidiPortMappingCellRenderer midiPortMappingCellRenderer = new MidiPortMappingCellRenderer();
    private long lastMappingClick;
    private JPanel buttonPanel;
    private JButton connectButton;
    private JButton selectAllButton;
    private JButton disableAllButton;
    private JButton enableAllButton;
    private JButton deleteButton;

    public MappingControlBox() {
        super(new BorderLayout());
        this.mappingList = new JList<MidiPortMapping>(new MidiPortMappingListModel());
        this.mappingList.setOpaque(true);
        this.mappingList.setCellRenderer(this.midiPortMappingCellRenderer);
        this.mappingList.setSelectionMode(2);
        this.mappingList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = MappingControlBox.this.mappingList.locationToIndex(e.getPoint());
                if (index != -1) {
                    int n;
                    MidiPortMapping mapping = MappingControlBox.this.mappingList.getModel().getElementAt(index);
                    if (e.getButton() == 1) {
                        long cms = System.currentTimeMillis();
                        if (cms - MappingControlBox.this.lastMappingClick < 500L && MappingControlBox.this.lastMappingClick > 0L) {
                            mapping.toggle();
                        }
                        MappingControlBox.this.lastMappingClick = cms;
                    } else if ((e.getButton() == 2 || e.getButton() == 3) && (n = JOptionPane.showConfirmDialog(null, "Delete this port mapping?\n" + mapping.toString(), "Port Mapping", 0)) == 0) {
                        MidiPortManager.removeMidiPortMapping(mapping);
                    }
                    MappingControlBox.this.repaint();
                }
            }
        });
        JScrollPane mappingScrollPane = new JScrollPane(this.mappingList, 22, 31);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        try {
            ImageIcon plugInIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/plug_in.png")));
            this.connectButton = new JButton(plugInIcon);
            this.connectButton.setActionCommand("connect");
            this.connectButton.addActionListener(this);
            this.connectButton.setToolTipText("Create a new port mapping (Basically a virtual midi cable)");
            this.buttonPanel.add(this.connectButton);
            ImageIcon selectAllIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/selectall32.png")));
            this.selectAllButton = new JButton(selectAllIcon);
            this.selectAllButton.addActionListener(this);
            this.selectAllButton.setActionCommand("select_all");
            this.selectAllButton.setToolTipText("Select All");
            this.buttonPanel.add(this.selectAllButton);
            ImageIcon disableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/disable32.png")));
            this.disableAllButton = new JButton(disableIcon);
            this.disableAllButton.addActionListener(this);
            this.disableAllButton.setActionCommand("disable_selected");
            this.disableAllButton.setToolTipText("Disable selected mappings");
            this.buttonPanel.add(this.disableAllButton);
            ImageIcon enableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/enable32.png")));
            this.enableAllButton = new JButton(enableIcon);
            this.enableAllButton.addActionListener(this);
            this.enableAllButton.setActionCommand("enable_selected");
            this.enableAllButton.setToolTipText("Enable selected mappings");
            this.buttonPanel.add(this.enableAllButton);
            ImageIcon trashIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/trash32.png")));
            this.deleteButton = new JButton(trashIcon);
            this.deleteButton.addActionListener(this);
            this.deleteButton.setActionCommand("delete_selected");
            this.deleteButton.setToolTipText("Delete Selected mappings");
            this.buttonPanel.add(this.deleteButton);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.add((Component)mappingScrollPane, "Center");
        this.add((Component)this.buttonPanel, "West");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectButton) {
            CreateMappingDialog createMappingDialog = new CreateMappingDialog();
        } else if (e.getSource() == this.enableAllButton) {
            Collection<MidiPortMapping> selectedMappings = this.getSelectedMappings();
            if (selectedMappings.size() != 0) {
                for (MidiPortMapping mapping : selectedMappings) {
                    mapping.setOpen(true);
                }
            }
        } else if (e.getSource() == this.disableAllButton) {
            Collection<MidiPortMapping> selectedRules = this.getSelectedMappings();
            if (selectedRules.size() != 0) {
                for (MidiPortMapping mapping : selectedRules) {
                    mapping.setOpen(false);
                }
            }
        } else if (e.getSource() == this.deleteButton) {
            Collection<MidiPortMapping> selectedRules = this.getSelectedMappings();
            if (selectedRules.size() != 0) {
                for (MidiPortMapping mapping : selectedRules) {
                    MidiPortManager.removeMidiPortMapping(mapping);
                }
            }
        } else if (e.getSource() == this.selectAllButton) {
            int rs = MidiPortManager.getMidiPortMappings().size();
            int[] indices = new int[rs];
            for (int i = 0; i < rs; ++i) {
                indices[i] = i;
            }
            this.mappingList.setSelectedIndices(indices);
        }
    }

    public Collection<MidiPortMapping> getSelectedMappings() {
        return this.mappingList.getSelectedValuesList();
    }
}

