/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.midi.ShortMessage;
import org.json.JSONObject;
import org.openstatic.MidiTools;
import org.openstatic.midi.MidiControl;
import org.openstatic.midi.MidiControlListener;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.MidiPortMapping;
import org.openstatic.midi.MidiToolsPlugin;
import org.openstatic.util.PendingURLFetch;
import org.openstatic.util.SoundFile;

public class MidiControlRule
implements MidiControlListener {
    private String nickname;
    private int action_type;
    private String ruleId;
    private String ruleGroup;
    private String canvasName;
    private String action_value;
    private int event_mode;
    private MidiControl control;
    private boolean enabled;
    private SoundFile sound;
    private long lastTriggered;
    private long lastFailed;
    private boolean valueInverted;
    private boolean valueSettled;
    public static final int ACTION_URL = 0;
    public static final int ACTION_PROC = 1;
    public static final int ACTION_SOUND = 2;
    public static final int ACTION_TRANSMIT = 3;
    public static final int ACTION_PLUGIN = 4;
    public static final int LOGGER_A_MESSAGE = 5;
    public static final int LOGGER_B_MESSAGE = 6;
    public static final int ACTION_ENABLE_RULE_GROUP = 7;
    public static final int ACTION_DISABLE_RULE_GROUP = 8;
    public static final int ACTION_TOGGLE_RULE_GROUP = 9;
    public static final int ACTION_EFFECT_IMAGE = 10;
    public static final int ACTION_ENABLE_MAPPING = 11;
    public static final int ACTION_DISABLE_MAPPING = 12;
    public static final int ACTION_TOGGLE_MAPPING = 13;
    public static final int ACTION_TRANSMIT_NOTE_ON = 14;
    public static final int ACTION_TRANSMIT_NOTE_OFF = 15;
    public static final int EVENT_CHANGE = 0;
    public static final int EVENT_INCREASE = 1;
    public static final int EVENT_DECREASE = 2;
    public static final int EVENT_HIGH = 3;
    public static final int EVENT_LOW = 4;
    public static final int EVENT_ENTERED_HIGH = 5;
    public static final int EVENT_ENTERED_LOW = 6;
    public static final int EVENT_ENTERED_HIGH_LOW = 7;
    public static final int EVENT_BOTTOM_THIRD = 8;
    public static final int EVENT_MIDDLE_THIRD = 9;
    public static final int EVENT_TOP_THIRD = 10;
    public static final int EVENT_ENTERED_BOTTOM_THIRD = 11;
    public static final int EVENT_ENTERED_MIDDLE_THIRD = 12;
    public static final int EVENT_ENTERED_TOP_THIRD = 13;

    public MidiControlRule(JSONObject jo) {
        System.err.println("READING RULE: " + jo.toString());
        this.ruleId = jo.optString("ruleId", MidiPortManager.generateBigAlphaKey(24));
        this.ruleGroup = jo.optString("ruleGroup", "all");
        this.event_mode = jo.optInt("eventMode", 0);
        if (this.event_mode > 13) {
            this.event_mode = 0;
        }
        this.action_type = jo.optInt("actionType", 0);
        if (this.action_type > 14) {
            this.action_type = 5;
        }
        this.action_value = jo.optString("actionValue", null);
        this.nickname = jo.optString("nickname", null);
        this.canvasName = jo.optString("canvas", "(ALL)");
        this.enabled = jo.optBoolean("enabled", true);
        this.lastTriggered = jo.optLong("lastTriggered", 0L);
        this.lastFailed = jo.optLong("lastFailed", 0L);
        this.valueInverted = jo.optBoolean("valueInverted", false);
        this.valueSettled = jo.optBoolean("valueSettled", false);
        if (jo.has("control")) {
            JSONObject ctrl = jo.getJSONObject("control");
            int ccNum = ctrl.optInt("cc", -1);
            MidiControl mc = null;
            if (ccNum >= 0) {
                mc = MidiTools.getMidiControlByChannelCC(ctrl.optInt("channel", 0), ccNum);
                if (mc == null) {
                    mc = MidiTools.createMidiControlFromJSON(ctrl);
                }
            } else {
                mc = MidiTools.getMidiControlByChannelNote(ctrl.optInt("channel", 0), ctrl.optInt("note", -1));
                if (mc == null) {
                    mc = MidiTools.createMidiControlFromJSON(ctrl);
                }
            }
            this.control = mc;
            this.updateRule();
        } else {
            this.actionValueChanged();
        }
    }

    public MidiControlRule(MidiControl control, int event_mode, int action_type, String action_value) {
        this.ruleId = MidiPortManager.generateBigAlphaKey(24);
        this.ruleGroup = "all";
        this.control = control;
        this.event_mode = event_mode;
        this.action_type = action_type;
        this.action_value = action_value;
        this.canvasName = "(ALL)";
        this.enabled = true;
        this.valueInverted = false;
        this.valueSettled = false;
        this.actionValueChanged();
    }

    public void controlValueAction(MidiControl control, int old_value, int new_value) {
        if (this.event_mode == 0) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 5 && new_value >= 64 && old_value <= 63) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 6 && new_value <= 63 && old_value >= 64) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 1 && new_value > old_value) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 2 && new_value < old_value) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 7 && (new_value >= 64 && old_value <= 63 || new_value <= 63 && old_value >= 64)) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 11 && new_value <= 42 && old_value >= 43) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 12 && new_value >= 43 && new_value <= 85 && (old_value <= 42 || old_value >= 86)) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 13 && new_value >= 86 && old_value <= 85) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 8 && new_value <= 42) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 9 && new_value >= 43 && new_value <= 85) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 10 && new_value >= 86) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 3 && new_value >= 64) {
            this.executeAction(control, old_value, new_value);
        } else if (this.event_mode == 4 && new_value <= 63) {
            this.executeAction(control, old_value, new_value);
        }
    }

    @Override
    public void controlValueChanged(MidiControl control, int old_value, int new_value) {
        if (!this.valueSettled) {
            if (this.valueInverted) {
                new_value = 127 - new_value;
                old_value = 127 - old_value;
            }
            this.controlValueAction(control, old_value, new_value);
        }
    }

    @Override
    public void controlValueSettled(MidiControl control, int old_value, int new_value) {
        if (this.valueSettled) {
            if (this.valueInverted) {
                new_value = 127 - new_value;
                old_value = 127 - old_value;
            }
            this.controlValueAction(control, old_value, new_value);
        }
    }

    public boolean isValueInverted() {
        return this.valueInverted;
    }

    public void setValueInverted(boolean v) {
        this.valueInverted = v;
    }

    public void setValueSettled(boolean v) {
        this.valueSettled = v;
    }

    public boolean shouldValueSettle() {
        return this.valueSettled;
    }

    public static String mapReplace(String source, int value) {
        Pattern p = Pattern.compile("\\{\\{value.map\\((\\d+)\\,(\\d+)\\)\\}\\}");
        Matcher m = p.matcher(source);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            int out_min = Integer.valueOf(m.group(1));
            int out_max = Integer.valueOf(m.group(2));
            int new_value = value * (out_max - out_min) / 127 + out_min;
            m.appendReplacement(s, String.valueOf(new_value));
        }
        m.appendTail(s);
        return s.toString();
    }

    private static String[] mergeArrays(String[] first, String[] second) {
        ArrayList both = new ArrayList(first.length + second.length);
        Collections.addAll(both, first);
        Collections.addAll(both, second);
        return both.toArray(new String[both.size()]);
    }

    private static String[] prependArray(String first, String[] second) {
        ArrayList<String> both = new ArrayList<String>(1 + second.length);
        both.add(first);
        Collections.addAll(both, second);
        return both.toArray(new String[both.size()]);
    }

    public void executeAction(MidiControl control, int old_value, int new_value) {
        if (this.enabled) {
            boolean success;
            block67: {
                success = false;
                try {
                    MidiPortMapping mapping;
                    if (this.action_value == null) break block67;
                    String avparsed = MidiControlRule.mapReplace(this.action_value, new_value).replaceAll("\\{\\{value\\}\\}", String.valueOf(new_value)).replaceAll("\\{\\{value.inv\\}\\}", String.valueOf(127 - new_value)).replaceAll("\\{\\{value.old\\}\\}", String.valueOf(old_value)).replaceAll("\\{\\{value.old.inv\\}\\}", String.valueOf(127 - old_value)).replaceAll("\\{\\{value.change\\}\\}", String.valueOf(new_value - old_value)).replaceAll("\\{\\{cc\\}\\}", String.valueOf(control.getControlNumber())).replaceAll("\\{\\{note\\}\\}", String.valueOf(control.getNoteNumber())).replaceAll("\\{\\{note.name\\}\\}", control.getNoteName()).replaceAll("\\{\\{channel\\}\\}", String.valueOf(control.getChannel()));
                    if (this.getActionType() == 0) {
                        PendingURLFetch puf = new PendingURLFetch(avparsed);
                        puf.run();
                        success = true;
                        break block67;
                    }
                    if (this.getActionType() == 1) {
                        try {
                            String[] avparsed2 = avparsed.split(",");
                            if (avparsed2[0].endsWith(".cmd") || avparsed2[0].endsWith(".bat")) {
                                avparsed2 = MidiControlRule.prependArray(System.getenv("windir") + "\\system32\\cmd.exe", avparsed2);
                            } else if (avparsed2[0].endsWith(".sh") || avparsed2[0].endsWith(".bash")) {
                                avparsed2 = MidiControlRule.prependArray("/bin/bash", avparsed2);
                            }
                            ProcessBuilder pb = new ProcessBuilder(avparsed2);
                            pb.directory(MidiTools.getAssetFolder());
                            Process process = pb.start();
                            if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                                process.destroyForcibly();
                            }
                            success = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        break block67;
                    }
                    if (this.getActionType() == 2) {
                        if (!"(NONE)".equals(this.canvasName) && this.canvasName != null) {
                            JSONObject canvasEvent = new JSONObject();
                            canvasEvent.put("sound", this.action_value);
                            canvasEvent.put("canvas", this.canvasName);
                            canvasEvent.put("volume", MidiControlRule.mapFloat(Float.valueOf(new_value).floatValue(), 0.0f, 127.0f, 0.0f, 1.0f));
                            success = MidiTools.instance.apiServer.broadcastCanvasJSONObject(canvasEvent);
                        } else if (this.sound != null) {
                            float volume = MidiControlRule.mapFloat(Float.valueOf(new_value).floatValue(), 0.0f, 127.0f, -40.0f, 0.0f);
                            this.sound.setVolume(volume);
                            this.sound.play();
                            success = true;
                        }
                        break block67;
                    }
                    if (this.getActionType() == 10) {
                        if ("(NONE)".equals(this.canvasName) || this.canvasName == null) break block67;
                        StringTokenizer st = new StringTokenizer(avparsed, ",");
                        String filename = st.nextToken();
                        String mode = "opacity";
                        String zIndex = "0";
                        if (st.hasMoreTokens()) {
                            mode = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            zIndex = st.nextToken();
                        }
                        JSONObject canvasEvent = new JSONObject();
                        canvasEvent.put("image", filename);
                        if (mode.contains("solo")) {
                            canvasEvent.put("solo", true);
                        }
                        if (mode.contains("fill-x")) {
                            canvasEvent.put("fill", "x");
                        } else if (mode.contains("fill-y")) {
                            canvasEvent.put("fill", "y");
                        }
                        if (mode.contains("none")) {
                            canvasEvent.put("none", MidiControlRule.mapFloat(Float.valueOf(new_value).floatValue(), 0.0f, 127.0f, 0.0f, 1.0f));
                        }
                        if (mode.contains("opacity")) {
                            canvasEvent.put("opacity", MidiControlRule.mapFloat(Float.valueOf(new_value).floatValue(), 0.0f, 127.0f, 0.0f, 1.0f));
                        }
                        if (mode.contains("curtain")) {
                            canvasEvent.put("curtain", MidiControlRule.mapFloat(Float.valueOf(new_value).floatValue(), 0.0f, 127.0f, 0.0f, 1.0f));
                        }
                        if (mode.contains("riser")) {
                            canvasEvent.put("riser", MidiControlRule.mapFloat(Float.valueOf(new_value).floatValue(), 0.0f, 127.0f, 0.0f, 1.0f));
                        }
                        if (mode.contains("scale")) {
                            canvasEvent.put("scale", MidiControlRule.mapFloat(Float.valueOf(new_value).floatValue(), 0.0f, 127.0f, 0.0f, 1.0f));
                        }
                        if (mode.contains("rotate")) {
                            canvasEvent.put("rotate", MidiControlRule.mapFloat(Float.valueOf(new_value).floatValue(), 0.0f, 127.0f, 0.0f, 360.0f));
                        }
                        canvasEvent.put("canvas", this.canvasName);
                        int zIndexInt = 0;
                        try {
                            zIndexInt = Integer.valueOf(zIndex);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        canvasEvent.put("zIndex", zIndexInt);
                        success = MidiTools.instance.apiServer.broadcastCanvasJSONObject(canvasEvent);
                        break block67;
                    }
                    if (this.getActionType() == 3) {
                        StringTokenizer st = new StringTokenizer(avparsed, ",");
                        if (st.countTokens() != 4) break block67;
                        try {
                            String devName = st.nextToken();
                            int channel = Integer.valueOf(st.nextToken()) - 1;
                            int cc = Integer.valueOf(st.nextToken());
                            int v = Integer.valueOf(st.nextToken());
                            ShortMessage sm = new ShortMessage(176, channel, cc, v);
                            MidiPort output = MidiPortManager.findReceivingPortByName(devName);
                            if (output != null && output.isOpened()) {
                                output.send(sm, output.getMicrosecondPosition());
                                success = true;
                            }
                            break block67;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        break block67;
                    }
                    if (this.getActionType() == 14) {
                        StringTokenizer st = new StringTokenizer(avparsed, ",");
                        if (st.countTokens() != 4) break block67;
                        try {
                            MidiPort output;
                            String devName = st.nextToken();
                            int channel = Integer.valueOf(st.nextToken()) - 1;
                            int note = Integer.valueOf(st.nextToken());
                            int v = Integer.valueOf(st.nextToken());
                            ShortMessage sm = new ShortMessage(144, channel, note, v);
                            if (v == 0) {
                                sm = new ShortMessage(128, channel, note, v);
                            }
                            if ((output = MidiPortManager.findReceivingPortByName(devName)) != null && output.isOpened()) {
                                output.send(sm, output.getMicrosecondPosition());
                                success = true;
                            }
                            break block67;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        break block67;
                    }
                    if (this.getActionType() == 15) {
                        StringTokenizer st = new StringTokenizer(avparsed, ",");
                        if (st.countTokens() != 4) break block67;
                        try {
                            String devName = st.nextToken();
                            int channel = Integer.valueOf(st.nextToken()) - 1;
                            int note = Integer.valueOf(st.nextToken());
                            ShortMessage sm = new ShortMessage(128, channel, note, 0);
                            MidiPort output = MidiPortManager.findReceivingPortByName(devName);
                            if (output != null && output.isOpened()) {
                                output.send(sm, output.getMicrosecondPosition());
                                success = true;
                            }
                            break block67;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        break block67;
                    }
                    if (this.getActionType() == 7) {
                        MidiTools.setRuleGroupEnabled(avparsed, true);
                        success = true;
                    } else if (this.getActionType() == 8) {
                        MidiTools.setRuleGroupEnabled(avparsed, false);
                        success = true;
                    } else if (this.getActionType() == 9) {
                        if (new_value >= 64) {
                            MidiTools.setRuleGroupEnabled(avparsed, true);
                        } else {
                            MidiTools.setRuleGroupEnabled(avparsed, false);
                        }
                        success = true;
                    } else if (this.getActionType() == 5) {
                        MidiTools.instance.midi_logger_a.println(avparsed);
                        success = true;
                    } else if (this.getActionType() == 6) {
                        MidiTools.instance.midi_logger_b.println(avparsed);
                        success = true;
                    } else if (this.getActionType() == 4) {
                        if (!this.action_value.equals("") && this.action_value != null) {
                            String[] avparsed2 = this.action_value.split(",");
                            success = avparsed2.length > 1 ? MidiTools.instance.plugins.get(avparsed2[0]).onRule(this, avparsed2[1], old_value, new_value) : MidiTools.instance.plugins.get(avparsed2[0]).onRule(this, null, old_value, new_value);
                        }
                    } else if (this.getActionType() == 11) {
                        MidiPortMapping mapping2 = MidiPortManager.findMidiPortMappingById(avparsed);
                        if (mapping2 != null) {
                            mapping2.setOpen(true);
                            success = mapping2.isOpened();
                        }
                    } else if (this.getActionType() == 12) {
                        MidiPortMapping mapping3 = MidiPortManager.findMidiPortMappingById(avparsed);
                        if (mapping3 != null) {
                            mapping3.setOpen(false);
                            success = !mapping3.isOpened();
                        }
                    } else if (this.getActionType() == 13 && (mapping = MidiPortManager.findMidiPortMappingById(avparsed)) != null) {
                        boolean changeTo = new_value >= 64;
                        mapping.setOpen(changeTo);
                        success = mapping.isOpened() == changeTo;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            if (success) {
                this.lastTriggered = System.currentTimeMillis();
            } else {
                this.lastFailed = System.currentTimeMillis();
            }
            MidiTools.repaintRules();
        }
    }

    public static float mapFloat(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public static int mapInt(int x, int in_min, int in_max, int out_min, int out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public MidiToolsPlugin getSelectedPlugin() {
        if (this.getActionType() == 4) {
            String[] avparsed2 = this.action_value.split(",");
            return MidiTools.instance.plugins.get(avparsed2[0]);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        if (b != this.enabled) {
            if (b) {
                MidiTools.instance.midi_logger_b.println("Rule Enabled - " + this.toShortString());
            } else {
                MidiTools.instance.midi_logger_b.println("Rule Disabled - " + this.toShortString());
            }
            this.enabled = b;
            MidiTools.repaintRules();
        }
    }

    public String getRuleGroup() {
        return this.ruleGroup;
    }

    public void setRuleGroup(String group) {
        this.ruleGroup = group;
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    public void setMidiControl(MidiControl mc) {
        this.control = mc;
        this.updateRule();
    }

    public MidiControl getMidiControl() {
        return this.control;
    }

    public void setEventMode(int event_mode) {
        this.event_mode = event_mode;
    }

    public int getEventMode() {
        return this.event_mode;
    }

    public void setActionType(int action_type) {
        this.action_type = action_type;
    }

    public void setActionValue(String action_value) {
        this.action_value = action_value;
        this.actionValueChanged();
    }

    public int getActionType() {
        return this.action_type;
    }

    public void setCanvasName(String val2) {
        this.canvasName = val2;
    }

    public String getCanvasName() {
        return this.canvasName;
    }

    public String getActionValue() {
        return this.action_value;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getNickname() {
        return this.nickname;
    }

    public static String eventModeToString(int n) {
        if (n == 0) {
            return "onChanged";
        }
        if (n == 5) {
            return "onEnteredHigh (64+)";
        }
        if (n == 6) {
            return "onEnteredLow (63-)";
        }
        if (n == 1) {
            return "onChangedIncrease";
        }
        if (n == 2) {
            return "onChangedDecrease";
        }
        if (n == 7) {
            return "onEnteredHighOrLow";
        }
        if (n == 8) {
            return "onChangedBottomThird (0-42)";
        }
        if (n == 9) {
            return "onChangedMiddleThird (43-85)";
        }
        if (n == 10) {
            return "onChangedTopThird (86-127)";
        }
        if (n == 11) {
            return "onEnteredBottomThird (0-42)";
        }
        if (n == 12) {
            return "onEnteredMiddleThird (43-85)";
        }
        if (n == 13) {
            return "onEnteredTopThird (86-127)";
        }
        if (n == 3) {
            return "onChangedHigh (64+)";
        }
        if (n == 4) {
            return "onChangedLow (63-)";
        }
        return "";
    }

    public static String actionNumberToString(int n) {
        if (n == 0) {
            return "CALL URL";
        }
        if (n == 1) {
            return "RUN PROGRAM";
        }
        if (n == 2) {
            return "PLAY SOUND";
        }
        if (n == 3) {
            return "TRANSMIT CONTROL CHANGE";
        }
        if (n == 14) {
            return "TRANSMIT NOTE ON";
        }
        if (n == 15) {
            return "TRANSMIT NOTE OFF";
        }
        if (n == 7) {
            return "ENABLE RULE GROUP";
        }
        if (n == 8) {
            return "DISABLE RULE GROUP";
        }
        if (n == 9) {
            return "TOGGLE RULE GROUP";
        }
        if (n == 5) {
            return "LOGGER A MESSAGE";
        }
        if (n == 6) {
            return "LOGGER B MESSAGE";
        }
        if (n == 4) {
            return "PLUGIN";
        }
        if (n == 11) {
            return "MAPPING ENABLE";
        }
        if (n == 12) {
            return "MAPPING DISABLE";
        }
        if (n == 13) {
            return "MAPPING TOGGLE";
        }
        if (n == 10) {
            return "EFFECT IMAGE";
        }
        return "";
    }

    private void actionValueChanged() {
        if (this.getActionType() == 2 && this.action_value != null) {
            if (this.sound != null) {
                if (!this.sound.wasCreatedWith(this.action_value)) {
                    this.sound.close();
                    this.sound = new SoundFile(this.action_value);
                }
            } else {
                this.sound = new SoundFile(this.action_value);
            }
        } else {
            this.sound = null;
        }
    }

    public void updateRule() {
        this.actionValueChanged();
        MidiTools.removeListenerFromControls(this);
        if (this.control != null) {
            this.control.addMidiControlListener(this);
        }
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public JSONObject toJSONObject() {
        JSONObject jo = new JSONObject();
        jo.put("ruleId", this.ruleId);
        jo.put("ruleGroup", this.ruleGroup);
        if (this.control != null) {
            jo.put("control", this.control.toJSONObject());
        }
        jo.put("actionType", this.action_type);
        jo.put("eventMode", this.event_mode);
        jo.put("actionValue", this.action_value);
        jo.put("nickname", this.nickname);
        jo.put("canvas", this.canvasName);
        jo.put("enabled", this.enabled);
        jo.put("lastTriggered", this.lastTriggered);
        jo.put("valueInverted", this.valueInverted);
        jo.put("valueSettled", this.valueSettled);
        return jo;
    }

    public JSONObject toSavableJSONObject() {
        JSONObject jo = new JSONObject();
        jo.put("ruleId", this.ruleId);
        jo.put("ruleGroup", this.ruleGroup);
        if (this.control != null) {
            jo.put("control", this.control.toSavableJSONObject());
        }
        jo.put("actionType", this.action_type);
        jo.put("eventMode", this.event_mode);
        jo.put("actionValue", this.action_value);
        jo.put("nickname", this.nickname);
        jo.put("canvas", this.canvasName);
        jo.put("enabled", this.enabled);
        jo.put("valueInverted", this.valueInverted);
        jo.put("valueSettled", this.valueSettled);
        return jo;
    }

    public long getLastTriggered() {
        return this.lastTriggered;
    }

    public long getLastFailed() {
        return this.lastFailed;
    }

    private static String addWordBeforeSpace(String sentence, String word) {
        if (sentence.contains(" ")) {
            StringTokenizer st = new StringTokenizer(sentence, " ");
            StringBuffer sb = new StringBuffer();
            sb.append(st.nextToken());
            sb.append(word);
            while (st.hasMoreTokens()) {
                sb.append(" ");
                sb.append(st.nextToken());
            }
            return sb.toString();
        }
        return sentence + word;
    }

    public String toShortString() {
        Object controlText = "(No Control Selected)";
        if (this.control != null) {
            controlText = this.control.toString();
        }
        if (this.valueInverted) {
            controlText = "Inverted " + (String)controlText;
        }
        String eventModeText = MidiControlRule.eventModeToString(this.getEventMode());
        if (this.shouldValueSettle()) {
            eventModeText = MidiControlRule.addWordBeforeSpace(eventModeText, "AndSettled");
        }
        if (this.nickname == null) {
            return (String)controlText + " [" + eventModeText + "]";
        }
        return this.nickname + " - " + (String)controlText + " [" + eventModeText + "]";
    }

    public String toString() {
        Object returnText = "";
        Object controlText = "(No Control Selected)";
        if (this.control != null) {
            controlText = this.control.toString();
        }
        if (this.valueInverted) {
            controlText = "Inverted " + (String)controlText;
        }
        String actionText = MidiControlRule.actionNumberToString(this.getActionType());
        String eventModeText = MidiControlRule.eventModeToString(this.getEventMode());
        if (this.shouldValueSettle()) {
            eventModeText = MidiControlRule.addWordBeforeSpace(eventModeText, "AndSettled");
        }
        String targetText = this.getActionValue();
        if (this.getActionType() == 4) {
            String[] avparsed2 = this.action_value.split(",");
            returnText = avparsed2.length > 1 ? (String)controlText + " [" + eventModeText + "] >> " + avparsed2[0] + " - " + avparsed2[1] : (String)controlText + " [" + eventModeText + "] >> " + avparsed2[0];
        } else if (this.getActionType() == 12 || this.getActionType() == 11 || this.getActionType() == 13) {
            MidiPortMapping mapping = MidiPortManager.findMidiPortMappingById(targetText);
            if (mapping != null) {
                targetText = mapping.toString();
            }
            returnText = (String)controlText + " [" + eventModeText + "] >> " + actionText + " " + targetText;
        } else {
            returnText = (String)controlText + " [" + eventModeText + "] >> " + actionText + " " + targetText;
        }
        if (!("(ALL)".equals(this.getCanvasName()) || "(NONE)".equals(this.getCanvasName()) || "".equals(this.getCanvasName()) || this.getCanvasName() == null)) {
            returnText = (String)returnText + " @" + this.getCanvasName();
        }
        if (this.getRuleGroup() != null) {
            if (!this.getRuleGroup().equals("all")) {
                return "#" + this.getRuleGroup() + " " + (String)returnText;
            }
            return returnText;
        }
        return returnText;
    }
}

