/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.json.JSONObject;
import org.openstatic.MidiTools;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.ports.LoggerMidiPort;

public class MidiPlayerPanel
extends JPanel
implements ActionListener,
MidiPort,
Runnable {
    private Sequencer sequencer;
    private Sequence sequence;
    private File midiFile;
    private File lastDirectory;
    private boolean opened;
    private JButton playButton;
    private JButton stopButton;
    private JToggleButton repeatButton;
    private JButton pauseButton;
    private JButton previousButton;
    private JPanel buttonPanel;
    private Vector<Receiver> receivers;
    private JComboBox<String> selectFileField;
    private long lastRxAt;
    private Thread clockThread;
    private JPanel selectTrackPanel;
    private JButton selectFileButton;
    private JTextPane viewArea;
    private long lastDisplayUpdate;
    private ImageIcon myIcon;
    private boolean userPaused;
    private JPanel playerPanel;
    private LoggerMidiPort midilogger;
    private long txCount = 0L;
    private long rxCount = 0L;
    private Receiver seqReceiver = new Receiver(){

        @Override
        public void send(MidiMessage message, long timeStamp) {
            if (MidiPlayerPanel.this.opened) {
                MidiPlayerPanel.this.lastRxAt = System.currentTimeMillis();
                ++MidiPlayerPanel.this.rxCount;
                MidiPlayerPanel.this.receivers.forEach(r -> r.send(message, timeStamp));
            }
        }

        @Override
        public void close() {
        }
    };

    public MidiPlayerPanel() {
        super(new BorderLayout());
        this.lastDirectory = new File(".");
        this.setPreferredSize(new Dimension(0, 200));
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.userPaused = true;
        this.receivers = new Vector();
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.setMasterSyncMode(Sequencer.SyncMode.MIDI_SYNC);
            this.sequencer.setSlaveSyncMode(Sequencer.SyncMode.MIDI_SYNC);
            this.sequencer.getTransmitter().setReceiver(this.seqReceiver);
            this.sequencer.open();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.selectFileField = new JComboBox();
        this.selectFileField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MidiPlayerPanel.this.refreshAssetChoices();
            }

            @Override
            public void focusLost(FocusEvent e) {
                MidiPlayerPanel.this.loadSelectedFile();
            }
        });
        this.myIcon = this.getIcon("/midi-tools-res/midifile32.png");
        this.viewArea = new JTextPane();
        this.viewArea.setContentType("text/html");
        this.viewArea.setEditable(false);
        this.viewArea.setBackground(new Color(34, 34, 34));
        this.viewArea.setForeground(Color.WHITE);
        this.viewArea.setText("");
        this.selectFileField.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 5));
        this.previousButton = new JButton(MidiTools.getCachedIcon("/midi-tools-res/prev.png", "16x16"));
        this.previousButton.setActionCommand("previous");
        this.previousButton.addActionListener(this);
        this.buttonPanel.add(this.previousButton);
        this.playButton = new JButton(MidiTools.getCachedIcon("/midi-tools-res/play.png", "16x16"));
        this.playButton.setActionCommand("play");
        this.playButton.addActionListener(this);
        this.buttonPanel.add(this.playButton);
        this.pauseButton = new JButton(MidiTools.getCachedIcon("/midi-tools-res/pause.png", "16x16"));
        this.pauseButton.setActionCommand("pause");
        this.pauseButton.addActionListener(this);
        this.buttonPanel.add(this.pauseButton);
        this.stopButton = new JButton(MidiTools.getCachedIcon("/midi-tools-res/stop.png", "16x16"));
        this.stopButton.setActionCommand("stop");
        this.stopButton.addActionListener(this);
        this.buttonPanel.add(this.stopButton);
        this.repeatButton = new JToggleButton(MidiTools.getCachedIcon("/midi-tools-res/repeat.png", "16x16"));
        this.repeatButton.setActionCommand("repeat");
        this.repeatButton.addActionListener(this);
        this.buttonPanel.add(this.repeatButton);
        this.selectTrackPanel = new JPanel(new BorderLayout());
        this.selectTrackPanel.add((Component)new JLabel(" Select File "), "West");
        this.selectTrackPanel.add(this.selectFileField, "Center");
        this.selectFileButton = new JButton("...");
        this.selectFileButton.setToolTipText("Select a file from your computer");
        this.selectFileButton.addActionListener(this);
        this.selectTrackPanel.add((Component)this.selectFileButton, "East");
        this.playerPanel = new JPanel(new BorderLayout());
        this.playerPanel.add((Component)this.selectTrackPanel, "First");
        this.playerPanel.add((Component)this.viewArea, "Center");
        this.playerPanel.add((Component)this.buttonPanel, "Last");
        this.playerPanel.setPreferredSize(new Dimension(255, 0));
        this.add((Component)this.playerPanel, "West");
        this.midilogger = new LoggerMidiPort("Logger B");
        this.add((Component)this.midilogger, "Center");
        this.clockThread = new Thread(this);
        this.clockThread.start();
    }

    public LoggerMidiPort getLoggerMidiPort() {
        return this.midilogger;
    }

    public void refreshAssetChoices() {
        String filename = null;
        if (this.midiFile != null) {
            filename = this.midiFile.getName();
        }
        this.refreshAssetChoices(filename);
    }

    public void refreshAssetChoices(String filename) {
        ArrayList<String> extens = new ArrayList<String>();
        extens.add(".mid");
        extens.add(".midi");
        this.selectFileField.setModel(MidiTools.getAssetComboBoxModel(extens));
        if (filename != null) {
            this.selectFileField.setSelectedItem(filename);
        } else if (this.selectFileField.getItemCount() > 0) {
            this.selectFileField.setSelectedIndex(0);
        }
    }

    public void loadFile(File file) {
        try {
            this.midilogger.println("(Internal Player) LOADED " + file.getName());
            this.midiFile = file;
            this.sequence = MidiSystem.getSequence(this.midiFile);
            this.sequencer.setSequence(this.sequence);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.midiFile = null;
        }
    }

    public ImageIcon getIcon() {
        return this.myIcon;
    }

    private ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream(name)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void play() {
        this.userPaused = false;
        if (this.sequence != null && !this.sequencer.isRunning()) {
            if (this.sequence.getMicrosecondLength() == this.sequencer.getMicrosecondPosition()) {
                this.sequencer.setMicrosecondPosition(0L);
            }
            this.sequencer.start();
            this.midilogger.println("(Internal Player) PLAYING " + this.midiFile.getName());
        }
    }

    public void stop() {
        this.userPaused = true;
        if (this.sequencer.isRunning()) {
            this.sequencer.stop();
            this.sequencer.setMicrosecondPosition(0L);
            this.midilogger.println("(Internal Player) STOPPED " + this.midiFile.getName());
        }
    }

    public void pause() {
        this.userPaused = true;
        if (this.sequencer.isRunning()) {
            this.sequencer.stop();
            this.midilogger.println("(Internal Player) PAUSED " + this.midiFile.getName());
        }
    }

    public void restartTrack() {
        this.sequencer.setTickPosition(0L);
        this.loadSelectedFile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("play".equals(actionCommand)) {
            this.play();
        }
        if ("pause".equals(actionCommand)) {
            this.pause();
        }
        if ("previous".equals(actionCommand)) {
            this.restartTrack();
        }
        if ("stop".equals(actionCommand)) {
            this.stop();
        }
        if ("next".equals(actionCommand)) {
            this.sequencer.setTickPosition(this.sequencer.getTickLength());
        }
        if (e.getSource() == this.selectFileButton) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(this.lastDirectory);
            fileChooser.setDialogTitle("Select a Midi file");
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Midi File", "mid", "midi");
            fileChooser.setFileFilter(filter);
            int userSelection = fileChooser.showOpenDialog(this);
            if (userSelection == 0) {
                final File fileToLoad = fileChooser.getSelectedFile();
                this.lastDirectory = fileChooser.getCurrentDirectory();
                if (fileToLoad != null) {
                    Thread x = new Thread(){

                        @Override
                        public void run() {
                            try {
                                File assetFile = MidiTools.addProjectAsset(fileToLoad);
                                String filename = assetFile.getName();
                                Thread.sleep(2000L);
                                MidiPlayerPanel.this.refreshAssetChoices(filename);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    x.start();
                }
            }
        }
        if (e.getSource() == this.selectFileField) {
            this.loadSelectedFile();
        }
    }

    public void setSelectedFilename(String filename) {
        this.selectFileField.setSelectedItem(filename);
        if (this.midiFile == null) {
            this.loadSelectedFile();
        }
    }

    public String getSelectedFilename() {
        return this.selectFileField.getSelectedItem().toString();
    }

    public void loadSelectedFile() {
        if (this.selectFileField.getSelectedItem() != null) {
            String selectedFilename = this.selectFileField.getSelectedItem().toString();
            if (!this.sequencer.isRunning()) {
                if (this.midiFile == null) {
                    this.loadFile(new File(MidiTools.getAssetFolder(), selectedFilename));
                } else if (!this.midiFile.getName().equals(selectedFilename)) {
                    this.loadFile(new File(MidiTools.getAssetFolder(), selectedFilename));
                }
            } else if (this.sequencer.getMicrosecondPosition() == 0L) {
                this.loadFile(new File(MidiTools.getAssetFolder(), selectedFilename));
            }
        }
    }

    @Override
    public void open() {
        this.opened = true;
        MidiPortManager.firePortOpened(this);
    }

    @Override
    public void close() {
        this.opened = false;
        MidiPortManager.firePortClosed(this);
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public long getMicrosecondPosition() {
        return this.sequencer.getMicrosecondPosition();
    }

    @Override
    public boolean equals(MidiPort port) {
        return port.getName().equals(this.getName());
    }

    @Override
    public String getName() {
        return "Internal Player";
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean canTransmitMessages() {
        return true;
    }

    @Override
    public void addReceiver(Receiver r) {
        if (!this.receivers.contains(r)) {
            this.receivers.add(r);
        }
    }

    @Override
    public void removeReceiver(Receiver r) {
        if (this.receivers.contains(r)) {
            this.receivers.remove(r);
        }
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public boolean hasReceiver(Receiver r) {
        return this.receivers.contains(r);
    }

    @Override
    public boolean canReceiveMessages() {
        return false;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        ++this.txCount;
    }

    @Override
    public long getLastRxAt() {
        return this.lastRxAt;
    }

    @Override
    public long getLastTxAt() {
        return 0L;
    }

    @Override
    public void run() {
        while (MidiPortManager.isRunning()) {
            try {
                long cts = System.currentTimeMillis();
                boolean playing = false;
                if (this.sequencer.isRunning()) {
                    playing = true;
                    if (!this.playButton.isOpaque()) {
                        this.playButton.setBackground(Color.GREEN);
                        this.playButton.setOpaque(true);
                    }
                    ShortMessage sm = new ShortMessage(248);
                    this.seqReceiver.send(sm, this.sequencer.getMicrosecondPosition());
                    float mpq = this.sequencer.getTempoInMPQ();
                    long sleep = (long)(mpq / 24.0f * 1000.0f);
                    long start = System.nanoTime();
                    while (start + sleep >= System.nanoTime()) {
                        Thread.sleep(1L);
                    }
                } else {
                    if (this.playButton.isOpaque()) {
                        this.playButton.setBackground(Color.LIGHT_GRAY);
                        this.playButton.setOpaque(false);
                    }
                    Thread.sleep(1000L);
                    if (this.repeatButton.isSelected() && this.sequence != null && !this.userPaused && this.sequence.getMicrosecondLength() == this.sequencer.getMicrosecondPosition()) {
                        System.err.println("Honoring repeat mode");
                        this.sequencer.setMicrosecondPosition(0L);
                        this.sequencer.start();
                    }
                }
                if (cts - this.lastDisplayUpdate <= 1000L) continue;
                this.lastDisplayUpdate = cts;
                String state = "Stopped";
                String midiFileName = "No MIDI file loaded";
                if (this.midiFile != null) {
                    midiFileName = this.midiFile.getName();
                }
                if (!playing && this.sequencer.getMicrosecondPosition() > 0L) {
                    state = "Paused";
                } else if (playing) {
                    state = "Playing";
                }
                long durationSecond = 0L;
                if (this.sequence != null) {
                    durationSecond = this.sequence.getMicrosecondLength() / 1000000L;
                }
                long trackProgressSeconds = this.getMicrosecondPosition() / 1000000L;
                String trackProgress = MidiPlayerPanel.getDurationBreakdown(trackProgressSeconds) + " / " + MidiPlayerPanel.getDurationBreakdown(durationSecond);
                this.viewArea.setText("<html><body style=\"color: white; font-size: 18px; text-align: center; vertical-align: middle;\"><B>" + midiFileName + "</B><br />" + state + " [" + trackProgress + "]</body></html>");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static String getDurationBreakdown(long seconds) {
        DecimalFormat formatter = new DecimalFormat("#00");
        long days = TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds -= TimeUnit.DAYS.toSeconds(days));
        long minutes = TimeUnit.SECONDS.toMinutes(seconds -= TimeUnit.HOURS.toSeconds(hours));
        seconds -= TimeUnit.MINUTES.toSeconds(minutes);
        StringBuilder sb = new StringBuilder(64);
        sb.append(formatter.format(minutes));
        sb.append(":");
        sb.append(formatter.format(seconds));
        return sb.toString();
    }

    public void loadProject(JSONObject project) {
        if (project != null) {
            this.repeatButton.setSelected(project.optBoolean("repeat"));
            this.selectFileField.setSelectedItem(project.optString("loadedFile"));
            this.loadSelectedFile();
        }
    }

    public JSONObject getProjectJSON() {
        JSONObject project = new JSONObject();
        project.put("repeat", this.repeatButton.isSelected());
        project.put("loadedFile", (String)this.selectFileField.getSelectedItem());
        return project;
    }

    @Override
    public String getCCName(int channel, int cc) {
        return null;
    }

    @Override
    public long getRxCount() {
        return this.rxCount;
    }

    @Override
    public long getTxCount() {
        return this.txCount;
    }
}

