/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.APIWebServer;
import org.openstatic.AssetManagerPanel;
import org.openstatic.CreateControlDialog;
import org.openstatic.MappingControlBox;
import org.openstatic.MidiControlRule;
import org.openstatic.MidiControlRulePanel;
import org.openstatic.MidiControlsPanel;
import org.openstatic.MidiPlayerPanel;
import org.openstatic.PluginManagerWindow;
import org.openstatic.RTPControlBox;
import org.openstatic.RandomizerControlBox;
import org.openstatic.RoutePutSessionManager;
import org.openstatic.midi.MidiControl;
import org.openstatic.midi.MidiControlListener;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortCellRenderer;
import org.openstatic.midi.MidiPortListModel;
import org.openstatic.midi.MidiPortListener;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.MidiPortMapping;
import org.openstatic.midi.MidiToolsPlugin;
import org.openstatic.midi.ports.LoggerMidiPort;
import org.openstatic.midi.ports.MIDIChannelMidiPort;
import org.openstatic.midi.ports.MidiRandomizerPort;
import org.openstatic.midi.ports.RTPMidiPort;
import org.openstatic.midi.providers.CollectionMidiPortProvider;
import org.openstatic.midi.providers.DeviceMidiPortProvider;
import org.openstatic.midi.providers.JackMidiPortProvider;
import org.openstatic.midi.providers.JoystickMidiPortProvider;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.client.RoutePutClient;
import org.openstatic.util.CopyOrGo;
import org.openstatic.util.JSONObjectDialog;

public class MidiTools
extends JFrame
implements Runnable,
ActionListener,
MidiPortListener {
    public static LinkedHashMap<String, BufferedImage> cachedImages = new LinkedHashMap();
    public static final String VERSION = "1.7";
    public static String LOCAL_SERIAL;
    public static long appLaunchTime;
    public static boolean windowWentVisible;
    public static boolean forceMaximize;
    private JList<MidiPort> midiList;
    private JPanel deviceQRPanel;
    private JLabel qrLabel;
    private MidiPortCellRenderer midiRenderer;
    private MidiPortListModel midiListModel;
    public LoggerMidiPort midi_logger_a;
    public LoggerMidiPort midi_logger_b;
    protected MidiControlsPanel midiControlsPanel;
    private Thread mainThread;
    protected ArrayBlockingQueue<Runnable> taskQueue;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu actionsMenu;
    private JMenu optionsMenu;
    private JMenu qrCodeMenu;
    private JTabbedPane mainTabbedPane;
    private JCheckBoxMenuItem apiServerEnable;
    private JCheckBoxMenuItem bootstrapSSLItem;
    private JRadioButtonMenuItem localQrMenuItem;
    private JRadioButtonMenuItem remoteQrMenuItem;
    private JRadioButtonMenuItem canvasQrMenuItem;
    private JRadioButtonMenuItem noneQrMenuItem;
    private JMenuItem openInBrowserItem;
    private JMenuItem openCanvasBrowserItem;
    private JMenuItem aboutMenuItem;
    private JMenuItem exportConfigurationMenuItem;
    private JMenuItem importConfigurationMenuItem;
    private JMenuItem loadPluginMenuItem;
    private JMenuItem managePluginMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem resetConfigurationMenuItem;
    private File lastSavedFile;
    private JMenuItem exitMenuItem;
    public static MidiTools instance;
    private boolean keep_running;
    public APIWebServer apiServer;
    private MidiRandomizerPort randomizerPort;
    private ArrayList<RTPMidiPort> rtpMidiPorts;
    private Point windowLocation;
    private RoutePutClient routeputClient;
    private RoutePutSessionManager routeputSessionManager;
    public CollectionMidiPortProvider cmpp;
    public JackMidiPortProvider jmpp;
    private JMenuItem routeputConnectMenuItem;
    private MappingControlBox mappingControlBox;
    protected MidiControlRulePanel midiControlRulePanel;
    private RandomizerControlBox randomizerControlBox;
    private AssetManagerPanel assetManagerPanel;
    public JSONObject loadedProjectJSON;
    public MidiPlayerPanel midiPlayer;
    public HashMap<String, MidiToolsPlugin> plugins;
    public JSONObject pluginSettings;
    private ImageIcon diceIcon;
    public boolean isWindows;
    private long lastSecondAt = 0L;

    public MidiTools(String os_name) {
        super("MIDI Control Change Tool v1.7");
        this.isWindows = os_name.contains("windows");
        if (this.isWindows) {
            System.err.println("Windows Detected");
        }
        appLaunchTime = System.currentTimeMillis();
        instance = this;
        this.plugins = new HashMap();
        this.taskQueue = new ArrayBlockingQueue(1000);
        this.keep_running = true;
        this.loadedProjectJSON = new JSONObject();
        this.apiServer = new APIWebServer();
        MidiPortManager.addProvider(this.apiServer);
        this.midi_logger_a = new LoggerMidiPort("Logger A");
        this.midiPlayer = new MidiPlayerPanel();
        this.midi_logger_b = this.midiPlayer.getLoggerMidiPort();
        this.randomizerPort = new MidiRandomizerPort("Randomizer");
        this.setLayout(new BorderLayout());
        try {
            BufferedImage windowIcon = ImageIO.read(this.getClass().getResource("/midi-tools-res/windows.png"));
            this.setIconImage(windowIcon);
        }
        catch (Exception windowIcon) {
            // empty catch block
        }
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent e2 = new ActionEvent(MidiTools.this.saveMenuItem, 1001, "save");
                MidiTools.this.actionPerformed(e2);
            }
        }, KeyStroke.getKeyStroke(83, 128), 2);
        this.qrCodeMenu = new JMenu("QR Code");
        this.qrCodeMenu.setMnemonic(81);
        this.noneQrMenuItem = new JRadioButtonMenuItem("None");
        this.noneQrMenuItem.addActionListener(this);
        this.noneQrMenuItem.setSelected(true);
        this.localQrMenuItem = new JRadioButtonMenuItem("Local Web Interface");
        this.localQrMenuItem.addActionListener(this);
        this.localQrMenuItem.setEnabled(false);
        this.remoteQrMenuItem = new JRadioButtonMenuItem("Openstatic.org Web Interface");
        this.remoteQrMenuItem.addActionListener(this);
        this.remoteQrMenuItem.setEnabled(false);
        this.canvasQrMenuItem = new JRadioButtonMenuItem("Media Canvas for Images/Sound");
        this.canvasQrMenuItem.addActionListener(this);
        this.canvasQrMenuItem.setEnabled(false);
        this.qrCodeMenu.add(this.noneQrMenuItem);
        this.qrCodeMenu.add(this.localQrMenuItem);
        this.qrCodeMenu.add(this.remoteQrMenuItem);
        this.qrCodeMenu.add(this.canvasQrMenuItem);
        ButtonGroup qrButtonGroup = new ButtonGroup();
        qrButtonGroup.add(this.noneQrMenuItem);
        qrButtonGroup.add(this.localQrMenuItem);
        qrButtonGroup.add(this.remoteQrMenuItem);
        qrButtonGroup.add(this.canvasQrMenuItem);
        this.bootstrapSSLItem = new JCheckBoxMenuItem("Enable Openstatic.org Interface");
        this.bootstrapSSLItem.setEnabled(true);
        this.bootstrapSSLItem.setMnemonic(79);
        this.bootstrapSSLItem.addActionListener(this);
        this.bootstrapSSLItem.setActionCommand("bootstrap_ssl");
        this.openInBrowserItem = new JMenuItem("Open API in Default Browser");
        this.openInBrowserItem.setEnabled(false);
        this.openInBrowserItem.setMnemonic(66);
        this.openInBrowserItem.addActionListener(this);
        this.openInBrowserItem.setActionCommand("open_api");
        this.openCanvasBrowserItem = new JMenuItem("Open Media Canvas in Default Browser");
        this.openCanvasBrowserItem.setEnabled(false);
        this.openCanvasBrowserItem.setMnemonic(67);
        this.openCanvasBrowserItem.addActionListener(this);
        this.openCanvasBrowserItem.setActionCommand("open_canvas");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.resetConfigurationMenuItem = new JMenuItem("New Project");
        this.resetConfigurationMenuItem.setMnemonic(78);
        this.resetConfigurationMenuItem.addActionListener(this);
        this.resetConfigurationMenuItem.setActionCommand("reset");
        this.exportConfigurationMenuItem = new JMenuItem("Save Project As");
        this.exportConfigurationMenuItem.setMnemonic(65);
        this.exportConfigurationMenuItem.addActionListener(this);
        this.exportConfigurationMenuItem.setActionCommand("export");
        this.saveMenuItem = new JMenuItem("Save Project");
        this.saveMenuItem.setMnemonic(83);
        this.saveMenuItem.addActionListener(this);
        this.saveMenuItem.setActionCommand("save");
        this.importConfigurationMenuItem = new JMenuItem("Open Project");
        this.importConfigurationMenuItem.setMnemonic(79);
        this.importConfigurationMenuItem.addActionListener(this);
        this.importConfigurationMenuItem.setActionCommand("import");
        this.loadPluginMenuItem = new JMenuItem("Install Plugin from File");
        this.loadPluginMenuItem.setMnemonic(80);
        this.loadPluginMenuItem.addActionListener(this);
        this.loadPluginMenuItem.setActionCommand("load_plugin");
        this.managePluginMenuItem = new JMenuItem("Manage Plugins");
        this.managePluginMenuItem.setMnemonic(77);
        this.managePluginMenuItem.addActionListener(this);
        this.managePluginMenuItem.setActionCommand("manage_plugins");
        this.aboutMenuItem = new JMenuItem("About");
        this.aboutMenuItem.setMnemonic(66);
        this.aboutMenuItem.addActionListener(this);
        this.aboutMenuItem.setActionCommand("about");
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.setMnemonic(88);
        this.exitMenuItem.addActionListener(this);
        this.exitMenuItem.setActionCommand("exit");
        this.fileMenu.add(this.resetConfigurationMenuItem);
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.exportConfigurationMenuItem);
        this.fileMenu.add(this.importConfigurationMenuItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.managePluginMenuItem);
        this.fileMenu.add(this.loadPluginMenuItem);
        this.fileMenu.add(this.aboutMenuItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.exitMenuItem);
        this.actionsMenu = new JMenu("Actions");
        this.actionsMenu.setMnemonic(65);
        this.routeputConnectMenuItem = new JMenuItem("Connect to MIDIChannel.net Room");
        this.routeputConnectMenuItem.setActionCommand("midichannel_net_connect");
        this.routeputConnectMenuItem.addActionListener(this);
        this.actionsMenu.add(this.routeputConnectMenuItem);
        this.actionsMenu.add(this.openInBrowserItem);
        this.actionsMenu.add(this.openCanvasBrowserItem);
        this.apiServerEnable = new JCheckBoxMenuItem("Enable API Server");
        this.apiServerEnable.addActionListener(this);
        this.apiServerEnable.setMnemonic(69);
        this.optionsMenu = new JMenu("Options");
        this.optionsMenu.setMnemonic(79);
        this.optionsMenu.add(this.apiServerEnable);
        this.optionsMenu.add(this.bootstrapSSLItem);
        this.optionsMenu.add(this.qrCodeMenu);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.actionsMenu);
        this.menuBar.add(this.optionsMenu);
        this.setJMenuBar(this.menuBar);
        this.mainTabbedPane = new JTabbedPane();
        this.midiControlsPanel = new MidiControlsPanel();
        BufferedImage dialIconImage = null;
        try {
            dialIconImage = ImageIO.read(this.getClass().getResource("/midi-tools-res/dial32.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageIcon dialIcon = new ImageIcon(dialIconImage);
        this.mainTabbedPane.addTab("Midi Controls", dialIcon, this.midiControlsPanel);
        JPanel toysAndPower = new JPanel(new BorderLayout());
        toysAndPower.add((Component)this.mainTabbedPane, "Center");
        this.add((Component)toysAndPower, "Center");
        this.midiListModel = new MidiPortListModel();
        this.midiRenderer = new MidiPortCellRenderer();
        this.midiList = new JList<MidiPort>(this.midiListModel);
        this.midiList.setSelectionMode(0);
        this.midiList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MidiPort source;
                int index;
                Point point = e.getPoint();
                if (point.getX() < 34.0 && (index = MidiTools.this.midiList.locationToIndex(e.getPoint())) != -1 && (source = MidiTools.this.midiListModel.getElementAt(index)) == MidiTools.this.midiList.getSelectedValue() && e.getButton() == 1) {
                    if (source.isOpened()) {
                        source.close();
                        source.removeReceiver(MidiTools.this.midiControlsPanel);
                    } else {
                        source.open();
                        source.addReceiver(MidiTools.this.midiControlsPanel);
                    }
                }
            }
        });
        this.midiList.setCellRenderer(this.midiRenderer);
        JScrollPane scrollPane2 = new JScrollPane(this.midiList, 22, 31);
        scrollPane2.setPreferredSize(new Dimension(255, 0));
        scrollPane2.setBorder(new TitledBorder("MIDI Devices"));
        this.deviceQRPanel = new JPanel(new BorderLayout());
        this.deviceQRPanel.add((Component)scrollPane2, "Center");
        this.add((Component)this.deviceQRPanel, "West");
        BufferedImage scriptIconImage = null;
        try {
            scriptIconImage = ImageIO.read(this.getClass().getResource("/midi-tools-res/script32.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageIcon scriptIcon = new ImageIcon(scriptIconImage);
        this.midiControlRulePanel = new MidiControlRulePanel();
        this.mainTabbedPane.addTab("Control Change Rules", scriptIcon, this.midiControlRulePanel);
        this.mappingControlBox = new MappingControlBox();
        BufferedImage cableIconImage = null;
        try {
            cableIconImage = ImageIO.read(this.getClass().getResource("/midi-tools-res/cable32.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageIcon cableIcon = new ImageIcon(cableIconImage);
        this.mainTabbedPane.addTab("Port Mappings", cableIcon, this.mappingControlBox);
        BufferedImage logIconImage = null;
        try {
            logIconImage = ImageIO.read(this.getClass().getResource("/midi-tools-res/log32.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageIcon logIcon = new ImageIcon(logIconImage);
        this.mainTabbedPane.addTab("Logger A", logIcon, this.midi_logger_a);
        BufferedImage diceIconImage = null;
        try {
            diceIconImage = ImageIO.read(this.getClass().getResource("/midi-tools-res/dice32.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.diceIcon = new ImageIcon(diceIconImage);
        this.randomizerControlBox = new RandomizerControlBox(this.randomizerPort);
        BufferedImage folderIconImage = null;
        try {
            folderIconImage = ImageIO.read(this.getClass().getResource("/midi-tools-res/folder32.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageIcon folderIcon = new ImageIcon(folderIconImage);
        this.assetManagerPanel = new AssetManagerPanel(MidiTools.getAssetFolder());
        this.mainTabbedPane.addTab("Project Assets", folderIcon, this.assetManagerPanel);
        this.add((Component)this.midiPlayer, "Last");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MidiTools.this.keep_running = false;
                MidiTools.this.saveConfig();
                MidiTools.eraseAssets();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                System.err.println("Window Opened!");
                windowWentVisible = true;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MidiTools.this.tryToExit();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.cmpp = new CollectionMidiPortProvider();
        MidiPortManager.addProvider(this.cmpp);
        String openstaticUri = "wss://openstatic.org/channel/";
        System.err.println("OpenStatic URI: " + openstaticUri);
        RoutePutChannel myChannel = RoutePutChannel.getChannel("midi-tools-" + LOCAL_SERIAL);
        this.routeputClient = new RoutePutClient(myChannel, openstaticUri);
        this.routeputClient.setAutoReconnect(true);
        this.routeputClient.setCollector(true);
        this.routeputClient.setProperty("description", "MIDI Control Change Tool v1.7");
        this.routeputClient.setProperty("host", MidiTools.getLocalHostname());
        this.routeputSessionManager = new RoutePutSessionManager(myChannel, this.routeputClient);
        this.rtpMidiPorts = new ArrayList();
        MidiPortManager.addMidiPortListener(this);
        MidiPortManager.addProvider(new DeviceMidiPortProvider());
        MidiPortManager.addProvider(new JoystickMidiPortProvider());
        this.cmpp.add(this.midi_logger_a);
        this.cmpp.add(this.midi_logger_b);
        this.cmpp.add(this.midiPlayer);
        this.cmpp.add(this.randomizerPort);
        String localHostname = MidiTools.getLocalHostname();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                Enumeration<InetAddress> addresses = netint.getInetAddresses();
                Collections.list(addresses).forEach(address -> {
                    if (address.isSiteLocalAddress()) {
                        try {
                            RTPMidiPort rtpPort = new RTPMidiPort("RTP " + address.getHostAddress(), localHostname + " MidiTools", (InetAddress)address, 5004);
                            this.rtpMidiPorts.add(rtpPort);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            this.cmpp.addAll(this.rtpMidiPorts);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        MidiPortManager.addProvider(this.routeputSessionManager);
        try {
            this.jmpp = new JackMidiPortProvider();
            MidiPortManager.addProvider(this.jmpp);
            System.err.println("Initialized Jack Suppport");
        }
        catch (Exception jmppex) {
            jmppex.printStackTrace(System.err);
        }
        MidiPortManager.refresh();
        MidiTools.logIt("Finished MidiTools Constructor");
        File plugin_root = MidiTools.getPluginFolder();
        if (plugin_root.exists()) {
            try {
                File[] plug_files = plugin_root.listFiles();
                for (int i = 0; i < plug_files.length; ++i) {
                    if (!plug_files[i].getName().endsWith(".jar")) continue;
                    try {
                        this.loadPlugin(plug_files[i]);
                        continue;
                    }
                    catch (Exception pl_ex) {
                        pl_ex.printStackTrace(System.err);
                    }
                }
            }
            catch (Exception ex2) {
                ex2.printStackTrace(System.err);
            }
        } else {
            plugin_root.mkdirs();
        }
        this.centerWindow();
    }

    public static String shellExec(String[] cmd) {
        try {
            Process cmdProc = Runtime.getRuntime().exec(cmd);
            cmdProc.waitFor();
            return MidiTools.readStreamToString(cmdProc.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String readStreamToString(InputStream is) {
        String result = "";
        try {
            Scanner s = new Scanner(is).useDelimiter("\\A");
            result = s.hasNext() ? s.next() : "";
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getLocalHostname() {
        String returnValue = "";
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            returnValue = env.get("COMPUTERNAME");
        } else if (env.containsKey("HOSTNAME")) {
            returnValue = env.get("HOSTNAME");
        } else {
            String hostname;
            String hostnameCommand = MidiTools.shellExec(new String[]{"hostname"});
            if (hostnameCommand != null && !"".equals(hostname = hostnameCommand.trim())) {
                returnValue = hostname;
            }
        }
        if ("".equals(returnValue)) {
            try {
                Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
                while (n.hasMoreElements() && "".equals(returnValue)) {
                    NetworkInterface ni = n.nextElement();
                    Enumeration<InetAddress> e = ni.getInetAddresses();
                    while (e.hasMoreElements() && "".equals(returnValue)) {
                        String hostname;
                        InetAddress ia = e.nextElement();
                        if (ia.isLoopbackAddress() || !ia.isSiteLocalAddress()) continue;
                        returnValue = hostname = ia.getHostName();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ("".equals(returnValue)) {
            returnValue = MidiPortManager.generateBigAlphaKey(5);
        }
        if (returnValue.contains(".local")) {
            returnValue = returnValue.replace(".local", "");
        }
        if (returnValue.contains(".lan")) {
            returnValue = returnValue.replace(".lan", "");
        }
        return returnValue;
    }

    public void tryToExit() {
        if (this.hasUnsavedProjectChanges() && this.lastSavedFile != null) {
            if (!this.lastSavedFile.getName().contains("Untitled.mtz")) {
                int answer = this.showUnsavedMessage();
                switch (answer) {
                    case 0: {
                        this.saveProjectAs(this.lastSavedFile);
                        System.exit(0);
                        break;
                    }
                    case 1: {
                        System.exit(0);
                        break;
                    }
                }
            } else {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    private int showUnsavedMessage() {
        Object[] buttonLabels = new String[]{"Yes", "No", "Cancel"};
        String defaultOption = buttonLabels[0];
        return JOptionPane.showOptionDialog(this, "You have made changes to this project, do you want to save them before closing?", "Warning", 1, 2, null, buttonLabels, defaultOption);
    }

    public boolean isAlive() {
        return this.keep_running && this.mainThread.isAlive();
    }

    protected void start() {
        this.mainThread = new Thread(this);
        this.mainThread.setDaemon(true);
        this.mainThread.start();
        this.randomizerPort.addReceiver(this.midiControlsPanel);
    }

    @Override
    public void portAdded(int idx, MidiPort port) {
        this.midi_logger_b.println("MIDI Port Added " + port.toString());
        MidiTools.repaintDevices();
    }

    @Override
    public void portRemoved(int idx, MidiPort port) {
        this.midi_logger_b.println("MIDI Port Removed " + port.toString());
        MidiTools.repaintDevices();
    }

    @Override
    public void portOpened(MidiPort port) {
        this.midi_logger_b.println("MIDI Port Opened " + port.toString());
        port.addReceiver(this.midiControlsPanel);
        if (port instanceof RTPMidiPort) {
            RTPMidiPort rtpPort = (RTPMidiPort)port;
            RTPControlBox controlBox = new RTPControlBox(rtpPort);
            this.mainTabbedPane.addTab(rtpPort.getName(), controlBox.getIcon(), controlBox);
        }
        if (port instanceof MidiRandomizerPort) {
            this.mainTabbedPane.addTab("Randomizer", this.diceIcon, this.randomizerControlBox);
        }
        MidiTools.repaintDevices();
    }

    @Override
    public void portClosed(MidiPort port) {
        this.midi_logger_b.println("MIDI Port Closed " + port.toString());
        port.removeReceiver(this.midiControlsPanel);
        if (port instanceof RTPMidiPort) {
            RTPMidiPort rtpPort = (RTPMidiPort)port;
            String portName = rtpPort.getName();
            int tabIndex = this.mainTabbedPane.indexOfTab(portName);
            this.mainTabbedPane.remove(tabIndex);
        }
        if (port instanceof MidiRandomizerPort) {
            int tabIndex = this.mainTabbedPane.indexOfTab("Randomizer");
            this.mainTabbedPane.remove(tabIndex);
        }
        MidiTools.repaintDevices();
    }

    @Override
    public void mappingAdded(int idx, MidiPortMapping mapping) {
        this.midi_logger_b.println("MIDI Port Mapping Added " + mapping.toString());
        MidiTools.repaintMappings();
    }

    @Override
    public void mappingRemoved(int idx, MidiPortMapping mapping) {
        this.midi_logger_b.println("MIDI Port Mapping Removed " + mapping.toString());
        MidiTools.repaintMappings();
    }

    @Override
    public void mappingOpened(MidiPortMapping mapping) {
        this.midi_logger_b.println("MIDI Port Mapping Opened " + mapping.toString());
        MidiTools.repaintMappings();
    }

    @Override
    public void mappingClosed(MidiPortMapping mapping) {
        this.midi_logger_b.println("MIDI Port Mapping Closed " + mapping.toString());
        MidiTools.repaintMappings();
    }

    public void changeAPIState(boolean apiEnable) {
        this.apiServerEnable.setState(apiEnable);
        this.localQrMenuItem.setEnabled(apiEnable);
        this.canvasQrMenuItem.setEnabled(apiEnable);
        if (!apiEnable && (this.localQrMenuItem.isSelected() || this.canvasQrMenuItem.isSelected())) {
            this.setShowQR("none");
        }
        this.openInBrowserItem.setEnabled(apiEnable);
        this.openCanvasBrowserItem.setEnabled(apiEnable);
        this.apiServer.setState(apiEnable);
        if (this.bootstrapSSLItem.getState() && apiEnable) {
            this.routeputClient.connect();
        }
    }

    protected void resetConfiguration() {
        MidiTools.logIt("Reset Configuration");
        Enumeration<MidiControl> mce = this.midiControlsPanel.getControlsEnumeration();
        while (mce.hasMoreElements()) {
            MidiControl mc = mce.nextElement();
            mc.removeAllListeners();
        }
        try {
            this.midiControlRulePanel.clear();
            this.midiControlsPanel.clear();
            MidiPortManager.deleteAllMidiPortMappings();
            MidiTools.eraseAssets();
            this.randomizerPort.clearAllRules();
            for (MidiToolsPlugin plugin : this.plugins.values()) {
                try {
                    plugin.loadProject(new JSONObject());
                }
                catch (Throwable pluginEx) {
                    System.err.println("TRAPPED PLUGIN THROWABLE....");
                    pluginEx.printStackTrace(System.err);
                }
            }
            this.loadedProjectJSON = null;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.setLastSavedFile(null);
    }

    public static void eraseAssets() {
        File[] assets = MidiTools.getAssetFolder().listFiles();
        for (int i = 0; i < assets.length; ++i) {
            File asset = assets[i];
            asset.delete();
        }
    }

    public void setLastSavedFile(File f) {
        this.lastSavedFile = f;
    }

    public static String getProjectName() {
        String rv = null;
        if (MidiTools.instance.lastSavedFile != null) {
            rv = MidiTools.instance.lastSavedFile.getName().replace(".mtz", "");
        }
        return rv;
    }

    public static void repaintRules() {
        if (instance != null && windowWentVisible && MidiTools.instance.mainTabbedPane.getSelectedIndex() == 1 && MidiTools.instance.midiControlRulePanel != null) {
            MidiTools.instance.midiControlRulePanel.repaint();
        }
    }

    public static void repaintControls() {
        if (instance != null && windowWentVisible && MidiTools.instance.mainTabbedPane.getSelectedIndex() == 0 && MidiTools.instance.midiControlsPanel != null) {
            MidiTools.instance.midiControlsPanel.repaint();
        }
    }

    public static void repaintDevices() {
        if (instance != null && windowWentVisible && MidiTools.instance.midiList != null) {
            MidiTools.instance.midiList.repaint();
        }
    }

    public static void repaintMappings() {
        if (instance != null && windowWentVisible && MidiTools.instance.mainTabbedPane.getSelectedIndex() == 2 && MidiTools.instance.mappingControlBox != null) {
            MidiTools.instance.mappingControlBox.repaint();
        }
    }

    public static MidiControl getMidiControlByIndex(int i) {
        return MidiTools.instance.midiControlsPanel.elementAt(i);
    }

    protected static int getIndexForMidiControl(MidiControl m) {
        return MidiTools.instance.midiControlsPanel.indexOf(m);
    }

    protected static void removeListenerFromControls(MidiControlListener mcl) {
        MidiTools.instance.midiControlsPanel.removeListenerFromControls(mcl);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.apiServerEnable) {
            boolean state = this.apiServerEnable.getState();
            this.changeAPIState(state);
            return;
        }
        if (e.getSource() == this.noneQrMenuItem) {
            if (this.noneQrMenuItem.isSelected()) {
                this.setShowQR("none");
            }
            return;
        }
        if (e.getSource() == this.localQrMenuItem) {
            if (this.localQrMenuItem.isSelected()) {
                this.setShowQR("local");
            }
            return;
        }
        if (e.getSource() == this.remoteQrMenuItem) {
            if (this.remoteQrMenuItem.isSelected()) {
                this.setShowQR("remote");
            }
            return;
        }
        if (e.getSource() == this.canvasQrMenuItem) {
            if (this.canvasQrMenuItem.isSelected()) {
                this.setShowQR("canvas");
            }
            return;
        }
        if (e.getSource() == this.bootstrapSSLItem) {
            this.remoteQrMenuItem.setEnabled(this.bootstrapSSLItem.getState());
            if (this.bootstrapSSLItem.getState()) {
                this.routeputClient.connect();
                this.routeputClient.setAutoReconnect(true);
            } else {
                if (this.remoteQrMenuItem.isSelected()) {
                    this.setShowQR("none");
                }
                this.routeputClient.setAutoReconnect(false);
                this.routeputClient.close();
            }
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("save") && this.lastSavedFile == null) {
            cmd = "export";
        }
        if (cmd.equals("reset")) {
            int n = JOptionPane.showConfirmDialog(null, "Are you sure? This will clear all rules, controls, assets, and mappings", "Reset Confirmation", 0);
            if (n == 0) {
                Thread x = new Thread(){

                    @Override
                    public void run() {
                        MidiTools.this.resetConfiguration();
                    }
                };
                x.start();
            }
        } else if (cmd.equals("exit")) {
            this.tryToExit();
        } else if (cmd.equals("new_random_rule")) {
            JSONObject newRule = MidiRandomizerPort.defaultRuleJSONObject();
            JSONObjectDialog jod = new JSONObjectDialog("New Randomizer Rule", newRule);
            this.randomizerPort.addRandomRule(newRule);
        } else if (cmd.equals("midichannel_net_connect")) {
            JSONObject newRule = new JSONObject();
            newRule.put("channel", "lobby");
            JSONObjectDialog jod = new JSONObjectDialog("New MIDIChannel.net Connection", newRule);
            MIDIChannelMidiPort rpcmp = new MIDIChannelMidiPort(newRule.optString("channel", "lobby"));
            this.cmpp.add(rpcmp);
        } else if (cmd.equals("about")) {
            MidiTools.browseTo("https://openstatic.org/projects/miditools/");
        } else if (cmd.equals("open_api")) {
            MidiTools.browseTo(this.getWebInterfaceURL());
        } else if (cmd.equals("open_canvas")) {
            MidiTools.browseTo(this.getCanvasURL());
        } else if (cmd.equals("save")) {
            this.saveProjectAs(this.lastSavedFile);
        } else if (cmd.equals("export")) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Specify a file to save");
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Midi Tools Project", "mtz");
            fileChooser.setFileFilter(filter);
            int userSelection = fileChooser.showSaveDialog(this);
            if (userSelection == 0) {
                File fileToSave = fileChooser.getSelectedFile();
                if (!fileToSave.getName().endsWith(".mtz")) {
                    fileToSave = new File(fileToSave.toString() + ".mtz");
                }
                this.saveProjectAs(fileToSave);
            }
        } else if (cmd.equals("import")) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Specify a file to open");
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Midi Tools Project", "mtz");
            fileChooser.setFileFilter(filter);
            int userSelection = fileChooser.showOpenDialog(this);
            if (userSelection == 0) {
                File fileToLoad = fileChooser.getSelectedFile();
                this.resetConfiguration();
                new Thread(() -> this.loadProject(fileToLoad)).start();
            }
        } else if (cmd.equals("manage_plugins")) {
            PluginManagerWindow pmw = new PluginManagerWindow();
            pmw.setVisible(true);
        } else if (cmd.equals("load_plugin")) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Specify a file to open");
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Java Archive", "jar");
            fileChooser.setFileFilter(filter);
            int userSelection = fileChooser.showOpenDialog(this);
            if (userSelection == 0) {
                File fileToLoad = fileChooser.getSelectedFile();
                Path pathToLoad = fileToLoad.toPath();
                Path targetPluginPath = new File(MidiTools.getPluginFolder(), fileToLoad.getName()).toPath();
                new Thread(() -> {
                    try {
                        Files.copy(pathToLoad, targetPluginPath, StandardCopyOption.REPLACE_EXISTING);
                        this.loadPlugin(targetPluginPath.toFile());
                    }
                    catch (Exception eCopy) {
                        eCopy.printStackTrace(System.err);
                    }
                }).start();
            }
        } else if (cmd.equals("new_control")) {
            CreateControlDialog createControlDialog = new CreateControlDialog();
        }
    }

    public static File addProjectAsset(File file) {
        return MidiTools.instance.assetManagerPanel.addAsset(file);
    }

    public static File resolveProjectAsset(String filename) {
        return new File(MidiTools.getAssetFolder(), filename);
    }

    public static ComboBoxModel<String> getAssetComboBoxModel(ArrayList<String> extens) {
        Vector<String> assetNames = new Vector<String>();
        for (File file : MidiTools.instance.assetManagerPanel.getAllAssets()) {
            String filename = file.getName();
            String filenameLower = filename.toLowerCase();
            if (extens == null) {
                assetNames.add(filename);
                continue;
            }
            for (String string : extens) {
                if (!filenameLower.endsWith(string)) continue;
                assetNames.add(filename);
            }
        }
        DefaultComboBoxModel<String> rm = new DefaultComboBoxModel<String>(assetNames);
        return rm;
    }

    public static Vector<String> getAllAssetNames() {
        Vector<String> assetNames = new Vector<String>();
        for (File file : MidiTools.instance.assetManagerPanel.getAllAssets()) {
            String filename = file.getName();
            assetNames.add(filename);
        }
        return assetNames;
    }

    public static Vector<String> getSoundAssets() {
        Vector<String> assetNames = new Vector<String>();
        for (File file : MidiTools.instance.assetManagerPanel.getAllAssets()) {
            String filename = file.getName();
            String filenameLower = filename.toLowerCase();
            if (!filenameLower.endsWith(".wav")) continue;
            assetNames.add(filename);
        }
        return assetNames;
    }

    public static Vector<String> getImageAssets() {
        Vector<String> assetNames = new Vector<String>();
        for (File file : MidiTools.instance.assetManagerPanel.getAllAssets()) {
            String filename = file.getName();
            String filenameLower = filename.toLowerCase();
            if (!filenameLower.endsWith(".png") && !filenameLower.endsWith(".gif") && !filenameLower.endsWith(".webp") && !filenameLower.endsWith(".jpg") && !filenameLower.endsWith(".jpeg") && !filenameLower.endsWith(".svg")) continue;
            assetNames.add(filename);
        }
        return assetNames;
    }

    public String getShowQr() {
        if (this.noneQrMenuItem.isSelected()) {
            return "none";
        }
        if (this.canvasQrMenuItem.isSelected()) {
            return "canvas";
        }
        if (this.remoteQrMenuItem.isSelected()) {
            return "remote";
        }
        if (this.localQrMenuItem.isSelected()) {
            return "local";
        }
        return "";
    }

    private void setShowQR(String value) {
        if ("none".equals(value) && this.qrLabel != null) {
            this.deviceQRPanel.remove(this.qrLabel);
            this.qrLabel = null;
            this.deviceQRPanel.revalidate();
            this.noneQrMenuItem.setSelected(true);
        } else {
            if (this.qrLabel != null) {
                this.deviceQRPanel.remove(this.qrLabel);
                this.qrLabel = null;
                this.deviceQRPanel.revalidate();
            }
            Object url = "";
            if ("local".equals(value)) {
                String localIP = MidiTools.getLocalIP();
                url = "https://" + localIP + ":6124/";
                this.localQrMenuItem.setSelected(true);
                System.err.println("LOCAL QR");
            } else if ("remote".equals(value)) {
                url = "https://openstatic.org/mcct/?s=midi-tools-" + LOCAL_SERIAL;
                this.remoteQrMenuItem.setSelected(true);
                System.err.println("REMOTE QR");
            } else if ("canvas".equals(value)) {
                url = this.getCanvasURL();
                this.canvasQrMenuItem.setSelected(true);
                System.err.println("CANVAS QR");
            }
            if (!"".equals(url) && url != null) {
                this.qrLabel = new JLabel(new ImageIcon(MidiTools.QRCode((String)url)));
                this.qrLabel.setBackground(Color.WHITE);
                this.qrLabel.setOpaque(true);
                this.deviceQRPanel.add((Component)this.qrLabel, "South");
                this.deviceQRPanel.revalidate();
            } else {
                this.noneQrMenuItem.setSelected(true);
            }
        }
    }

    public String getWebInterfaceURL() {
        String localIP = MidiTools.getLocalIP();
        if (this.bootstrapSSLItem.getState()) {
            return "https://openstatic.org/mcct/?s=midi-tools-" + LOCAL_SERIAL;
        }
        return "https://" + localIP + ":6124/";
    }

    public String getCanvasURL() {
        String localIP = MidiTools.getLocalIP();
        return "http://" + localIP + ":6123/canvas.html";
    }

    public static Vector<String> getCanvasNames() {
        Vector<String> canvasNames = new Vector<String>();
        canvasNames.add("(ALL)");
        canvasNames.add("(NONE)");
        try {
            Enumeration<MidiControlRule> newRuleEnum = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
            while (newRuleEnum.hasMoreElements()) {
                String canvasName;
                MidiControlRule mcr = newRuleEnum.nextElement();
                if (mcr.getActionType() != 2 && mcr.getActionType() != 10 || (canvasName = mcr.getCanvasName()) == null || canvasNames.contains(canvasName)) continue;
                canvasNames.add(canvasName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return canvasNames;
    }

    public static void renamedFile(String original, String newName) {
        try {
            Enumeration<MidiControlRule> newRuleEnum = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
            while (newRuleEnum.hasMoreElements()) {
                String actionValue;
                MidiControlRule mcr = newRuleEnum.nextElement();
                if (mcr.getActionType() != 2 && mcr.getActionType() != 1 || (actionValue = mcr.getActionValue()) == null || !actionValue.contains(original)) continue;
                mcr.setActionValue(actionValue.replace(original, newName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        System.err.println("Launched Main Thread");
        while (this.keep_running) {
            long ts = System.currentTimeMillis();
            try {
                if (ts - this.lastSecondAt > 1000L) {
                    this.everySecond();
                    this.lastSecondAt = ts;
                }
                if (windowWentVisible) {
                    Enumeration<MidiControl> mce = this.midiControlsPanel.getControlsEnumeration();
                    while (mce.hasMoreElements()) {
                        MidiControl mc = mce.nextElement();
                        if (ts - mc.getLastChangeAt() <= 250L || mc.isSettled()) continue;
                        mc.settle();
                    }
                }
                Thread.sleep(50L);
            }
            catch (Exception e) {
                MidiTools.instance.midi_logger_b.printException(e);
            }
        }
        System.err.println("Left Main Thread");
    }

    private void everySecond() throws Exception {
        if (System.currentTimeMillis() - appLaunchTime > 60000L && !windowWentVisible) {
            System.err.println("INTERNAL FAILURE");
            System.exit(1);
        }
        if (windowWentVisible) {
            Component mainTabComponent;
            try {
                this.assetManagerPanel.refresh();
                if (this.keep_running) {
                    Object newTitle = "MIDI Control Change Tool v1.7";
                    if (this.lastSavedFile != null && !this.lastSavedFile.getParentFile().equals(MidiTools.getConfigFolder())) {
                        boolean unsavedProjectChanges = this.hasUnsavedProjectChanges();
                        newTitle = unsavedProjectChanges ? "MIDI Control Change Tool v1.7 - [*" + this.lastSavedFile.getName() + "]" : "MIDI Control Change Tool v1.7 - [" + this.lastSavedFile.getName() + "]";
                    }
                    if (!((String)newTitle).equals(this.getTitle())) {
                        this.setTitle((String)newTitle);
                    }
                } else {
                    System.err.println("Not messing with title!");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            MidiTools.repaintRules();
            MidiTools.repaintMappings();
            MidiTools.repaintDevices();
            if (this.isShowing()) {
                this.windowLocation = this.getLocationOnScreen();
            }
            if ((mainTabComponent = this.mainTabbedPane.getSelectedComponent()) != null) {
                mainTabComponent.repaint();
            }
        }
    }

    public boolean hasUnsavedProjectChanges() {
        if (this.loadedProjectJSON != null) {
            String loadedConfig = this.loadedProjectJSON.toString();
            String possibleConfig = this.compileProjectJSON().toString();
            return !possibleConfig.equals(loadedConfig);
        }
        return true;
    }

    private void centerWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        float WIDTH = screenSize.width;
        float HEIGHT = screenSize.height;
        int wWidth = 1024;
        int wHeight = 600;
        Dimension d = new Dimension(wWidth, wHeight);
        this.setSize(d);
        this.setMinimumSize(d);
        int x = (int)(WIDTH / 2.0f - (float)wWidth / 2.0f);
        int y = (int)(HEIGHT / 2.0f - (float)wHeight / 2.0f);
        this.windowLocation = new Point(x, y);
        this.setLocation(x, y);
        MidiTools.logIt("Centered Window");
    }

    public static void main(String[] args) {
        MidiPortManager.init();
        String os_name = System.getProperty("os.name").toLowerCase();
        LOCAL_SERIAL = MidiTools.getLocalMAC();
        System.err.println("main() midi-tools");
        if (os_name.contains("linux")) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception) {}
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MidiTools.eraseAssets();
        final MidiTools mlb = new MidiTools(os_name);
        mlb.start();
        File loadFile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.endsWith(".mtz")) {
                System.err.println("Arg(" + String.valueOf(i) + ") = " + arg);
                loadFile = new File(arg);
            }
            if (!arg.equals("-max")) continue;
            forceMaximize = true;
        }
        mlb.loadConfig(loadFile);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    System.err.println("TRYING TO BRING WINDOW VISIBLE");
                    mlb.setVisible(true);
                    System.err.println("WINDOW BROUGHT VISIBLE");
                }
                catch (Throwable goVisible) {
                    System.exit(1);
                }
            }
        });
        MidiTools.logIt("Finished Startup");
    }

    public static boolean isRuleGroupEnabled(String groupName) {
        Enumeration<MidiControlRule> mcre = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
        while (mcre.hasMoreElements()) {
            MidiControlRule mcr = mcre.nextElement();
            if (!mcr.getRuleGroup().equals(groupName) || mcr.isEnabled()) continue;
            return false;
        }
        return true;
    }

    public static void setRuleGroupEnabled(String groupName, boolean v) {
        boolean groupEnabled = MidiTools.isRuleGroupEnabled(groupName);
        if (v && !groupEnabled) {
            Enumeration<MidiControlRule> mcre = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
            while (mcre.hasMoreElements()) {
                MidiControlRule mcr = mcre.nextElement();
                if (!mcr.getRuleGroup().equals(groupName)) continue;
                mcr.setEnabled(true);
            }
            MidiTools.instance.midi_logger_b.println("Rule Group Enabled " + groupName);
        } else if (!v && groupEnabled) {
            Enumeration<MidiControlRule> mcre = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
            while (mcre.hasMoreElements()) {
                MidiControlRule mcr = mcre.nextElement();
                if (!mcr.getRuleGroup().equals(groupName)) continue;
                mcr.setEnabled(false);
            }
            MidiTools.instance.midi_logger_b.println("Rule Group Disabled " + groupName);
        }
    }

    public static void toggleRuleGroupEnabled(String groupName) {
        Enumeration<MidiControlRule> mcre = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
        while (mcre.hasMoreElements()) {
            MidiControlRule mcr = mcre.nextElement();
            if (!mcr.getRuleGroup().equals(groupName)) continue;
            mcr.toggleEnabled();
        }
    }

    public static MidiControlRule getMidiControlRuleById(String ruleId) {
        Enumeration<MidiControlRule> mcre = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
        while (mcre.hasMoreElements()) {
            MidiControlRule mcr = mcre.nextElement();
            if (!mcr.getRuleId().equals(ruleId)) continue;
            return mcr;
        }
        return null;
    }

    public static MidiControl getMidiControlByChannelNote(int channel, int note) {
        Enumeration<MidiControl> mce = MidiTools.instance.midiControlsPanel.getControlsEnumeration();
        while (mce.hasMoreElements()) {
            MidiControl mc = mce.nextElement();
            if (mc.getChannel() != channel || mc.getNoteNumber() != note) continue;
            return mc;
        }
        return null;
    }

    public static MidiControl getMidiControlByChannelCC(int channel, int cc) {
        Enumeration<MidiControl> mce = MidiTools.instance.midiControlsPanel.getControlsEnumeration();
        while (mce.hasMoreElements()) {
            MidiControl mc = mce.nextElement();
            if (mc.getChannel() != channel || mc.getControlNumber() != cc) continue;
            return mc;
        }
        return null;
    }

    public static MidiControl createMidiControlFromJSON(JSONObject jo) {
        return MidiTools.createMidiControlFromJSON(jo, 0);
    }

    public static MidiControl createMidiControlFromJSON(JSONObject jo, int index) {
        int channel = jo.optInt("channel", 0);
        int cc = jo.optInt("cc", -1);
        int note = jo.optInt("note", -1);
        if (cc >= 0) {
            MidiControl mc = MidiTools.getMidiControlByChannelCC(channel, cc);
            if (mc == null) {
                mc = new MidiControl(jo);
                MidiTools.handleNewMidiControl(mc, index);
            }
            return mc;
        }
        if (note >= 0) {
            MidiControl mc = MidiTools.getMidiControlByChannelNote(channel, note);
            if (mc == null) {
                mc = new MidiControl(jo);
                MidiTools.handleNewMidiControl(mc, index);
            }
            return mc;
        }
        return null;
    }

    public static void removeMidiControl(MidiControl mc) {
        try {
            MidiTools.instance.midiControlsPanel.removeMidiControl(mc);
            JSONObject event = new JSONObject();
            event.put("event", "controlRemoved");
            event.put("control", mc.toJSONObject());
            MidiTools.instance.apiServer.broadcastJSONObject(event);
            MidiTools.instance.midi_logger_b.println("MIDI Control Removed " + mc.toString());
        }
        catch (Exception e) {
            MidiTools.instance.midi_logger_b.printException(e);
        }
    }

    public static void handleNewMidiControl(MidiControl mc) {
        MidiTools.handleNewMidiControl(mc, 0);
    }

    public static void handleNewMidiControl(MidiControl mc, int index) {
        try {
            if (windowWentVisible) {
                SwingUtilities.invokeAndWait(() -> MidiTools.instance.midiControlsPanel.insertElementAt(mc, index));
            } else {
                MidiTools.instance.midiControlsPanel.insertElementAt(mc, index);
            }
            mc.addMidiControlListener(MidiTools.instance.apiServer);
            mc.addMidiControlListener(MidiTools.instance.routeputSessionManager);
            JSONObject event = new JSONObject();
            event.put("event", "controlAdded");
            event.put("control", mc.toJSONObject());
            MidiTools.instance.apiServer.broadcastJSONObject(event);
            MidiTools.repaintControls();
            MidiTools.instance.midi_logger_b.println("MIDI Control Added " + mc.toString());
        }
        catch (Exception e) {
            MidiTools.instance.midi_logger_b.printException(e);
        }
    }

    public static File getConfigFile() {
        return new File(MidiTools.getConfigFolder(), "midi-tools.json");
    }

    public static File getConfigFolder() {
        File configFolder = new File(System.getProperty("user.home"), ".midi-tools/");
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        return configFolder;
    }

    public static File getAssetFolder() {
        File assetFolder = new File(MidiTools.getConfigFolder(), "assets/");
        if (!assetFolder.exists()) {
            assetFolder.mkdirs();
        }
        return assetFolder;
    }

    public static File getPluginFolder() {
        File pluginFolder = new File(MidiTools.getConfigFolder(), "plugins/");
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        return pluginFolder;
    }

    public static void logIt(String text) {
        System.err.println(text);
        if (instance != null) {
            if (MidiTools.instance.midi_logger_b != null) {
                MidiTools.instance.midi_logger_b.println(text);
            }
            if (MidiTools.instance.routeputClient != null) {
                RoutePutMessage logMsg = new RoutePutMessage();
                logMsg.setType("info");
                logMsg.put("text", text);
                MidiTools.instance.routeputClient.send(logMsg);
            }
        }
    }

    public JSONArray rulesAsJSONArray() {
        JSONArray rulesArray = new JSONArray();
        Enumeration<MidiControlRule> mcre = this.midiControlRulePanel.getRulesEnumeration();
        while (mcre.hasMoreElements()) {
            MidiControlRule mcr = mcre.nextElement();
            rulesArray.put(mcr.toSavableJSONObject());
        }
        return rulesArray;
    }

    public JSONArray mappingsAsJSONArray() {
        JSONArray mappingArray = new JSONArray();
        for (MidiPortMapping mpm : MidiPortManager.getMidiPortMappings()) {
            mappingArray.put(mpm.toSavableJSONObject());
        }
        return mappingArray;
    }

    public JSONArray controlsAsJSONArray() {
        JSONArray controlsArray = new JSONArray();
        Enumeration<MidiControl> mce = this.midiControlsPanel.getControlsEnumeration();
        while (mce.hasMoreElements()) {
            MidiControl mc = mce.nextElement();
            controlsArray.put(mc.toSavableJSONObject());
        }
        return controlsArray;
    }

    public JSONArray openReceivingPortsAsJSONArray() {
        JSONArray portsArray = new JSONArray();
        for (MidiPort t : MidiPortManager.getReceivingPorts()) {
            if (!t.isOpened()) continue;
            portsArray.put(t.getName());
        }
        return portsArray;
    }

    public JSONArray openTransmittingPortsAsJSONArray() {
        JSONArray portsArray = new JSONArray();
        for (MidiPort t : MidiPortManager.getTransmittingPorts()) {
            if (!t.isOpened()) continue;
            portsArray.put(t.getName());
        }
        return portsArray;
    }

    public void saveConfig() {
        File file = MidiTools.getConfigFile();
        MidiTools.logIt("Saving Configuration: " + file.getName());
        try {
            JSONObject configJson = new JSONObject();
            configJson.put("apiServer", this.apiServerEnable.getState());
            configJson.put("bootstrapSSL", this.bootstrapSSLItem.getState());
            configJson.put("showQrType", this.getShowQr());
            configJson.put("windowX", this.windowLocation.x);
            configJson.put("windowY", this.windowLocation.y);
            configJson.put("windowWidth", this.getWidth());
            configJson.put("windowHeight", this.getHeight());
            if (this.lastSavedFile == null) {
                this.lastSavedFile = new File(MidiTools.getConfigFolder(), "Untitled.mtz");
            }
            if (this.lastSavedFile.getName().contains("Untitled.mtz")) {
                this.saveProjectAs(this.lastSavedFile);
            }
            configJson.put("lastSavedFile", this.lastSavedFile.toString());
            for (MidiToolsPlugin plugin : this.plugins.values()) {
                if (plugin == null) continue;
                try {
                    this.pluginSettings.put(plugin.getTitle(), plugin.getSettings());
                }
                catch (Throwable pluginEx) {
                    System.err.println("TRAPPED PLUGIN THROWABLE....");
                    pluginEx.printStackTrace(System.err);
                }
            }
            configJson.put("plugins", this.pluginSettings);
            MidiTools.saveJSONObject(file, configJson);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void loadConfig(File loadProject) {
        File file = MidiTools.getConfigFile();
        MidiTools.logIt("Loading Configuration: " + file.getName());
        try {
            JSONObject configJson = MidiTools.loadJSONObject(file);
            int windowWidth = this.getWidth();
            int windowHeight = this.getHeight();
            windowWidth = configJson.optInt("windowWidth", 1200);
            windowHeight = configJson.optInt("windowHeight", 860);
            Point newWindowLocation = this.windowLocation;
            if (newWindowLocation == null) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Dimension screenSize = tk.getScreenSize();
                float WIDTH = screenSize.width;
                float HEIGHT = screenSize.height;
                int x = (int)(WIDTH / 2.0f - (float)windowWidth / 2.0f);
                int y = (int)(HEIGHT / 2.0f - (float)windowHeight / 2.0f);
                newWindowLocation = new Point(x, y);
            }
            if (configJson.has("bootstrapSSL")) {
                this.bootstrapSSLItem.setState(configJson.optBoolean("bootstrapSSL", false));
            }
            if (configJson.has("apiServer")) {
                boolean apiEnable = configJson.optBoolean("apiServer", false);
                this.changeAPIState(apiEnable);
            }
            if (configJson.has("windowX")) {
                newWindowLocation.x = configJson.optInt("windowX", 0);
            }
            if (configJson.has("windowY")) {
                newWindowLocation.y = configJson.optInt("windowY", 0);
            }
            if (configJson.has("showQrType")) {
                String state = configJson.optString("showQrType", "none");
                this.setShowQR(state);
            }
            Vector<Thread> pluginLoads = new Vector<Thread>();
            if (configJson.has("plugins")) {
                this.pluginSettings = configJson.getJSONObject("plugins");
                for (MidiToolsPlugin plugin : this.plugins.values()) {
                    JSONObject pluginSettingData = this.pluginSettings.optJSONObject(plugin.getTitle());
                    if (pluginSettingData == null) {
                        pluginSettingData = new JSONObject();
                    }
                    JSONObject finalPluginSettingData = pluginSettingData;
                    Thread plugin_load_thread = new Thread(() -> {
                        try {
                            plugin.loadSettings(this, finalPluginSettingData);
                        }
                        catch (Throwable plugEx) {
                            System.err.println("TRAPPED PLUGIN THROWABLE....");
                            plugEx.printStackTrace(System.err);
                        }
                    });
                    plugin_load_thread.start();
                    pluginLoads.add(plugin_load_thread);
                }
            } else if (this.pluginSettings == null) {
                this.pluginSettings = new JSONObject();
            }
            pluginLoads.forEach(thread -> {
                try {
                    Thread thread2 = thread;
                    synchronized (thread2) {
                        if (thread.isAlive()) {
                            thread.wait(4000L);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            });
            if (loadProject == null) {
                if (configJson.has("lastSavedFile")) {
                    File lsf = new File(configJson.optString("lastSavedFile"));
                    if (lsf.exists()) {
                        this.loadProject(lsf);
                    } else {
                        System.err.println("Last saved doesn't exist..");
                    }
                } else {
                    System.err.println("Last saved key missing");
                }
            } else {
                this.loadProject(loadProject);
            }
            this.setSize(windowWidth, windowHeight);
            if (newWindowLocation != null) {
                this.setLocation(newWindowLocation);
            }
            if (forceMaximize) {
                this.setExtendedState(6);
            }
            System.err.println("CONFIG LOAD FINISHED");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            MidiTools.instance.midi_logger_b.printException(e);
        }
    }

    public JSONObject compileProjectJSON() {
        JSONObject configJson = new JSONObject();
        configJson.put("controls", this.controlsAsJSONArray());
        configJson.put("rules", this.rulesAsJSONArray());
        configJson.put("openReceivingPorts", this.openReceivingPortsAsJSONArray());
        configJson.put("openTransmittingPorts", this.openTransmittingPortsAsJSONArray());
        configJson.put("mappings", this.mappingsAsJSONArray());
        configJson.put("randomizerRules", this.randomizerPort.getAllRules());
        JSONObject projectPluginJson = new JSONObject();
        for (MidiToolsPlugin plugin : this.plugins.values()) {
            try {
                projectPluginJson.put(plugin.getTitle(), plugin.getProject());
            }
            catch (Throwable pluginEx) {
                System.err.println("TRAPPED PLUGIN THROWABLE....");
                pluginEx.printStackTrace(System.err);
            }
        }
        configJson.put("plugins", projectPluginJson);
        configJson.put("assets", new JSONArray(MidiTools.getAllAssetNames()));
        configJson.put("player", this.midiPlayer.getProjectJSON());
        return configJson;
    }

    public void saveProjectAs(File file) {
        try {
            JSONObject configJson = this.compileProjectJSON();
            FileOutputStream fout = new FileOutputStream(file);
            ZipOutputStream zout = new ZipOutputStream(fout);
            ZipEntry ze = new ZipEntry("project.json");
            File[] assets = MidiTools.getAssetFolder().listFiles();
            for (int i = 0; i < assets.length; ++i) {
                File asset = assets[i];
                ZipEntry zipEntry = new ZipEntry("assets/" + asset.getName());
                zout.putNextEntry(zipEntry);
                FileInputStream fis = new FileInputStream(asset);
                byte[] buffer = new byte[4092];
                int byteCount = 0;
                while ((byteCount = fis.read(buffer)) != -1) {
                    zout.write(buffer, 0, byteCount);
                }
                fis.close();
                zout.closeEntry();
            }
            zout.putNextEntry(ze);
            zout.write(configJson.toString(2).getBytes());
            zout.closeEntry();
            zout.close();
            this.loadedProjectJSON = configJson;
            this.setLastSavedFile(file);
            MidiTools.logIt("Project Saved: " + file.getName());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void loadProject(File file) {
        if (file.exists()) {
            try {
                MidiPort p;
                String portName;
                JSONArray portsArray;
                JSONArray rulesArray;
                ZipFile zip = new ZipFile(file);
                JSONObject configJson = new JSONObject();
                Enumeration<? extends ZipEntry> zEnumeration = zip.entries();
                while (zEnumeration.hasMoreElements()) {
                    ZipEntry entry = zEnumeration.nextElement();
                    String entryName = entry.getName();
                    if (entryName.equals("project.json")) {
                        configJson = MidiTools.readJSONObject(zip.getInputStream(entry));
                        continue;
                    }
                    if (!entryName.startsWith("assets/")) continue;
                    String outFilename = entryName.substring(7);
                    MidiTools.logIt("Extracting Asset: " + outFilename);
                    File outFile = new File(MidiTools.getAssetFolder(), outFilename);
                    if (outFile.exists()) continue;
                    InputStream is = zip.getInputStream(entry);
                    FileOutputStream fos = new FileOutputStream(outFile);
                    byte[] buffer = new byte[4092];
                    int byteCount = 0;
                    while ((byteCount = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, byteCount);
                    }
                    fos.close();
                    is.close();
                }
                zip.close();
                if (configJson.has("controls")) {
                    JSONArray controlsArray = configJson.getJSONArray("controls");
                    for (int m = 0; m < controlsArray.length(); ++m) {
                        MidiTools.createMidiControlFromJSON(controlsArray.getJSONObject(m), m);
                    }
                }
                if (configJson.has("rules")) {
                    rulesArray = configJson.getJSONArray("rules");
                    for (int m = 0; m < rulesArray.length(); ++m) {
                        MidiControlRule mcr = new MidiControlRule(rulesArray.getJSONObject(m));
                        this.midiControlRulePanel.addElement(mcr);
                    }
                }
                if (configJson.has("openReceivingPorts")) {
                    portsArray = configJson.getJSONArray("openReceivingPorts");
                    for (int m = 0; m < portsArray.length(); ++m) {
                        portName = portsArray.getString(m);
                        p = MidiPortManager.findReceivingPortByName(portName);
                        if (p == null) continue;
                        System.err.println("Found Receiving Port " + p.getName());
                        p.open();
                        p.addReceiver(this.midiControlsPanel);
                    }
                }
                if (configJson.has("openTransmittingPorts")) {
                    portsArray = configJson.getJSONArray("openTransmittingPorts");
                    for (int m = 0; m < portsArray.length(); ++m) {
                        portName = portsArray.getString(m);
                        p = MidiPortManager.findTransmittingPortByName(portName);
                        if (p == null) continue;
                        System.err.println("Found Transmitting Port " + p.getName());
                        p.open();
                    }
                }
                if (configJson.has("mappings")) {
                    JSONArray mappingsArray = configJson.getJSONArray("mappings");
                    for (int m = 0; m < mappingsArray.length(); ++m) {
                        JSONObject mappingObj = mappingsArray.getJSONObject(m);
                        MidiPortMapping mpm = new MidiPortMapping(mappingObj);
                        MidiPortManager.addMidiPortMapping(mpm);
                    }
                }
                if (configJson.has("randomizerRules")) {
                    rulesArray = configJson.getJSONArray("randomizerRules");
                    this.randomizerPort.setAllRules(rulesArray);
                }
                Vector<Thread> pluginLoads = new Vector<Thread>();
                if (configJson.has("plugins")) {
                    JSONObject pluginProjectSettings = configJson.getJSONObject("plugins");
                    for (MidiToolsPlugin plugin : this.plugins.values()) {
                        JSONObject pluginSettingData = pluginProjectSettings.optJSONObject(plugin.getTitle());
                        if (pluginSettingData == null) continue;
                        Thread pluginLoadThread = new Thread(() -> {
                            try {
                                plugin.loadProject(pluginSettingData);
                            }
                            catch (Throwable pluginEx) {
                                System.err.println("TRAPPED PLUGIN THROWABLE....");
                                pluginEx.printStackTrace(System.err);
                            }
                        });
                        pluginLoadThread.start();
                        pluginLoads.add(pluginLoadThread);
                    }
                }
                pluginLoads.forEach(thread -> {
                    try {
                        Thread thread2 = thread;
                        synchronized (thread2) {
                            if (thread.isAlive()) {
                                thread.wait(4000L);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                });
                this.loadedProjectJSON = configJson;
                this.setLastSavedFile(file);
                Thread refreshPlayerThread = new Thread(() -> {
                    try {
                        Thread.sleep(2000L);
                        this.assetManagerPanel.refresh();
                        this.midiPlayer.refreshAssetChoices();
                        this.midiPlayer.loadProject(this.loadedProjectJSON.optJSONObject("player"));
                        Vector<String> canvasNames = MidiTools.getCanvasNames();
                        JSONObject welcomeObject = new JSONObject();
                        welcomeObject.put("canvasList", new JSONArray(canvasNames));
                        welcomeObject.put("sounds", new JSONArray(MidiTools.getSoundAssets()));
                        welcomeObject.put("images", new JSONArray(MidiTools.getImageAssets()));
                        String projectName = MidiTools.getProjectName();
                        if (projectName != null) {
                            welcomeObject.put("projectName", projectName);
                        }
                        this.apiServer.broadcastCanvasJSONObject(welcomeObject);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                refreshPlayerThread.start();
                MidiTools.logIt("Project Loaded: " + file.getName());
            }
            catch (Exception e) {
                MidiTools.instance.midi_logger_b.printException(e);
            }
        } else {
            MidiTools.logIt("Project Doesn't Exist! " + file.getName());
        }
    }

    public static JSONObject readJSONObject(InputStream is) {
        try {
            int ch;
            StringBuilder builder = new StringBuilder();
            while ((ch = is.read()) != -1) {
                builder.append((char)ch);
            }
            is.close();
            JSONObject props = new JSONObject(builder.toString());
            return props;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public static JSONObject loadJSONObject(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            return MidiTools.readJSONObject(fis);
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public static void saveJSONObject(File file, JSONObject obj) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream ps = new PrintStream(fos);
            ps.print(obj.toString(2));
            ps.close();
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean browseTo(String url) {
        try {
            CopyOrGo copyOrGo = new CopyOrGo((Frame)instance, url);
            copyOrGo.setVisible(true);
            return true;
        }
        catch (Exception dt_ex) {
            return false;
        }
    }

    public static JSONObject MidiPortToJSONObject(MidiPort port) {
        JSONObject dev = new JSONObject();
        dev.put("name", port.getName());
        if (port.canTransmitMessages() && port.canReceiveMessages()) {
            dev.put("type", "both");
        } else if (port.canTransmitMessages()) {
            dev.put("type", "output");
        } else if (port.canReceiveMessages()) {
            dev.put("type", "input");
        }
        dev.put("opened", port.isOpened());
        return dev;
    }

    public static BufferedImage QRCode(String url) {
        try {
            ByteArrayOutputStream stream = QRCode.from(url).withSize(150, 150).to(ImageType.PNG).stream();
            return ImageIO.read(new ByteArrayInputStream(stream.toByteArray()));
        }
        catch (Exception e) {
            MidiTools.instance.midi_logger_b.printException(e);
            return null;
        }
    }

    public static String getLocalIP() {
        String return_ip = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            while (n.hasMoreElements()) {
                NetworkInterface ni = n.nextElement();
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    String this_ip = ia.getHostAddress();
                    if (ia.isLoopbackAddress() || !ia.isSiteLocalAddress()) continue;
                    return_ip = this_ip;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return return_ip;
    }

    public static String getLocalMAC() {
        String return_mac = "";
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            while (n.hasMoreElements()) {
                NetworkInterface ni = n.nextElement();
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    if (ia.isLoopbackAddress() || !ia.isSiteLocalAddress()) continue;
                    byte[] mac = ni.getHardwareAddress();
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < mac.length; ++i) {
                        sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                    }
                    return_mac = sb.toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return return_mac;
    }

    public static BufferedImage resizeImage(String amount, BufferedImage in_image, boolean alpha) {
        AffineTransform at;
        if ("".equals(amount) || amount == null) {
            return in_image;
        }
        float scale_to_float = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        float o_w = in_image.getWidth();
        float o_h = in_image.getHeight();
        if (amount.contains("x")) {
            String[] spl = amount.split("x");
            w = Float.valueOf(spl[0]).floatValue();
            h = Float.valueOf(spl[1]).floatValue();
        } else {
            scale_to_float = Float.valueOf(amount).floatValue();
            w = o_w * scale_to_float;
            h = o_h * scale_to_float;
        }
        if (!alpha) {
            at = new AffineTransform();
            at.scale(w / o_w, h / o_h);
            AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
            BufferedImage rgbi = new BufferedImage(in_image.getWidth(), in_image.getHeight(), 1);
            rgbi.createGraphics().drawImage(in_image, 0, 0, Color.WHITE, null);
            BufferedImage ri = new BufferedImage((int)w, (int)h, 1);
            scaleOp.filter(rgbi, ri);
            return ri;
        }
        at = new AffineTransform();
        at.scale(w / o_w, h / o_h);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        BufferedImage rgbi = new BufferedImage(in_image.getWidth(), in_image.getHeight(), 2);
        rgbi.createGraphics().drawImage(in_image, 0, 0, new Color(1.0f, 1.0f, 1.0f, 0.0f), null);
        BufferedImage ri = new BufferedImage((int)w, (int)h, 2);
        scaleOp.filter(rgbi, ri);
        return ri;
    }

    public static synchronized ImageIcon getCachedIcon(String url, String size) {
        return new ImageIcon(MidiTools.getCachedImage(url, size));
    }

    public static synchronized BufferedImage getCachedImage(String url, String size) {
        String key;
        if (size == null) {
            size = "";
        }
        if (cachedImages.containsKey(key = size + "-" + url)) {
            return cachedImages.get(key);
        }
        try {
            BufferedImage image = null;
            if (url.startsWith("http://") || url.startsWith("https://")) {
                System.err.println("Downloading " + url + " ...");
                URL url2 = new URL(url);
                image = ImageIO.read(url2);
            } else if (url.startsWith("/")) {
                System.err.print("READING " + url + " ...");
                image = ImageIO.read(MidiTools.class.getResourceAsStream(url));
            }
            if (image != null) {
                BufferedImage ri = MidiTools.resizeImage(size, image, true);
                cachedImages.put(key, ri);
                return ri;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public boolean removePlugin(String title, String localFile) {
        try {
            MidiToolsPlugin removedPlugin = MidiTools.instance.plugins.remove(title);
            int tabIndex = this.mainTabbedPane.indexOfTab(title);
            if (tabIndex >= 0) {
                this.mainTabbedPane.removeTabAt(tabIndex);
            }
            URLClassLoader urlLoader = (URLClassLoader)removedPlugin.getClass().getClassLoader();
            urlLoader.close();
            File x = new File(localFile);
            if (x.exists()) {
                System.err.println("Flagging jar for delete on exit: " + localFile);
                FileOutputStream out = new FileOutputStream(x);
                out.write(new byte[0]);
                out.flush();
                out.close();
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    public boolean installPlugin(String urlPath, String filename) {
        try {
            File jarFile = new File(MidiTools.getPluginFolder(), filename);
            URL urlPlugin = new URL(urlPath + filename);
            InputStream urlInStream = urlPlugin.openStream();
            FileOutputStream out = new FileOutputStream(jarFile);
            out.write(new byte[0]);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = urlInStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            out.close();
            urlInStream.close();
            return this.loadPlugin(jarFile);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    public boolean loadPlugin(File jarfile) {
        try {
            if (!jarfile.exists()) {
                System.err.println("no jar found");
                return false;
            }
            URLClassLoader child = new URLClassLoader(new URL[]{jarfile.toURL()}, this.getClass().getClassLoader());
            JarFile jf = new JarFile(jarfile);
            Manifest mf = jf.getManifest();
            Attributes at = mf.getMainAttributes();
            String main_class = at.getValue("Main-Class");
            Class<?> c = Class.forName(main_class, true, child);
            Constructor<?> cons = c.getDeclaredConstructor(new Class[0]);
            final MidiToolsPlugin new_plugin = (MidiToolsPlugin)cons.newInstance(new Object[0]);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        String pluginTitle = new_plugin.getTitle();
                        JSONObject newPluginSettings = new JSONObject();
                        if (MidiTools.this.pluginSettings != null && MidiTools.this.pluginSettings.has(pluginTitle)) {
                            newPluginSettings = MidiTools.this.pluginSettings.optJSONObject(pluginTitle);
                        }
                        new_plugin.loadSettings(MidiTools.this, newPluginSettings);
                        JPanel panel = new_plugin.getPanel();
                        MidiTools.this.plugins.put(pluginTitle, new_plugin);
                        if (panel != null) {
                            MidiTools.this.mainTabbedPane.addTab(pluginTitle, new_plugin.getIcon(), panel);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                    }
                }
            };
            t.start();
            MidiTools.logIt("Loaded Plugin: " + jarfile.toString());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            MidiTools.logIt("Couldn't load plugin: " + jarfile.toString());
            jarfile.delete();
            return false;
        }
    }

    static {
        windowWentVisible = false;
        forceMaximize = false;
    }
}

