/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import io.github.leovr.rtipmidi.session.AppleMidiSessionClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstatic.AppleMidiSessionClientCellRenderer;
import org.openstatic.MidiTools;
import org.openstatic.midi.ports.RTPMidiPort;

public class RTPControlBox
extends JPanel
implements ActionListener {
    private JList<AppleMidiSessionClient> mappingList;
    private AppleMidiSessionClientCellRenderer appleMidiSessionClientCellRenderer;
    private long lastMappingClick;
    private JPanel buttonPanel;
    private JButton connectButton;
    private JButton openUrlButton;
    private JButton selectAllButton;
    private JButton disableAllButton;
    private RTPMidiPort port;
    private ImageIcon icon;

    public RTPControlBox(final RTPMidiPort port) {
        super(new BorderLayout());
        this.port = port;
        this.appleMidiSessionClientCellRenderer = new AppleMidiSessionClientCellRenderer(port);
        this.mappingList = new JList<AppleMidiSessionClient>(port);
        this.mappingList.setOpaque(true);
        this.mappingList.setCellRenderer(this.appleMidiSessionClientCellRenderer);
        this.mappingList.setSelectionMode(2);
        this.mappingList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = RTPControlBox.this.mappingList.locationToIndex(e.getPoint());
                if (index != -1) {
                    AppleMidiSessionClient client = RTPControlBox.this.mappingList.getModel().getElementAt(index);
                    if (e.getButton() == 1) {
                        long cms = System.currentTimeMillis();
                        if (cms - RTPControlBox.this.lastMappingClick < 500L && RTPControlBox.this.lastMappingClick > 0L && !client.isConnected() && !client.hasServerConnection(port.getAppleMidiServer())) {
                            client.start();
                        }
                        RTPControlBox.this.lastMappingClick = cms;
                    }
                    RTPControlBox.this.repaint();
                }
            }
        });
        JScrollPane mappingScrollPane = new JScrollPane(this.mappingList, 22, 31);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        try {
            ImageIcon plugInIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/plug_in.png")));
            this.connectButton = new JButton(plugInIcon);
            this.connectButton.setActionCommand("connect");
            this.connectButton.addActionListener(this);
            this.connectButton.setToolTipText("Connect to Server");
            this.buttonPanel.add(this.connectButton);
            ImageIcon urlIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/url32.png")));
            this.openUrlButton = new JButton(urlIcon);
            this.openUrlButton.setActionCommand("url");
            this.openUrlButton.addActionListener(this);
            this.openUrlButton.setToolTipText("Open Device webpage");
            this.buttonPanel.add(this.openUrlButton);
            ImageIcon selectAllIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/selectall32.png")));
            this.selectAllButton = new JButton(selectAllIcon);
            this.selectAllButton.addActionListener(this);
            this.selectAllButton.setActionCommand("select_all");
            this.selectAllButton.setToolTipText("Select All");
            this.buttonPanel.add(this.selectAllButton);
            ImageIcon disableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/disable32.png")));
            this.disableAllButton = new JButton(disableIcon);
            this.disableAllButton.addActionListener(this);
            this.disableAllButton.setActionCommand("disable_selected");
            this.disableAllButton.setToolTipText("Disconnect Selected Connections");
            this.buttonPanel.add(this.disableAllButton);
            this.icon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/rtpnet32.png")));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.add((Component)mappingScrollPane, "Center");
        this.add((Component)this.buttonPanel, "West");
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectButton) {
            Collection<AppleMidiSessionClient> selectedRules = this.getSelectedMappings();
            if (selectedRules.size() != 0) {
                for (AppleMidiSessionClient client : selectedRules) {
                    if (client.isConnected() || client.hasServerConnection(this.port.getAppleMidiServer())) continue;
                    client.start();
                }
            }
        } else if (e.getSource() == this.openUrlButton) {
            Collection<AppleMidiSessionClient> selectedRules = this.getSelectedMappings();
            if (selectedRules.size() != 0) {
                for (AppleMidiSessionClient client : selectedRules) {
                    String ipString = client.getRemoteAddress().toString();
                    if (ipString.startsWith("/")) {
                        ipString = ipString.substring(1);
                    }
                    String url = "http://" + ipString + "/";
                    MidiTools.browseTo(url);
                }
                this.mappingList.repaint();
            }
        } else if (e.getSource() == this.disableAllButton) {
            Collection<AppleMidiSessionClient> selectedRules = this.getSelectedMappings();
            if (selectedRules.size() != 0) {
                for (AppleMidiSessionClient client : selectedRules) {
                    if (client.isConnected()) {
                        client.stopClient();
                        continue;
                    }
                    if (!client.hasServerConnection(this.port.getAppleMidiServer())) continue;
                    System.err.println("Closing remote connection ... ... ...");
                    this.port.getAppleMidiServer().closeConnection(client.getRemoteAddress(), client.getControlPort());
                }
                this.mappingList.repaint();
            }
        } else if (e.getSource() == this.selectAllButton) {
            int rs = this.port.getRemoteServers().size();
            int[] indices = new int[rs];
            for (int i = 0; i < rs; ++i) {
                indices[i] = i;
            }
            this.mappingList.setSelectedIndices(indices);
        }
    }

    public Collection<AppleMidiSessionClient> getSelectedMappings() {
        return this.mappingList.getSelectedValuesList();
    }
}

