/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutSession;

public class RoutePutSessionMidiPort
implements MidiPort {
    public static final int TYPE_BIDIRECTIONAL = 0;
    public static final int TYPE_INPUT = 1;
    public static final int TYPE_OUTPUT = 2;
    private String name;
    private String deviceId;
    private int type;
    private RoutePutSession session;
    private boolean opened;
    private Vector<Receiver> receivers = new Vector();
    private long lastRxAt;
    private long lastTxAt;
    private long txCount;
    private long rxCount;

    public RoutePutSessionMidiPort(String name, String deviceId, RoutePutSession session, int type) {
        this.name = name;
        this.session = session;
        this.deviceId = deviceId;
        this.type = type;
        this.rxCount = 0L;
        this.txCount = 0L;
    }

    public RoutePutSession getRoutePutSession() {
        return this.session;
    }

    public void setRoutePutSession(RoutePutSession s) {
        this.session = s;
    }

    @Override
    public void open() {
        if (!this.opened) {
            try {
                RoutePutMessage mm = new RoutePutMessage();
                mm.put("event", "openMidiDevice");
                mm.put("device", this.getDeviceId());
                MidiPortManager.firePortOpened(this);
                this.session.send(mm);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            this.opened = true;
        }
    }

    @Override
    public void close() {
        if (this.opened) {
            try {
                RoutePutMessage mm = new RoutePutMessage();
                mm.put("event", "closeMidiDevice");
                mm.put("device", this.getDeviceId());
                MidiPortManager.firePortClosed(this);
                this.session.send(mm);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            this.opened = false;
        }
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isAvailable() {
        if (this.session == null) {
            return false;
        }
        return this.session.isConnected();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public long getMicrosecondPosition() {
        return System.currentTimeMillis() * 1000L;
    }

    public void handleWebSocketEvent(JSONObject j) {
        if (this.opened) {
            try {
                if (j.has("do")) {
                    String doCmd = j.optString("do", "");
                    if (doCmd.equals("midiShortMessage")) {
                        JSONArray data = j.getJSONArray("data");
                        long timeStamp = j.optLong("timeStamp", this.getMicrosecondPosition());
                        int data0 = data.optInt(0, 0);
                        int data1 = data.optInt(1, 0);
                        int data2 = data.optInt(2, 0);
                        int command = data0 & 0xF0;
                        int channel = data0 & 0xF;
                        ShortMessage sm = new ShortMessage(command, channel, data1, data2);
                        this.lastRxAt = System.currentTimeMillis();
                        ++this.rxCount;
                        Enumeration re = ((Vector)this.receivers.clone()).elements();
                        while (re.hasMoreElements()) {
                            try {
                                Receiver r = (Receiver)re.nextElement();
                                r.send(sm, timeStamp);
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    } else if (doCmd.equals("beatClock")) {
                        long timeStamp = j.optLong("timeStamp", 0L);
                        ShortMessage sm = new ShortMessage(248);
                        Enumeration re = ((Vector)this.receivers.clone()).elements();
                        while (re.hasMoreElements()) {
                            try {
                                Receiver r = (Receiver)re.nextElement();
                                r.send(sm, timeStamp);
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public boolean equals(MidiPort port) {
        if (port instanceof RoutePutSessionMidiPort) {
            RoutePutSessionMidiPort rps_port = (RoutePutSessionMidiPort)port;
            return this.deviceId.equals(rps_port.getDeviceId());
        }
        return false;
    }

    @Override
    public boolean canTransmitMessages() {
        return this.type == 0 || this.type == 1;
    }

    @Override
    public void addReceiver(Receiver r) {
        if (!this.receivers.contains(r)) {
            this.receivers.add(r);
        }
    }

    @Override
    public void removeReceiver(Receiver r) {
        if (this.receivers.contains(r)) {
            this.receivers.remove(r);
        }
    }

    @Override
    public boolean hasReceiver(Receiver r) {
        return this.receivers.contains(r);
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public boolean canReceiveMessages() {
        return this.type == 0 || this.type == 2;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.lastTxAt = System.currentTimeMillis();
        if (message instanceof ShortMessage && this.opened) {
            ++this.txCount;
            ShortMessage sm = (ShortMessage)message;
            int smStatus = sm.getStatus();
            if (smStatus == 248) {
                try {
                    RoutePutMessage mm = new RoutePutMessage();
                    mm.put("event", "beatClock");
                    mm.put("device", this.getDeviceId());
                    mm.put("timeStamp", timeStamp);
                    this.session.send(mm);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    this.close();
                }
            } else {
                try {
                    RoutePutMessage mm = new RoutePutMessage();
                    mm.put("event", "midiShortMessage");
                    mm.put("device", this.getDeviceId());
                    JSONArray dArray = new JSONArray();
                    dArray.put(sm.getStatus());
                    dArray.put(sm.getData1());
                    dArray.put(sm.getData2());
                    mm.put("data", dArray);
                    mm.put("timeStamp", timeStamp);
                    this.session.send(mm);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    this.close();
                }
            }
        }
    }

    @Override
    public long getLastTxAt() {
        return this.lastTxAt;
    }

    @Override
    public long getLastRxAt() {
        return this.lastRxAt;
    }

    @Override
    public String getCCName(int channel, int cc) {
        return null;
    }

    @Override
    public long getRxCount() {
        return this.rxCount;
    }

    @Override
    public long getTxCount() {
        return this.txCount;
    }
}

