/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.openstatic.MidiTools;
import org.openstatic.midi.MidiPort;

public class MidiPortCellRenderer
extends JPanel
implements ListCellRenderer<MidiPort> {
    private Border selectedBorder;
    private Border regularBorder;
    private JCheckBox checkbox;
    private Dimension dimension = new Dimension(120, 34);

    public MidiPortCellRenderer() {
        super(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setPreferredSize(this.dimension);
        this.selectedBorder = BorderFactory.createLineBorder(Color.RED, 1);
        this.regularBorder = BorderFactory.createLineBorder(new Color(1.0f, 1.0f, 1.0f, 1.0f), 1);
        this.setBorder(this.regularBorder);
        this.checkbox = new JCheckBox();
        this.checkbox.setBackground(Color.WHITE);
        this.checkbox.setOpaque(false);
        this.add((Component)this.checkbox, "Center");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends MidiPort> list, MidiPort device, int index, boolean isSelected, boolean cellHasFocus) {
        String direction = "[]";
        if (device.canTransmitMessages() && device.canReceiveMessages()) {
            direction = "&#10094;&#10095;";
        } else if (device.canTransmitMessages()) {
            direction = "&#10095;&#10095;";
        } else if (device.canReceiveMessages()) {
            direction = "&#10094;&#10094;";
        }
        if (device.isOpened()) {
            this.checkbox.setIcon(MidiTools.getCachedIcon("/midi-tools-res/midiport.png", "32x32"));
        } else {
            this.checkbox.setIcon(MidiTools.getCachedIcon("/midi-tools-res/midiportclosed.png", "32x32"));
        }
        Object devName = device.getName();
        if (((String)devName).length() > 23) {
            devName = ((String)devName).substring(0, 20) + "...";
        }
        this.checkbox.setText("<html><b style=\"font-size: 10px;\">" + direction + " " + (String)devName + "</b><br /><i>Tx " + String.valueOf(device.getTxCount()) + " Rx " + String.valueOf(device.getRxCount()) + "</i></html>");
        this.checkbox.setSelected(device.isOpened());
        if (System.currentTimeMillis() - device.getLastRxAt() < 1000L) {
            this.setBackground(new Color(102, 255, 102));
        } else if (System.currentTimeMillis() - device.getLastTxAt() < 1000L) {
            if (device.isOpened()) {
                this.setBackground(new Color(255, 192, 102));
            } else {
                this.setBackground(new Color(255, 102, 102));
            }
        } else {
            this.setBackground(Color.WHITE);
        }
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        if (isSelected && list.hasFocus()) {
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(this.regularBorder);
        }
        return this;
    }
}

