/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortListener;
import org.openstatic.midi.MidiPortMapping;
import org.openstatic.midi.MidiPortProvider;

public class MidiPortManager {
    private static Vector<MidiPort> ports = new Vector();
    private static Vector<MidiPortProvider> providers = new Vector();
    private static Vector<MidiPortListener> listeners = new Vector();
    private static Vector<MidiPortMapping> mappings = new Vector();
    private static ConcurrentHashMap<MidiPort, ShortMessage> lastMessages = new ConcurrentHashMap();
    private static boolean keepRunning;
    private static Thread refreshThread;
    private static ExecutorService executorService;
    private static String osName;

    public static synchronized String generateBigAlphaKey(int key_length) {
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Random n = new Random(System.currentTimeMillis());
        String alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuffer return_key = new StringBuffer();
        for (int i = 0; i < key_length; ++i) {
            return_key.append(alpha.charAt(n.nextInt(alpha.length())));
        }
        String randKey = return_key.toString();
        return randKey;
    }

    public static void addTask(Runnable r) {
        executorService.submit(r);
    }

    public static boolean isWindows() {
        return osName.contains("windows");
    }

    public static boolean isLinux() {
        return osName.contains("linux");
    }

    public static void init() {
        keepRunning = true;
        osName = System.getProperty("os.name").toLowerCase();
        if (executorService == null) {
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread x = new Thread(r);
                    x.setPriority(10);
                    x.setName("MidiPortManager Realtime");
                    return x;
                }
            };
            executorService = Executors.newFixedThreadPool(6, tf);
        }
        if (refreshThread == null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    MidiPortManager.shutdown();
                    System.out.println("Shutdown MidiPortManager!");
                }
            });
            refreshThread = new Thread(){

                @Override
                public void run() {
                    while (keepRunning) {
                        Thread x = new Thread(){

                            @Override
                            public void run() {
                                MidiPortManager.refresh();
                            }
                        };
                        x.start();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            refreshThread.setDaemon(true);
            refreshThread.start();
        }
    }

    public static void shutdown() {
        keepRunning = false;
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public static boolean isRunning() {
        return keepRunning;
    }

    public static synchronized void refresh() {
        Vector updatedSources = new Vector();
        for (MidiPortProvider midiPortProvider : (Vector)providers.clone()) {
            Collection<? extends MidiPort> ports = midiPortProvider.getMidiPorts();
            if (ports == null) continue;
            updatedSources.addAll(ports.stream().filter(p -> p.isAvailable()).collect(Collectors.toList()));
        }
        for (MidiPort t : updatedSources) {
            if (ports.contains(t)) continue;
            ports.add(t);
            int idx = ports.indexOf(t);
            MidiPortManager.firePortAdded(idx, t);
        }
        for (MidiPort t : ports) {
            if (updatedSources.contains(t)) continue;
            int idx = ports.indexOf(t);
            MidiPortManager.firePortRemoved(idx, t);
        }
        ports = updatedSources;
    }

    private static void firePortAdded(int idx, final MidiPort port) {
        if (port.canTransmitMessages()) {
            Receiver lastMessageListener = new Receiver(){

                @Override
                public void send(MidiMessage message, long timeStamp) {
                    if (message instanceof ShortMessage) {
                        lastMessages.put(port, (ShortMessage)message);
                    }
                }

                @Override
                public void close() {
                }
            };
            port.addReceiver(lastMessageListener);
        }
        Enumeration msle = ((Vector)listeners.clone()).elements();
        while (msle.hasMoreElements()) {
            try {
                MidiPortListener msl = (MidiPortListener)msle.nextElement();
                new Thread(() -> msl.portAdded(idx, port)).start();
            }
            catch (Exception exception) {}
        }
    }

    private static void firePortRemoved(int idx, MidiPort port) {
        Enumeration msle = ((Vector)listeners.clone()).elements();
        while (msle.hasMoreElements()) {
            try {
                MidiPortListener msl = (MidiPortListener)msle.nextElement();
                new Thread(() -> msl.portRemoved(idx, port)).start();
            }
            catch (Exception exception) {}
        }
    }

    public static void firePortOpened(MidiPort port) {
        if (ports.contains(port)) {
            Enumeration msle = ((Vector)listeners.clone()).elements();
            while (msle.hasMoreElements()) {
                try {
                    MidiPortListener msl = (MidiPortListener)msle.nextElement();
                    new Thread(() -> msl.portOpened(port)).start();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void firePortClosed(MidiPort port) {
        if (ports.contains(port)) {
            Enumeration msle = ((Vector)listeners.clone()).elements();
            while (msle.hasMoreElements()) {
                try {
                    MidiPortListener msl = (MidiPortListener)msle.nextElement();
                    new Thread(() -> msl.portClosed(port)).start();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void fireMappingAdded(int idx, MidiPortMapping mapping) {
        Enumeration msle = ((Vector)listeners.clone()).elements();
        while (msle.hasMoreElements()) {
            MidiPortListener msl = (MidiPortListener)msle.nextElement();
            new Thread(() -> msl.mappingAdded(idx, mapping)).start();
        }
    }

    private static void fireMappingRemoved(int idx, MidiPortMapping mapping) {
        Enumeration msle = ((Vector)listeners.clone()).elements();
        while (msle.hasMoreElements()) {
            MidiPortListener msl = (MidiPortListener)msle.nextElement();
            new Thread(() -> msl.mappingRemoved(idx, mapping)).start();
        }
    }

    public static void fireMappingOpened(MidiPortMapping mapping) {
        if (mappings.contains(mapping)) {
            Enumeration msle = ((Vector)listeners.clone()).elements();
            while (msle.hasMoreElements()) {
                try {
                    MidiPortListener msl = (MidiPortListener)msle.nextElement();
                    new Thread(() -> msl.mappingOpened(mapping)).start();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void fireMappingClosed(MidiPortMapping mapping) {
        if (mappings.contains(mapping)) {
            Enumeration msle = ((Vector)listeners.clone()).elements();
            while (msle.hasMoreElements()) {
                try {
                    MidiPortListener msl = (MidiPortListener)msle.nextElement();
                    new Thread(() -> msl.mappingClosed(mapping)).start();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void addProvider(MidiPortProvider mpp) {
        if (!providers.contains(mpp)) {
            providers.add(mpp);
        }
    }

    public static void removeProvider(MidiPortProvider mpp) {
        if (providers.contains(mpp)) {
            providers.remove(mpp);
        }
    }

    public static void addMidiPortListener(MidiPortListener msl) {
        if (!listeners.contains(msl)) {
            listeners.add(msl);
        }
    }

    public static void removeMidiPortListener(MidiPortListener msl) {
        if (listeners.contains(msl)) {
            listeners.remove(msl);
        }
    }

    public static Collection<MidiPort> getPorts() {
        return ports;
    }

    public static MidiPortMapping createMidiPortMapping(MidiPort source, MidiPort dest) {
        MidiPortMapping mpm = new MidiPortMapping(source, dest);
        MidiPortManager.addMidiPortMapping(mpm);
        return mpm;
    }

    public static void addMidiPortMapping(MidiPortMapping mpm) {
        mappings.add(mpm);
        MidiPortManager.fireMappingAdded(mappings.indexOf(mpm), mpm);
    }

    public static void removeMidiPortMapping(MidiPortMapping mpm) {
        if (mpm != null) {
            mpm.close();
            if (mappings.contains(mpm)) {
                int idx = mappings.indexOf(mpm);
                mappings.remove(mpm);
                MidiPortManager.fireMappingRemoved(idx, mpm);
            }
        }
    }

    public static void deleteAllMidiPortMappings() {
        Vector<MidiPortMapping> mappings = new Vector<MidiPortMapping>(MidiPortManager.getMidiPortMappings());
        if (mappings != null) {
            mappings.forEach(mapping -> MidiPortManager.removeMidiPortMapping(mapping));
        }
    }

    public static Collection<MidiPortMapping> getMidiPortMappings() {
        return mappings;
    }

    public static Collection<MidiPort> getReceivingPorts() {
        Vector<MidiPort> inputs = new Vector<MidiPort>();
        for (MidiPort t : ports) {
            if (!t.canReceiveMessages()) continue;
            inputs.add(t);
        }
        return inputs;
    }

    public static Collection<MidiPort> getTransmittingPorts() {
        Vector<MidiPort> outputs = new Vector<MidiPort>();
        for (MidiPort t : ports) {
            if (!t.canTransmitMessages()) continue;
            outputs.add(t);
        }
        return outputs;
    }

    public static MidiPortMapping findMidiPortMappingByName(String mappingName) {
        for (MidiPortMapping t : mappings) {
            if (!t.toString().equals(mappingName)) continue;
            return t;
        }
        return null;
    }

    public static MidiPortMapping findMidiPortMappingById(String mappingId) {
        for (MidiPortMapping t : mappings) {
            if (!t.getMappingId().equals(mappingId)) continue;
            return t;
        }
        return null;
    }

    public static MidiPort findReceivingPortByName(String name) {
        for (MidiPort t : ports) {
            if (!t.canReceiveMessages() || !t.getName().toLowerCase().startsWith(name.toLowerCase())) continue;
            return t;
        }
        return null;
    }

    public static MidiPort findTransmittingPortByChannelCC(int channel, int cc) {
        MidiPort returnPort = null;
        long lastRxAtBest = 0L;
        for (Map.Entry<MidiPort, ShortMessage> t : lastMessages.entrySet()) {
            MidiPort port = t.getKey();
            ShortMessage msg = t.getValue();
            if (!port.canTransmitMessages() || msg.getChannel() + 1 != channel || msg.getCommand() != 176 || msg.getData1() != cc || port.getLastRxAt() <= lastRxAtBest) continue;
            returnPort = port;
            lastRxAtBest = port.getLastRxAt();
        }
        return returnPort;
    }

    public static MidiPort findTransmittingPortByChannelNote(int channel, int note) {
        MidiPort returnPort = null;
        long lastRxAtBest = 0L;
        for (Map.Entry<MidiPort, ShortMessage> t : lastMessages.entrySet()) {
            MidiPort port = t.getKey();
            ShortMessage msg = t.getValue();
            int incomingNote = msg.getData1() % 12;
            if (!port.canTransmitMessages() || msg.getChannel() + 1 != channel || msg.getCommand() != 144 && msg.getCommand() != 128 || incomingNote != note || port.getLastRxAt() <= lastRxAtBest) continue;
            returnPort = port;
            lastRxAtBest = port.getLastRxAt();
        }
        return returnPort;
    }

    public static MidiPort findTransmittingPortByName(String name) {
        for (MidiPort t : ports) {
            if (!t.canTransmitMessages() || !t.getName().toLowerCase().startsWith(name.toLowerCase())) continue;
            return t;
        }
        return null;
    }

    public static MidiPort findBidirectionalPortByName(String name) {
        for (MidiPort t : ports) {
            if (!t.canTransmitMessages() || !t.canReceiveMessages() || !t.getName().toLowerCase().startsWith(name.toLowerCase())) continue;
            return t;
        }
        return null;
    }

    public static String noteNumberToString(int i) {
        String[] noteString = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
        return noteString[i % 12] + String.valueOf((int)Math.floor((float)i / 12.0f) - 2);
    }

    public static String shortMessageToString(ShortMessage msg) {
        String channelText = "CH=" + String.valueOf(msg.getChannel() + 1);
        String commandText = "";
        String data1Name = "?";
        String data1Value = "?";
        if (msg.getCommand() == 176) {
            data1Name = "CC";
            data1Value = String.valueOf(msg.getData1());
            commandText = "CONTROL CHANGE";
        } else if (msg.getCommand() == 144) {
            data1Name = "NOTE";
            data1Value = MidiPortManager.noteNumberToString(msg.getData1());
            commandText = "NOTE ON";
        } else if (msg.getCommand() == 128) {
            data1Name = "NOTE";
            data1Value = MidiPortManager.noteNumberToString(msg.getData1());
            commandText = "NOTE OFF";
        }
        String data1Text = data1Name + "=" + data1Value;
        return "[ " + commandText + " " + channelText + " " + data1Text + " v=" + String.valueOf(msg.getData2()) + " ]";
    }

    public static String nameCC(int cc) {
        switch (cc) {
            case 0: {
                return "Bank Select";
            }
            case 1: {
                return "Mod Wheel";
            }
            case 2: {
                return "Breath Controller";
            }
            case 4: {
                return "Foot Controller";
            }
            case 5: {
                return "Portamento Time";
            }
            case 7: {
                return "Volume";
            }
            case 8: {
                return "Balance";
            }
            case 10: {
                return "Pan";
            }
            case 11: {
                return "Expression";
            }
            case 12: {
                return "Effect Controller 1";
            }
            case 13: {
                return "Effect Controller 2";
            }
            case 64: {
                return "Sustain Pedal";
            }
            case 65: {
                return "Portamento Switch";
            }
            case 66: {
                return "Sostenuto Switch";
            }
            case 91: {
                return "Effect 1 Depth";
            }
            case 92: {
                return "Effect 2 Depth";
            }
            case 93: {
                return "Effect 3 Depth";
            }
            case 94: {
                return "Effect 4 Depth";
            }
            case 95: {
                return "Effect 5 Depth";
            }
        }
        return "Control " + String.valueOf(cc);
    }

    public static String nameNote(int note) {
        switch (note) {
            case 0: {
                return "C";
            }
            case 1: {
                return "C#";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "D#";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "F";
            }
            case 6: {
                return "F#";
            }
            case 7: {
                return "G";
            }
            case 8: {
                return "G#";
            }
            case 9: {
                return "A";
            }
            case 10: {
                return "A#";
            }
            case 11: {
                return "B";
            }
        }
        return "??" + String.valueOf(note);
    }
}

