/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi.ports;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;

public class DeviceMidiPort
implements MidiPort {
    private String name;
    private MidiDevice device;
    private Receiver deviceReceiver;
    private Transmitter deviceTransmitter;
    private Receiver outputReceiver;
    private boolean opened;
    private Vector<Receiver> receivers = new Vector();
    private long lastRxAt;
    private long lastTxAt;
    private long txCount;
    private long rxCount;

    public DeviceMidiPort(MidiDevice device) {
        this.device = device;
        this.name = device.getDeviceInfo().getName();
        this.txCount = 0L;
        this.rxCount = 0L;
        this.outputReceiver = new Receiver(){

            @Override
            public void send(MidiMessage message, long timeStamp) {
                DeviceMidiPort.this.lastRxAt = System.currentTimeMillis();
                ++DeviceMidiPort.this.rxCount;
                Enumeration re = ((Vector)DeviceMidiPort.this.receivers.clone()).elements();
                while (re.hasMoreElements()) {
                    try {
                        Receiver r = (Receiver)re.nextElement();
                        r.send(message, timeStamp);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public long getMicrosecondPosition() {
        return this.device.getMicrosecondPosition();
    }

    @Override
    public boolean canTransmitMessages() {
        int mt = this.device.getMaxTransmitters();
        return mt > 0 || mt == -1;
    }

    @Override
    public boolean canReceiveMessages() {
        int mr = this.device.getMaxReceivers();
        return mr > 0 || mr == -1;
    }

    @Override
    public void open() {
        block6: {
            try {
                if (!this.isOpened()) {
                    if (this.canTransmitMessages()) {
                        this.deviceTransmitter = this.device.getTransmitter();
                        this.deviceTransmitter.setReceiver(this.outputReceiver);
                    }
                    if (this.canReceiveMessages()) {
                        this.deviceReceiver = this.device.getReceiver();
                    }
                    this.device.open();
                    MidiPortManager.firePortOpened(this);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (this.deviceTransmitter != null) {
                    this.deviceTransmitter.close();
                }
                if (this.deviceReceiver == null) break block6;
                this.deviceReceiver.close();
            }
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isOpened() {
        return this.device.isOpen();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public MidiDevice getDevice() {
        return this.device;
    }

    @Override
    public void close() {
        try {
            if (this.isOpened()) {
                this.device.close();
                MidiPortManager.firePortClosed(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.lastTxAt = System.currentTimeMillis();
        if (this.isOpened()) {
            ++this.txCount;
            if (this.deviceReceiver != null) {
                this.deviceReceiver.send(message, timeStamp);
            }
        }
    }

    @Override
    public void addReceiver(Receiver r) {
        if (!this.receivers.contains(r)) {
            this.receivers.add(r);
        }
    }

    @Override
    public void removeReceiver(Receiver r) {
        if (this.receivers.contains(r)) {
            this.receivers.remove(r);
        }
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public boolean hasReceiver(Receiver r) {
        return this.receivers.contains(r);
    }

    @Override
    public boolean equals(MidiPort port) {
        return this.name.equals(port.getName());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public long getLastRxAt() {
        return this.lastRxAt;
    }

    @Override
    public long getLastTxAt() {
        return this.lastTxAt;
    }

    @Override
    public String getCCName(int channel, int cc) {
        return null;
    }

    @Override
    public long getRxCount() {
        return this.rxCount;
    }

    @Override
    public long getTxCount() {
        return this.txCount;
    }
}

