/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi.ports;

import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import org.jaudiolibs.jnajack.JackClient;
import org.jaudiolibs.jnajack.JackException;
import org.jaudiolibs.jnajack.JackPort;
import org.jaudiolibs.jnajack.JackPortFlags;
import org.jaudiolibs.jnajack.JackPortType;
import org.openstatic.midi.JackMidiMessage;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.providers.JackMidiPortProvider;

public class JackMidiPort
implements MidiPort {
    public static final int INPUT_PORT = 1;
    public static final int OUTPUT_PORT = 2;
    private JackMidiPortProvider provider;
    private JackClient client;
    private String name;
    private JackPort jackPort;
    private long lastRxAt;
    private long lastTxAt;
    private long txCount;
    private long rxCount;
    private Vector<Receiver> receivers = new Vector();
    private ConcurrentLinkedQueue<JackMidiMessage> jackOutputQueue;
    private boolean opened;
    private int direction;

    public JackMidiPort(JackMidiPortProvider provider, String portName, int direction) throws JackException {
        this.client = provider.getJackClient();
        this.opened = false;
        this.name = portName;
        this.provider = provider;
        this.txCount = 0L;
        this.rxCount = 0L;
        this.direction = direction;
        this.jackOutputQueue = new ConcurrentLinkedQueue();
        if (direction == 1) {
            this.jackPort = this.client.registerPort(this.name, JackPortType.MIDI, JackPortFlags.JackPortIsInput);
        } else if (direction == 2) {
            this.jackPort = this.client.registerPort(this.name, JackPortType.MIDI, JackPortFlags.JackPortIsOutput);
        }
    }

    public JackPort getJackPort() {
        return this.jackPort;
    }

    @Override
    public void open() {
        this.opened = true;
        MidiPortManager.firePortOpened(this);
    }

    @Override
    public void close() {
        this.opened = false;
        MidiPortManager.firePortClosed(this);
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getName() {
        return "JACK " + this.name;
    }

    public String toString() {
        return "JACK " + this.name;
    }

    @Override
    public long getMicrosecondPosition() {
        try {
            long jackFrameTime = this.client.getFrameTime();
            long frameTime = Math.floorDiv(jackFrameTime, 10L);
            return frameTime;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public boolean equals(MidiPort port) {
        return this.name.equals(port.getName());
    }

    @Override
    public boolean canTransmitMessages() {
        return this.direction == 1;
    }

    public void handleJackData(MidiMessage midiMessage, long timestamp) {
        if (this.opened) {
            try {
                this.lastRxAt = System.currentTimeMillis();
                ++this.rxCount;
                this.receivers.forEach(r -> r.send(midiMessage, timestamp));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public ConcurrentLinkedQueue<JackMidiMessage> getJackOutputQueue() {
        return this.jackOutputQueue;
    }

    @Override
    public void addReceiver(Receiver r) {
        if (!this.receivers.contains(r)) {
            this.receivers.add(r);
        }
    }

    @Override
    public void removeReceiver(Receiver r) {
        if (this.receivers.contains(r)) {
            this.receivers.remove(r);
        }
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public boolean hasReceiver(Receiver r) {
        return this.receivers.contains(r);
    }

    @Override
    public boolean canReceiveMessages() {
        return this.direction == 2;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.lastTxAt = System.currentTimeMillis();
        if (this.opened) {
            ++this.txCount;
            int ts = (int)(this.getMicrosecondPosition() % (long)this.provider.getBufferSize());
            this.jackOutputQueue.add(new JackMidiMessage(message.getMessage(), ts));
        }
    }

    @Override
    public long getLastRxAt() {
        return this.lastRxAt;
    }

    @Override
    public long getLastTxAt() {
        return this.lastTxAt;
    }

    @Override
    public String getCCName(int channel, int cc) {
        return null;
    }

    @Override
    public long getRxCount() {
        return this.rxCount;
    }

    @Override
    public long getTxCount() {
        return this.txCount;
    }
}

