/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi.ports;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;

public class JoystickMidiPort
implements MidiPort,
Runnable {
    private String name;
    private Controller controller;
    private Thread myThread;
    private boolean opened;
    private Vector<Receiver> receivers = new Vector();
    private ArrayList<Component> controls;
    private long lastRxAt;
    private long lastTxAt;
    private HashMap<Integer, String> ccNames = new HashMap();
    private Rumbler[] rumblers;
    private int channel;
    private long txCount;
    private long rxCount;
    private ConcurrentHashMap<Integer, Integer> ccValues = new ConcurrentHashMap();

    public JoystickMidiPort(Controller controller, int channel) {
        this.channel = channel;
        this.txCount = 0L;
        this.rxCount = 0L;
        this.controller = controller;
        this.rumblers = controller.getRumblers();
        this.controls = new ArrayList<Component>(Arrays.asList(controller.getComponents()));
        this.name = controller.getName();
        for (Component control : this.controls) {
            int cc = this.controls.indexOf(control) + 1;
            if (this.ccNames.containsKey(cc)) continue;
            this.ccNames.put(cc, "Gamepad " + control.getName().toUpperCase());
        }
        this.opened = false;
    }

    private boolean isDigital(Component control) {
        if (control.getClass().getName().endsWith("Button")) {
            return true;
        }
        return !control.isAnalog();
    }

    private boolean isHalfAnalag(Component control) {
        return control.getClass().getName().endsWith("Trigger");
    }

    private synchronized boolean hasCCChanged(int cc, int value) {
        int lv = this.getLastWrittenCCValue(cc);
        this.ccValues.put(cc, value);
        return value != lv;
    }

    private int getLastWrittenCCValue(int cc) {
        if (this.ccValues.containsKey(cc)) {
            int v = this.ccValues.get(cc);
            return v;
        }
        return -1;
    }

    @Override
    public void run() {
        System.err.println("Controller thread started");
        while (this.opened) {
            try {
                boolean poll = this.controller.poll();
                if (poll) {
                    EventQueue queue = this.controller.getEventQueue();
                    Event event = new Event();
                    while (queue.getNextEvent(event)) {
                        Component comp = event.getComponent();
                        float value = event.getValue();
                        String compName = comp.getName();
                        String compNameLC = compName.toLowerCase();
                        int data2 = 0;
                        int cc = this.controls.indexOf(comp) + 1;
                        if (this.isDigital(comp)) {
                            data2 = value == 1.0f ? 127 : 0;
                        } else {
                            if (compNameLC.contains("y") && !MidiPortManager.isWindows()) {
                                value = -value;
                            }
                            if ((data2 = this.isHalfAnalag(comp) ? (int)(value * 127.0f) : (int)((value + 1.0f) * 64.0f)) > 127) {
                                data2 = 127;
                            }
                            if (data2 < 0) {
                                data2 = 0;
                            }
                        }
                        long timeStamp = this.getMicrosecondPosition();
                        if (!this.hasCCChanged(cc, data2)) continue;
                        try {
                            ShortMessage sm = new ShortMessage(176, this.channel - 1, cc, data2);
                            this.lastRxAt = System.currentTimeMillis();
                            ++this.rxCount;
                            this.receivers.forEach(r -> r.send(sm, timeStamp));
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
                Thread.sleep(20L);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public long getMicrosecondPosition() {
        return System.currentTimeMillis() * 1000L;
    }

    @Override
    public boolean canTransmitMessages() {
        return true;
    }

    @Override
    public boolean canReceiveMessages() {
        return this.rumblers.length > 0;
    }

    @Override
    public void open() {
        try {
            if (!this.isOpened()) {
                this.opened = true;
                this.myThread = new Thread(this);
                this.myThread.setName("Controller Thread " + this.name);
                this.myThread.start();
                MidiPortManager.firePortOpened(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public void close() {
        try {
            if (this.isOpened()) {
                this.opened = false;
                MidiPortManager.firePortClosed(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static float mapFloat(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.lastTxAt = System.currentTimeMillis();
        if (this.rumblers.length > 0 && message instanceof ShortMessage && this.opened) {
            ++this.txCount;
            ShortMessage smsg = (ShortMessage)message;
            if (smsg.getCommand() == 176) {
                int idx = smsg.getData1() - 1;
                float rumbleValue = JoystickMidiPort.mapFloat(smsg.getData2(), 0.0f, 127.0f, 0.0f, 1.0f);
                if (idx < this.rumblers.length) {
                    this.rumblers[idx].rumble(rumbleValue);
                }
            }
        }
    }

    @Override
    public void addReceiver(Receiver r) {
        if (!this.receivers.contains(r)) {
            this.receivers.add(r);
        }
    }

    @Override
    public void removeReceiver(Receiver r) {
        if (this.receivers.contains(r)) {
            this.receivers.remove(r);
        }
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public boolean hasReceiver(Receiver r) {
        return this.receivers.contains(r);
    }

    @Override
    public boolean equals(MidiPort port) {
        return this.name.equals(port.getName());
    }

    @Override
    public long getLastRxAt() {
        return this.lastRxAt;
    }

    @Override
    public long getLastTxAt() {
        return this.lastTxAt;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getCCName(int channel, int cc) {
        return this.ccNames.get(cc);
    }

    @Override
    public long getRxCount() {
        return this.rxCount;
    }

    @Override
    public long getTxCount() {
        return this.txCount;
    }
}

