/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi.ports;

import java.util.Collection;
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.json.JSONArray;
import org.openstatic.MidiTools;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutMessageListener;
import org.openstatic.routeput.RoutePutSession;
import org.openstatic.routeput.client.RoutePutClient;

public class MIDIChannelMidiPort
implements MidiPort,
RoutePutMessageListener {
    private boolean opened;
    private Vector<Receiver> receivers = new Vector();
    private RoutePutChannel channel;
    private RoutePutClient upstreamClient;
    private int beatPulse;
    private String channelName;
    private long lastRxAt;
    private long lastTxAt;
    private long txCount;
    private long rxCount;

    public MIDIChannelMidiPort(String channelName) {
        this.channelName = channelName;
        this.txCount = 0L;
        this.rxCount = 0L;
        String hostname = MidiTools.getLocalHostname();
        this.channel = RoutePutChannel.getChannel("midichannel-" + this.channelName);
        this.upstreamClient = new RoutePutClient(this.channel, "wss://midichannel.net/channel/");
        this.upstreamClient.setProperty("description", "Midi Control Change Tool " + hostname);
        this.upstreamClient.setProperty("username", "MidiTools " + hostname);
        this.upstreamClient.setProperty("midiChatAvatar", "https://openstatic.org/projects/miditools/icon.png");
        this.upstreamClient.setProperty("typing", false);
        this.upstreamClient.setProperty("playing", false);
        this.upstreamClient.setProperty("outputDevice", "");
        this.upstreamClient.setProperty("inputDevice", "");
        this.upstreamClient.setProperty("midiJS", false);
        this.channel.addMessageListener(this);
        this.beatPulse = 1;
    }

    public RoutePutClient getRoutePutClient() {
        return this.upstreamClient;
    }

    @Override
    public void onMessage(RoutePutSession session, RoutePutMessage j) {
        try {
            if (j.isType("midi")) {
                JSONArray data = j.getRoutePutMeta().getJSONArray("data");
                long timeStamp = j.getRoutePutMeta().optLong("ts", this.getMicrosecondPosition());
                int data0 = data.optInt(0, 0);
                int data1 = data.optInt(1, 0);
                int data2 = data.optInt(2, 0);
                int command = data0 & 0xF0;
                int channel = data0 & 0xF;
                ShortMessage sm = new ShortMessage(command, channel, data1, data2);
                this.lastRxAt = System.currentTimeMillis();
                ++this.rxCount;
                this.receivers.forEach(r -> r.send(sm, timeStamp));
            } else if (j.isType("pulse")) {
                long timeStamp = j.getRoutePutMeta().optLong("ts", 0L);
                ShortMessage sm = new ShortMessage(248);
                this.receivers.forEach(r -> r.send(sm, timeStamp));
            } else if (j.has("username") && j.optString("event", "").equals("chat")) {
                String username = j.optString("username", "unknown");
                Object chatMessage = "";
                if (j.has("text")) {
                    chatMessage = "(" + this.getName() + ") " + username + ": " + j.optString("text", "");
                } else if (j.has("html")) {
                    chatMessage = "(" + this.getName() + ") " + username + ": " + j.optString("html", "");
                }
                if (MidiTools.instance != null && MidiTools.instance.midi_logger_b != null) {
                    MidiTools.instance.midi_logger_b.println((String)chatMessage);
                }
                System.err.println((String)chatMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public long getMicrosecondPosition() {
        return System.currentTimeMillis() * 1000L;
    }

    @Override
    public boolean canTransmitMessages() {
        return true;
    }

    @Override
    public boolean canReceiveMessages() {
        return true;
    }

    @Override
    public void open() {
        if (!this.isOpened()) {
            this.opened = true;
            this.upstreamClient.setAutoReconnect(true);
            this.upstreamClient.connect();
            MidiTools.logIt("Opening connection to MIDIChannel.net");
            MidiPortManager.firePortOpened(this);
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isOpened() {
        return this.opened && this.upstreamClient.isConnected();
    }

    @Override
    public String getName() {
        return "MIDIChannel.net #" + this.channelName;
    }

    @Override
    public void close() {
        if (this.isOpened()) {
            MidiPortManager.firePortClosed(this);
            if (this.upstreamClient != null) {
                try {
                    this.upstreamClient.setAutoReconnect(false);
                    this.upstreamClient.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.opened = false;
        }
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.lastTxAt = System.currentTimeMillis();
        if (message instanceof ShortMessage && this.opened && this.upstreamClient.isConnected()) {
            ++this.txCount;
            ShortMessage sm = (ShortMessage)message;
            int smStatus = sm.getStatus();
            if (smStatus == 248) {
                RoutePutMessage mm = new RoutePutMessage();
                mm.setType("pulse");
                mm.setMetaField("ts", timeStamp);
                mm.setMetaField("pulse", this.beatPulse);
                if (this.beatPulse >= 24) {
                    this.beatPulse = 0;
                }
                ++this.beatPulse;
                mm.setChannel(this.upstreamClient.getDefaultChannel());
                this.upstreamClient.send(mm);
            } else {
                RoutePutMessage mm = new RoutePutMessage();
                mm.setType("midi");
                JSONArray dArray = new JSONArray();
                dArray.put(sm.getStatus());
                dArray.put(sm.getData1());
                dArray.put(sm.getData2());
                mm.setMetaField("data", dArray);
                mm.setMetaField("ts", timeStamp);
                mm.setChannel(this.upstreamClient.getDefaultChannel());
                this.upstreamClient.send(mm);
            }
        }
    }

    @Override
    public void addReceiver(Receiver r) {
        if (!this.receivers.contains(r)) {
            this.receivers.add(r);
        }
    }

    @Override
    public void removeReceiver(Receiver r) {
        if (this.receivers.contains(r)) {
            this.receivers.remove(r);
        }
    }

    @Override
    public Collection<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public boolean hasReceiver(Receiver r) {
        return this.receivers.contains(r);
    }

    @Override
    public boolean equals(MidiPort port) {
        return this.upstreamClient.getDefaultChannel().equals(port.getName());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public long getLastRxAt() {
        return this.lastRxAt;
    }

    @Override
    public long getLastTxAt() {
        return this.lastTxAt;
    }

    @Override
    public String getCCName(int channel, int cc) {
        return null;
    }

    @Override
    public long getRxCount() {
        return this.rxCount;
    }

    @Override
    public long getTxCount() {
        return this.txCount;
    }
}

