/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.midi.providers;

import de.ralleytn.plugins.jinput.xinput.XInputEnvironmentPlugin;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.MidiPortProvider;
import org.openstatic.midi.ports.JoystickMidiPort;

public class JoystickMidiPortProvider
implements MidiPortProvider {
    private LinkedHashMap<String, JoystickMidiPort> localDevices = new LinkedHashMap();
    private ControllerEnvironment controllerEnvironment = MidiPortManager.isWindows() ? new XInputEnvironmentPlugin() : ControllerEnvironment.getDefaultEnvironment();

    @Override
    public Collection<? extends MidiPort> getMidiPorts() {
        Controller[] ca = this.controllerEnvironment.getControllers();
        Vector<Controller> newLocalDevices = new Vector<Controller>(Arrays.asList(ca));
        Vector<String> controllerNames = new Vector<String>();
        for (Controller di : newLocalDevices) {
            int componentCount = di.getComponents().length;
            String devName = di.getName().toLowerCase();
            controllerNames.add(devName);
            if (this.localDevices.containsKey(devName) || componentCount <= 0 || devName.contains("mouse") || devName.contains("keyboard")) continue;
            JoystickMidiPort ms = new JoystickMidiPort(di, this.localDevices.size() + 1);
            this.localDevices.put(devName, ms);
            System.err.println("Gamepad Added: " + devName);
        }
        for (String key : this.localDevices.keySet()) {
            if (controllerNames.contains(key)) continue;
            System.err.println("Gamepad Removed: " + key);
            JoystickMidiPort removedGamepad = (JoystickMidiPort)this.localDevices.remove(key);
            removedGamepad.close();
        }
        return this.localDevices.values();
    }
}

