/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput;

import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutSession;
import org.openstatic.routeput.util.JSONTools;

public class RoutePutMessage
extends JSONObject {
    public static final String TYPE_CONNECTION_ID = "connectionId";
    public static final String TYPE_CONNECTION_STATUS = "ConnectionStatus";
    public static final String TYPE_BLOB = "blob";
    public static final String TYPE_PROPERTY_CHANGE = "propertyChange";
    public static final String TYPE_MIDI = "midi";
    public static final String TYPE_PULSE = "pulse";
    public static final String TYPE_GPS = "gps";
    public static final String TYPE_REQUEST = "request";
    public static final String TYPE_RESPONSE = "response";
    public static final String TYPE_PING = "ping";
    public static final String TYPE_PONG = "pong";
    public static final String TYPE_LOG_ERROR = "error";
    public static final String TYPE_LOG_WARNING = "warning";
    public static final String TYPE_LOG_INFO = "info";
    public static final String TYPE_BINARY_STREAM = "binary";

    public RoutePutMessage(JSONObject jsonObject) {
        super(jsonObject.toString());
        this.getRoutePutMeta();
    }

    public RoutePutMessage(String json) {
        super(json);
        this.getRoutePutMeta();
    }

    public RoutePutMessage() {
        this.getRoutePutMeta();
    }

    public static synchronized String generateMessageId() {
        int key_length = 10;
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Random n = new Random(System.currentTimeMillis());
        String alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuffer return_key = new StringBuffer();
        int i = 0;
        while (i < key_length) {
            return_key.append(alpha.charAt(n.nextInt(alpha.length())));
            ++i;
        }
        String randKey = return_key.toString();
        return randKey;
    }

    public JSONObject getRoutePutMeta() {
        if (!this.has("__routeput")) {
            JSONObject rpm = new JSONObject();
            rpm.put("msgId", RoutePutMessage.generateMessageId());
            this.put("__routeput", rpm);
            return rpm;
        }
        JSONObject rpm = this.optJSONObject("__routeput");
        if (!rpm.has("msgId")) {
            rpm.put("msgId", RoutePutMessage.generateMessageId());
        }
        return rpm;
    }

    public void mergeRouteputMeta(JSONObject obj) {
        if (obj != null) {
            for (String key : obj.keySet()) {
                Object newValue = obj.opt(key);
                this.getRoutePutMeta().put(key, newValue);
            }
        }
    }

    public boolean hasMetaField(String fieldName) {
        return this.getRoutePutMeta().has(fieldName);
    }

    public void setMetaField(String fieldName, int val2) {
        this.getRoutePutMeta().put(fieldName, val2);
    }

    public void setMetaField(String fieldName, long val2) {
        this.getRoutePutMeta().put(fieldName, val2);
    }

    public void setMetaField(String fieldName, boolean val2) {
        this.getRoutePutMeta().put(fieldName, val2);
    }

    public void setMetaField(String fieldName, Object val2) {
        this.getRoutePutMeta().put(fieldName, val2);
    }

    public boolean optMetaField(String fieldName, boolean defaultValue) {
        return this.getRoutePutMeta().optBoolean(fieldName, defaultValue);
    }

    public String optMetaField(String fieldName, String defaultValue) {
        return this.getRoutePutMeta().optString(fieldName, defaultValue);
    }

    public void removeMetaField(String fieldName) {
        if (this.hasMetaField(fieldName)) {
            this.getRoutePutMeta().remove(fieldName);
        }
    }

    public void appendMetaArray(String fieldName, Object val2) {
        if (this.hasMetaField(fieldName)) {
            this.getRoutePutMeta().optJSONArray(fieldName).put(val2);
        } else {
            JSONArray ary = new JSONArray();
            ary.put(val2);
            this.setMetaField(fieldName, ary);
        }
    }

    public Object getPathValue(String path) {
        if (!"".equals(path) && path != null) {
            Object pathValue = JSONTools.getPathValue(this, path);
            if (pathValue == null) {
                return path;
            }
            return pathValue;
        }
        return this.toCleanJSONObject();
    }

    public String getMessageId() {
        return this.getRoutePutMeta().optString("msgId", null);
    }

    public void setRef(RoutePutMessage msg) {
        if (msg != null) {
            this.getRoutePutMeta().put("ref", msg.getMessageId());
        }
    }

    public String getSourceId() {
        return this.getRoutePutMeta().optString("srcId", null);
    }

    public void setSourceId(String connectionId) {
        this.getRoutePutMeta().put("srcId", connectionId);
    }

    public void setSourceIdIfNull(String connectionId) {
        if (!this.getRoutePutMeta().has("srcId")) {
            this.getRoutePutMeta().put("srcId", connectionId);
        }
    }

    public void setSource(RoutePutSession session) {
        if (session != null) {
            this.getRoutePutMeta().put("srcId", session.getConnectionId());
        }
    }

    public boolean hasSourceId() {
        return this.hasMetaField("srcId");
    }

    public String getTargetId() {
        return this.getRoutePutMeta().optString("dstId", null);
    }

    public void setTarget(RoutePutSession session) {
        if (session != null) {
            this.setTargetId(session.getConnectionId());
        }
    }

    public void setTargetId(String connectionId) {
        this.getRoutePutMeta().put("dstId", connectionId);
    }

    public RoutePutMessage forTarget(RoutePutSession session) {
        RoutePutMessage newMsg = new RoutePutMessage(this);
        newMsg.setTargetId(session.getConnectionId());
        return newMsg;
    }

    public boolean hasTargetId() {
        return this.hasMetaField("dstId");
    }

    public String getChannel() {
        return this.getRoutePutMeta().optString("channel", null);
    }

    public RoutePutChannel getRoutePutChannel() {
        return RoutePutChannel.getChannel(this.getChannel());
    }

    public boolean hasChannel() {
        return this.hasMetaField("channel");
    }

    public void setChannel(String channel) {
        this.getRoutePutMeta().put("channel", channel);
    }

    public void setChannel(RoutePutChannel channel) {
        this.getRoutePutMeta().put("channel", channel.getName());
    }

    public void setChannelIfNull(RoutePutChannel channel) {
        if (!this.getRoutePutMeta().has("channel")) {
            this.getRoutePutMeta().put("channel", channel);
        }
    }

    public boolean isType(String type) {
        if (type != null) {
            return type.equals(this.getRoutePutMeta().optString("type", null));
        }
        return false;
    }

    public String getType() {
        return this.getRoutePutMeta().optString("type", null);
    }

    public void setType(String type) {
        this.getRoutePutMeta().put("type", type);
    }

    public void setLogged(boolean logged) {
        this.getRoutePutMeta().put("log", logged);
    }

    public boolean canBeLogged() {
        return this.getRoutePutMeta().optBoolean("log", true);
    }

    public void setRequest(String requestType) {
        this.setType(TYPE_REQUEST);
        this.getRoutePutMeta().put(TYPE_REQUEST, requestType);
    }

    public void setResponse(String responseType, RoutePutMessage request) {
        this.setType(TYPE_RESPONSE);
        this.getRoutePutMeta().put(TYPE_RESPONSE, responseType);
        this.setChannel(request.getRoutePutChannel());
        this.setRef(request);
    }

    public String getRequest() {
        return this.getRoutePutMeta().optString(TYPE_REQUEST, "");
    }

    public String getResponse() {
        return this.getRoutePutMeta().optString(TYPE_RESPONSE, "");
    }

    public JSONObject toCleanJSONObject() {
        JSONObject jo = new JSONObject();
        try {
            JSONArray names = this.names();
            int i = 0;
            while (i < names.length()) {
                String name = names.getString(i);
                if (!"__routeput".equals(name)) {
                    Object value = this.get(name);
                    jo.put(name, value);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return jo;
    }
}

