/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.admin;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bff.javampd.admin.Admin;
import org.bff.javampd.admin.AdminProperties;
import org.bff.javampd.admin.MPDChangeEvent;
import org.bff.javampd.admin.MPDChangeListener;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.output.MPDOutput;
import org.bff.javampd.output.OutputChangeEvent;
import org.bff.javampd.output.OutputChangeListener;
import org.bff.javampd.statistics.ServerStatistics;

public class MPDAdmin
implements Admin {
    private List<MPDChangeListener> listeners = new ArrayList<MPDChangeListener>();
    private List<OutputChangeListener> outputListeners = new ArrayList<OutputChangeListener>();
    protected static final String OUTPUT_PREFIX_ID = "outputid:";
    protected static final String OUTPUT_PREFIX_NAME = "outputname:";
    protected static final String OUTPUT_PREFIX_ENABLED = "outputenabled:";
    private AdminProperties adminProperties;
    private ServerStatistics serverStatistics;
    private CommandExecutor commandExecutor;

    @Inject
    public MPDAdmin(AdminProperties adminProperties, ServerStatistics serverStatistics, CommandExecutor commandExecutor) {
        this.adminProperties = adminProperties;
        this.serverStatistics = serverStatistics;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public Collection<MPDOutput> getOutputs() {
        return new ArrayList<MPDOutput>(MPDAdmin.parseOutputs(this.commandExecutor.sendCommand(this.adminProperties.getOutputs())));
    }

    @Override
    public boolean disableOutput(MPDOutput output) {
        this.fireOutputChangeEvent(OutputChangeEvent.OUTPUT_EVENT.OUTPUT_CHANGED);
        return this.commandExecutor.sendCommand(this.adminProperties.getOutputDisable(), output.getId()).isEmpty();
    }

    @Override
    public boolean enableOutput(MPDOutput output) {
        this.fireOutputChangeEvent(OutputChangeEvent.OUTPUT_EVENT.OUTPUT_CHANGED);
        return this.commandExecutor.sendCommand(this.adminProperties.getOutputEnable(), output.getId()).isEmpty();
    }

    private static Collection<MPDOutput> parseOutputs(Collection<String> response) {
        ArrayList<MPDOutput> outputs = new ArrayList<MPDOutput>();
        Iterator<String> iterator = response.iterator();
        String line = null;
        while (iterator.hasNext()) {
            if (line == null || !line.startsWith(OUTPUT_PREFIX_ID)) {
                line = iterator.next();
            }
            if (!line.startsWith(OUTPUT_PREFIX_ID)) continue;
            outputs.add(MPDAdmin.parseOutput(line, iterator));
        }
        return outputs;
    }

    private static MPDOutput parseOutput(String startingLine, Iterator<String> iterator) {
        MPDOutput output = new MPDOutput(Integer.parseInt(startingLine.substring(OUTPUT_PREFIX_ID.length()).trim()));
        String line = iterator.next();
        while (!line.startsWith(OUTPUT_PREFIX_ID)) {
            if (line.startsWith(OUTPUT_PREFIX_NAME)) {
                output.setName(line.replace(OUTPUT_PREFIX_NAME, "").trim());
            } else if (line.startsWith(OUTPUT_PREFIX_ENABLED)) {
                output.setEnabled("1".equals(line.replace(OUTPUT_PREFIX_ENABLED, "").trim()));
            }
            if (!iterator.hasNext()) break;
            line = iterator.next();
        }
        return output;
    }

    @Override
    public synchronized void addMPDChangeListener(MPDChangeListener mcl) {
        this.listeners.add(mcl);
    }

    @Override
    public synchronized void removeMPDChangeListener(MPDChangeListener mcl) {
        this.listeners.remove(mcl);
    }

    protected synchronized void fireMPDChangeEvent(MPDChangeEvent.Event event) {
        MPDChangeEvent mce = new MPDChangeEvent(this, event);
        for (MPDChangeListener mcl : this.listeners) {
            mcl.mpdChanged(mce);
        }
    }

    @Override
    public void killMPD() {
        this.commandExecutor.sendCommand(this.adminProperties.getKill());
        this.fireMPDChangeEvent(MPDChangeEvent.Event.KILLED);
    }

    @Override
    public void updateDatabase() {
        this.commandExecutor.sendCommand(this.adminProperties.getRefresh());
        this.fireMPDChangeEvent(MPDChangeEvent.Event.REFRESHED);
    }

    @Override
    public void updateDatabase(String path) {
        this.commandExecutor.sendCommand(this.adminProperties.getRefresh(), path);
        this.fireMPDChangeEvent(MPDChangeEvent.Event.REFRESHED);
    }

    @Override
    public void rescanDatabase() {
        this.commandExecutor.sendCommand(this.adminProperties.getRescan());
        this.fireMPDChangeEvent(MPDChangeEvent.Event.REFRESHED);
    }

    @Override
    public long getDaemonUpTime() {
        return this.serverStatistics.getUptime();
    }

    @Override
    public synchronized void addOutputChangeListener(OutputChangeListener pcl) {
        this.outputListeners.add(pcl);
    }

    @Override
    public synchronized void removeOutputChangeListener(OutputChangeListener pcl) {
        this.outputListeners.remove(pcl);
    }

    protected synchronized void fireOutputChangeEvent(OutputChangeEvent.OUTPUT_EVENT event) {
        OutputChangeEvent oce = new OutputChangeEvent(this, event);
        for (OutputChangeListener pcl : this.outputListeners) {
            pcl.outputChanged(oce);
        }
    }
}

