/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.art;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.MPDException;
import org.bff.javampd.album.MPDAlbum;
import org.bff.javampd.art.ArtworkFinder;
import org.bff.javampd.art.MPDArtwork;
import org.bff.javampd.artist.MPDArtist;
import org.bff.javampd.song.SongDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MPDArtworkFinder
implements ArtworkFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDArtworkFinder.class);
    private SongDatabase songDatabase;

    @Inject
    public MPDArtworkFinder(SongDatabase songDatabase) {
        this.songDatabase = songDatabase;
    }

    @Override
    public List<MPDArtwork> find(MPDAlbum album) {
        return this.find(album, "");
    }

    @Override
    public List<MPDArtwork> find(MPDAlbum album, String pathPrefix) {
        ArrayList<MPDArtwork> artworkList = new ArrayList<MPDArtwork>();
        ArrayList paths = new ArrayList();
        this.songDatabase.findAlbum(album).forEach(song -> paths.add(pathPrefix + song.getFile().substring(0, song.getFile().lastIndexOf(File.separator))));
        paths.stream().distinct().forEach(path -> artworkList.addAll(this.find((String)path)));
        return artworkList;
    }

    @Override
    public List<MPDArtwork> find(MPDArtist artist) {
        return this.find(artist, "");
    }

    @Override
    public List<MPDArtwork> find(MPDArtist artist, String pathPrefix) {
        ArrayList<MPDArtwork> artworkList = new ArrayList<MPDArtwork>();
        ArrayList paths = new ArrayList();
        ArrayList albumPaths = new ArrayList();
        this.songDatabase.findArtist(artist).forEach(song -> albumPaths.add(pathPrefix + song.getFile().substring(0, song.getFile().lastIndexOf(File.separator))));
        albumPaths.forEach(path -> {
            if (path.contains(File.separator + artist.getName() + File.separator)) {
                paths.add(path.substring(0, path.lastIndexOf(File.separator)));
            }
        });
        paths.addAll(albumPaths);
        paths.stream().distinct().forEach(path -> artworkList.addAll(this.find((String)path)));
        return artworkList;
    }

    @Override
    public List<MPDArtwork> find(String path) {
        ArrayList<MPDArtwork> artworkList = new ArrayList<MPDArtwork>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(path, new String[0]), "**.{jpg,jpeg,png}");){
            stream.forEach(file -> artworkList.add(MPDArtworkFinder.loadArtwork(file)));
        }
        catch (IOException e) {
            LOGGER.error("Could not load art in {}", (Object)path, (Object)e);
            throw new MPDException("Could not read path: " + path, e);
        }
        return artworkList;
    }

    private static MPDArtwork loadArtwork(Path file) {
        file.getFileName();
        MPDArtwork artwork = new MPDArtwork(file.getFileName().toString(), file.toAbsolutePath().toString());
        artwork.setBytes(MPDArtworkFinder.loadFile(file));
        return artwork;
    }

    private static byte[] loadFile(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            LOGGER.error("Could not load art in {}", (Object)path, (Object)e);
            throw new MPDException("Could not read path: " + path, e);
        }
    }
}

