/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.database;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.database.DatabaseProperties;
import org.bff.javampd.database.TagLister;

public class MPDTagLister
implements TagLister {
    private DatabaseProperties databaseProperties;
    private CommandExecutor commandExecutor;

    @Inject
    public MPDTagLister(DatabaseProperties databaseProperties, CommandExecutor commandExecutor) {
        this.databaseProperties = databaseProperties;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public List<String> listInfo(TagLister.ListInfoType ... types) {
        ArrayList<String> returnList = new ArrayList<String>();
        List<String> list = this.commandExecutor.sendCommand(this.databaseProperties.getListInfo());
        for (String s : list) {
            for (TagLister.ListInfoType type : types) {
                if (!s.startsWith(type.getPrefix())) continue;
                returnList.add(s.substring(type.getPrefix().length()).trim());
            }
        }
        return returnList;
    }

    @Override
    public List<String> list(TagLister.ListType listType) {
        return this.list(listType, new ArrayList<String>(), new TagLister.GroupType[0]);
    }

    @Override
    public List<String> list(TagLister.ListType listType, List<String> params, TagLister.GroupType ... groupTypes) {
        this.addGroupParams(params, groupTypes);
        return this.commandExecutor.sendCommand(this.databaseProperties.getList(), MPDTagLister.generateParamList(listType, params));
    }

    @Override
    public List<String> list(TagLister.ListType listType, TagLister.GroupType ... groupTypes) {
        ArrayList<String> params = new ArrayList<String>();
        this.addGroupParams(params, groupTypes);
        return this.commandExecutor.sendCommand(this.databaseProperties.getList(), MPDTagLister.generateParamList(listType, params));
    }

    private void addGroupParams(List<String> params, TagLister.GroupType ... groupTypes) {
        if (groupTypes.length > 0) {
            Arrays.stream(groupTypes).forEach(group -> {
                params.add(this.databaseProperties.getGroup());
                params.add(group.getType());
            });
        }
    }

    private static String[] generateParamList(TagLister.ListType listType, List<String> params) {
        int i = 0;
        String[] paramList = params != null ? new String[params.size() + 1] : new String[1];
        paramList[i++] = listType.getType();
        if (params != null) {
            for (String s : params) {
                paramList[i++] = s;
            }
        }
        return paramList;
    }
}

