/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.genre;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bff.javampd.database.TagLister;
import org.bff.javampd.genre.GenreDatabase;
import org.bff.javampd.genre.MPDGenre;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDGenreDatabase
implements GenreDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDGenreDatabase.class);
    private TagLister tagLister;

    @Inject
    public MPDGenreDatabase(TagLister tagLister) {
        this.tagLister = tagLister;
    }

    @Override
    public Collection<MPDGenre> listAllGenres() {
        return this.tagLister.list(TagLister.ListType.GENRE).stream().map(s -> new MPDGenre(s.substring(s.split(":")[0].length() + 1).trim())).collect(Collectors.toList());
    }

    @Override
    public MPDGenre listGenreByName(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TagLister.ListType.GENRE.getType());
        list.add(name);
        MPDGenre genre = null;
        ArrayList genres = new ArrayList();
        this.tagLister.list(TagLister.ListType.GENRE, list, new TagLister.GroupType[0]).forEach(response -> genres.add(new MPDGenre(response.split(":")[1].trim())));
        if (genres.size() > 1) {
            LOGGER.warn("Multiple genres returned for name {}", (Object)name);
        }
        if (!genres.isEmpty()) {
            genre = (MPDGenre)genres.get(0);
        }
        return genre;
    }
}

