/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.monitor.BitrateMonitor;
import org.bff.javampd.monitor.MPDVolumeMonitor;
import org.bff.javampd.player.BitrateChangeEvent;
import org.bff.javampd.player.BitrateChangeListener;
import org.bff.javampd.server.Status;

@Singleton
public class MPDBitrateMonitor
extends MPDVolumeMonitor
implements BitrateMonitor {
    private int oldBitrate;
    private int newBitrate;
    private List<BitrateChangeListener> bitrateListeners = new ArrayList<BitrateChangeListener>();

    MPDBitrateMonitor() {
    }

    @Override
    public synchronized void addBitrateChangeListener(BitrateChangeListener bcl) {
        this.bitrateListeners.add(bcl);
    }

    @Override
    public synchronized void removeBitrateChangeListener(BitrateChangeListener bcl) {
        this.bitrateListeners.remove(bcl);
    }

    @Override
    public void processResponseStatus(String line) {
        super.processResponseStatus(line);
        if (Status.lookupStatus(line) == Status.BITRATE) {
            this.newBitrate = Integer.parseInt(line.substring(Status.BITRATE.getStatusPrefix().length()).trim());
        }
    }

    @Override
    public void checkStatus() {
        super.checkStatus();
        if (this.oldBitrate != this.newBitrate) {
            this.fireBitrateChangeEvent(new BitrateChangeEvent(this, this.oldBitrate, this.newBitrate));
            this.oldBitrate = this.newBitrate;
        }
    }

    private void fireBitrateChangeEvent(BitrateChangeEvent bitrateChangeEvent) {
        for (BitrateChangeListener bcl : this.bitrateListeners) {
            bcl.bitrateChanged(bitrateChangeEvent);
        }
    }

    @Override
    public void reset() {
        this.oldBitrate = 0;
        this.newBitrate = 0;
    }
}

