/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.monitor.ConnectionMonitor;
import org.bff.javampd.server.ConnectionChangeEvent;
import org.bff.javampd.server.ConnectionChangeListener;
import org.bff.javampd.server.Server;

@Singleton
public class MPDConnectionMonitor
implements ConnectionMonitor {
    private List<ConnectionChangeListener> connectionListeners = new ArrayList<ConnectionChangeListener>();
    private Server server;
    private boolean connected = true;

    MPDConnectionMonitor() {
    }

    @Override
    public synchronized void addConnectionChangeListener(ConnectionChangeListener ccl) {
        this.connectionListeners.add(ccl);
    }

    @Override
    public synchronized void removeConnectionChangeListener(ConnectionChangeListener ccl) {
        this.connectionListeners.remove(ccl);
    }

    protected synchronized void fireConnectionChangeEvent(boolean isConnected) {
        ConnectionChangeEvent cce = new ConnectionChangeEvent(this, isConnected);
        for (ConnectionChangeListener ccl : this.connectionListeners) {
            ccl.connectionChangeEventReceived(cce);
        }
    }

    @Override
    public void checkStatus() {
        boolean conn = this.server.isConnected();
        if (this.connected != conn) {
            this.connected = conn;
            this.fireConnectionChangeEvent(conn);
        }
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }
}

