/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.monitor.ErrorMonitor;
import org.bff.javampd.server.ErrorEvent;
import org.bff.javampd.server.ErrorListener;
import org.bff.javampd.server.Status;

@Singleton
public class MPDErrorMonitor
implements ErrorMonitor {
    private String error;
    private List<ErrorListener> errorListeners = new ArrayList<ErrorListener>();

    MPDErrorMonitor() {
    }

    @Override
    public synchronized void addErrorListener(ErrorListener el) {
        this.errorListeners.add(el);
    }

    @Override
    public synchronized void removeErrorListener(ErrorListener el) {
        this.errorListeners.remove(el);
    }

    protected void fireMPDErrorEvent(String message) {
        ErrorEvent ee = new ErrorEvent(this, message);
        for (ErrorListener el : this.errorListeners) {
            el.errorEventReceived(ee);
        }
    }

    @Override
    public void processResponseStatus(String line) {
        Status status = Status.lookupStatus(line);
        if (status == Status.ERROR) {
            this.error = line.substring(Status.ERROR.getStatusPrefix().length()).trim();
        }
    }

    @Override
    public void reset() {
        this.error = null;
    }

    @Override
    public void checkStatus() {
        if (this.error != null) {
            this.fireMPDErrorEvent(this.error);
            this.error = null;
        }
    }
}

