/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.Executors;
import org.bff.javampd.monitor.ConnectionMonitor;
import org.bff.javampd.monitor.ErrorMonitor;
import org.bff.javampd.monitor.MonitorProperties;
import org.bff.javampd.monitor.OutputMonitor;
import org.bff.javampd.monitor.PlayerMonitor;
import org.bff.javampd.monitor.PlaylistMonitor;
import org.bff.javampd.monitor.StandAloneMonitor;
import org.bff.javampd.monitor.StandAloneMonitorThread;
import org.bff.javampd.monitor.ThreadedMonitor;
import org.bff.javampd.monitor.TrackMonitor;
import org.bff.javampd.output.OutputChangeListener;
import org.bff.javampd.player.BitrateChangeListener;
import org.bff.javampd.player.PlayerBasicChangeEvent;
import org.bff.javampd.player.PlayerBasicChangeListener;
import org.bff.javampd.player.TrackPositionChangeListener;
import org.bff.javampd.player.VolumeChangeListener;
import org.bff.javampd.playlist.PlaylistBasicChangeListener;
import org.bff.javampd.server.ConnectionChangeListener;
import org.bff.javampd.server.ErrorListener;
import org.bff.javampd.server.ServerStatus;

@Singleton
public class MPDStandAloneMonitor
implements StandAloneMonitor,
PlayerBasicChangeListener {
    private StandAloneMonitorThread standAloneMonitorThread;
    private OutputMonitor outputMonitor;
    private ErrorMonitor errorMonitor;
    private ConnectionMonitor connectionMonitor;
    private PlayerMonitor playerMonitor;
    private TrackMonitor trackMonitor;
    private PlaylistMonitor playlistMonitor;
    private MonitorProperties monitorProperties = new MonitorProperties();

    @Inject
    MPDStandAloneMonitor(ServerStatus serverStatus, OutputMonitor outputMonitor, TrackMonitor trackMonitor, ConnectionMonitor connectionMonitor, PlayerMonitor playerMonitor, PlaylistMonitor playlistMonitor, ErrorMonitor errorMonitor) {
        this.outputMonitor = outputMonitor;
        this.trackMonitor = trackMonitor;
        this.connectionMonitor = connectionMonitor;
        this.playerMonitor = playerMonitor;
        this.playlistMonitor = playlistMonitor;
        this.errorMonitor = errorMonitor;
        this.standAloneMonitorThread = new StandAloneMonitorThread(serverStatus, connectionMonitor, this.monitorProperties.getMonitorDelay(), this.monitorProperties.getExceptionDelay());
        this.createMonitors();
    }

    private void createMonitors() {
        this.standAloneMonitorThread.addMonitor(new ThreadedMonitor(this.trackMonitor, this.monitorProperties.getTrackDelay()), new ThreadedMonitor(this.playerMonitor, this.monitorProperties.getPlayerDelay()), new ThreadedMonitor(this.errorMonitor, this.monitorProperties.getErrorDelay()), new ThreadedMonitor(this.playlistMonitor, this.monitorProperties.getPlaylistDelay()), new ThreadedMonitor(this.connectionMonitor, this.monitorProperties.getConnectionDelay()), new ThreadedMonitor(this.outputMonitor, this.monitorProperties.getOutputDelay()));
    }

    @Override
    public synchronized void addTrackPositionChangeListener(TrackPositionChangeListener tpcl) {
        this.trackMonitor.addTrackPositionChangeListener(tpcl);
    }

    @Override
    public synchronized void removeTrackPositionChangeListener(TrackPositionChangeListener tpcl) {
        this.trackMonitor.removeTrackPositionChangeListener(tpcl);
    }

    @Override
    public synchronized void addConnectionChangeListener(ConnectionChangeListener ccl) {
        this.connectionMonitor.addConnectionChangeListener(ccl);
    }

    @Override
    public synchronized void removeConnectionChangeListener(ConnectionChangeListener ccl) {
        this.connectionMonitor.removeConnectionChangeListener(ccl);
    }

    @Override
    public synchronized void addPlayerChangeListener(PlayerBasicChangeListener pcl) {
        this.playerMonitor.addPlayerChangeListener(pcl);
    }

    @Override
    public synchronized void removePlayerChangeListener(PlayerBasicChangeListener pcl) {
        this.playerMonitor.removePlayerChangeListener(pcl);
    }

    @Override
    public synchronized void addVolumeChangeListener(VolumeChangeListener vcl) {
        this.playerMonitor.addVolumeChangeListener(vcl);
    }

    @Override
    public synchronized void removeVolumeChangeListener(VolumeChangeListener vcl) {
        this.playerMonitor.removeVolumeChangeListener(vcl);
    }

    @Override
    public synchronized void addBitrateChangeListener(BitrateChangeListener bcl) {
        this.playerMonitor.addBitrateChangeListener(bcl);
    }

    @Override
    public synchronized void removeBitrateChangeListener(BitrateChangeListener bcl) {
        this.playerMonitor.removeBitrateChangeListener(bcl);
    }

    @Override
    public synchronized void addOutputChangeListener(OutputChangeListener vcl) {
        this.outputMonitor.addOutputChangeListener(vcl);
    }

    @Override
    public synchronized void removeOutputChangeListener(OutputChangeListener vcl) {
        this.outputMonitor.removeOutputChangeListener(vcl);
    }

    @Override
    public synchronized void addPlaylistChangeListener(PlaylistBasicChangeListener pcl) {
        this.playlistMonitor.addPlaylistChangeListener(pcl);
    }

    @Override
    public synchronized void removePlaylistChangeListener(PlaylistBasicChangeListener pcl) {
        this.playlistMonitor.removePlaylistChangeListener(pcl);
    }

    @Override
    public synchronized void addErrorListener(ErrorListener el) {
        this.errorMonitor.addErrorListener(el);
    }

    @Override
    public synchronized void removeErrorListener(ErrorListener el) {
        this.errorMonitor.removeErrorListener(el);
    }

    @Override
    public void start() {
        Executors.newSingleThreadExecutor().execute(this.standAloneMonitorThread);
    }

    @Override
    public void stop() {
        this.standAloneMonitorThread.setStopped(true);
    }

    @Override
    public boolean isDone() {
        return this.standAloneMonitorThread.isDone();
    }

    @Override
    public boolean isLoaded() {
        return this.standAloneMonitorThread.isInitialized();
    }

    @Override
    public void playerBasicChange(PlayerBasicChangeEvent event) {
        if (event.getStatus() == PlayerBasicChangeEvent.Status.PLAYER_STOPPED) {
            this.processStoppedStatus();
        }
    }

    private void processStoppedStatus() {
        this.trackMonitor.resetElapsedTime();
        this.playlistMonitor.playerStopped();
    }
}

