/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.monitor.TrackMonitor;
import org.bff.javampd.player.TrackPositionChangeEvent;
import org.bff.javampd.player.TrackPositionChangeListener;
import org.bff.javampd.server.Status;

@Singleton
public class MPDTrackMonitor
implements TrackMonitor {
    private List<TrackPositionChangeListener> trackListeners = new ArrayList<TrackPositionChangeListener>();
    private long oldPos;
    private long elapsedTime;

    MPDTrackMonitor() {
    }

    @Override
    public void checkStatus() {
        this.checkTrackPosition(this.elapsedTime);
    }

    @Override
    public void processResponseStatus(String line) {
        if (Status.lookupStatus(line) == Status.TIME) {
            this.elapsedTime = Long.parseLong(line.substring(Status.TIME.getStatusPrefix().length()).trim().split(":")[0]);
        }
    }

    @Override
    public void reset() {
        this.oldPos = 0L;
        this.elapsedTime = 0L;
    }

    protected final void checkTrackPosition(long newPos) {
        if (this.oldPos != newPos) {
            this.oldPos = newPos;
            this.fireTrackPositionChangeEvent(newPos);
        }
    }

    @Override
    public synchronized void addTrackPositionChangeListener(TrackPositionChangeListener tpcl) {
        this.trackListeners.add(tpcl);
    }

    @Override
    public synchronized void removeTrackPositionChangeListener(TrackPositionChangeListener tpcl) {
        this.trackListeners.remove(tpcl);
    }

    @Override
    public void resetElapsedTime() {
        this.elapsedTime = 0L;
        this.oldPos = 0L;
    }

    protected synchronized void fireTrackPositionChangeEvent(long newTime) {
        TrackPositionChangeEvent tpce = new TrackPositionChangeEvent(this, newTime);
        for (TrackPositionChangeListener tpcl : this.trackListeners) {
            tpcl.trackPositionChanged(tpce);
        }
    }
}

