/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bff.javampd.MPDException;
import org.bff.javampd.monitor.ConnectionMonitor;
import org.bff.javampd.monitor.ThreadedMonitor;
import org.bff.javampd.server.ServerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandAloneMonitorThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandAloneMonitorThread.class);
    private List<ThreadedMonitor> monitors;
    private ServerStatus serverStatus;
    private ConnectionMonitor connectionMonitor;
    private int delay;
    private int exceptionDelay;
    private boolean stopped;
    private boolean done;
    private boolean initialized;

    public StandAloneMonitorThread(ServerStatus serverStatus, ConnectionMonitor connectionMonitor, int delay, int exceptionDelay) {
        this.serverStatus = serverStatus;
        this.connectionMonitor = connectionMonitor;
        this.delay = delay;
        this.exceptionDelay = exceptionDelay;
        this.monitors = new ArrayList<ThreadedMonitor>();
    }

    public void addMonitor(ThreadedMonitor ... monitors) {
        for (ThreadedMonitor monitor : monitors) {
            if (this.monitors.contains(monitor)) continue;
            this.monitors.add(monitor);
        }
    }

    public synchronized void removeMonitor(ThreadedMonitor monitor) {
        this.monitors.remove(monitor);
    }

    @Override
    public void run() {
        this.stopped = false;
        this.done = false;
        this.initialized = false;
        this.loadInitialStatus();
        while (!this.stopped) {
            this.monitor();
        }
        this.resetMonitors();
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor() {
        try {
            StandAloneMonitorThread standAloneMonitorThread = this;
            synchronized (standAloneMonitorThread) {
                ArrayList<String> response = new ArrayList<String>(this.serverStatus.getStatus());
                this.processResponse(response);
                this.monitors.forEach(ThreadedMonitor::checkStatus);
            }
            TimeUnit.SECONDS.sleep(this.delay);
        }
        catch (InterruptedException ie) {
            LOGGER.error("StandAloneMonitor interrupted", (Throwable)ie);
            this.setStopped(true);
            Thread.currentThread().interrupt();
        }
        catch (MPDException mpdException) {
            LOGGER.error("Error while checking statuses", (Throwable)mpdException);
            boolean retry = true;
            while (retry) {
                retry = this.retry();
            }
        }
    }

    private boolean retry() {
        try {
            TimeUnit.SECONDS.sleep(this.exceptionDelay);
        }
        catch (InterruptedException ex) {
            LOGGER.error("StandAloneMonitor interrupted", (Throwable)ex);
            this.setStopped(true);
            Thread.currentThread().interrupt();
            return false;
        }
        try {
            this.connectionMonitor.checkStatus();
            return !this.connectionMonitor.isConnected();
        }
        catch (MPDException e) {
            LOGGER.error("Error checking connection status.", (Throwable)e);
            throw e;
        }
    }

    private void resetMonitors() {
        this.monitors.forEach(ThreadedMonitor::reset);
    }

    private void processResponse(List<String> response) {
        response.forEach(this::processResponseStatus);
    }

    private void processResponseStatus(String line) {
        for (ThreadedMonitor monitor : this.monitors) {
            monitor.processResponseLine(line);
        }
    }

    private void loadInitialStatus() {
        try {
            ArrayList<String> response = new ArrayList<String>(this.serverStatus.getStatus());
            this.processResponse(response);
            this.initialized = true;
        }
        catch (MPDException ex) {
            LOGGER.error("Problem with initialization", (Throwable)ex);
            throw ex;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }
}

