/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.player;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.audioinfo.MPDAudioInfo;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.player.Player;
import org.bff.javampd.player.PlayerChangeEvent;
import org.bff.javampd.player.PlayerChangeListener;
import org.bff.javampd.player.PlayerProperties;
import org.bff.javampd.player.VolumeChangeDelegate;
import org.bff.javampd.player.VolumeChangeListener;
import org.bff.javampd.server.ServerStatus;
import org.bff.javampd.song.MPDSong;
import org.bff.javampd.song.SongConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDPlayer
implements Player {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDPlayer.class);
    private int oldVolume;
    private List<PlayerChangeListener> listeners = new ArrayList<PlayerChangeListener>();
    private VolumeChangeDelegate volumeChangeDelegate;
    private Player.Status status = Player.Status.STATUS_STOPPED;
    private ServerStatus serverStatus;
    private PlayerProperties playerProperties;
    private CommandExecutor commandExecutor;
    private SongConverter songConverter;

    @Inject
    public MPDPlayer(ServerStatus serverStatus, PlayerProperties playerProperties, CommandExecutor commandExecutor, SongConverter songConverter) {
        this.serverStatus = serverStatus;
        this.playerProperties = playerProperties;
        this.commandExecutor = commandExecutor;
        this.songConverter = songConverter;
        this.volumeChangeDelegate = new VolumeChangeDelegate();
    }

    @Override
    public MPDSong getCurrentSong() {
        List<MPDSong> songList = this.songConverter.convertResponseToSong(this.commandExecutor.sendCommand(this.playerProperties.getCurrentSong()));
        if (songList.isEmpty()) {
            return null;
        }
        return songList.get(0);
    }

    @Override
    public synchronized void addPlayerChangeListener(PlayerChangeListener pcl) {
        this.listeners.add(pcl);
    }

    @Override
    public synchronized void removePlayerChangedListener(PlayerChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    protected synchronized void firePlayerChangeEvent(PlayerChangeEvent.Event event) {
        PlayerChangeEvent pce = new PlayerChangeEvent(this, event);
        for (PlayerChangeListener pcl : this.listeners) {
            pcl.playerChanged(pce);
        }
    }

    @Override
    public synchronized void addVolumeChangeListener(VolumeChangeListener vcl) {
        this.volumeChangeDelegate.addVolumeChangeListener(vcl);
    }

    @Override
    public synchronized void removeVolumeChangedListener(VolumeChangeListener vcl) {
        this.volumeChangeDelegate.removeVolumeChangedListener(vcl);
    }

    protected synchronized void fireVolumeChangeEvent(int volume) {
        this.volumeChangeDelegate.fireVolumeChangeEvent(this, volume);
    }

    @Override
    public void play() {
        this.playSong(null);
    }

    @Override
    public void playSong(MPDSong song) {
        if (song == null) {
            this.commandExecutor.sendCommand(this.playerProperties.getPlay());
        } else {
            this.commandExecutor.sendCommand(this.playerProperties.getPlayId(), song.getId());
        }
        if (this.status == Player.Status.STATUS_STOPPED || this.status == Player.Status.STATUS_PAUSED) {
            this.status = Player.Status.STATUS_PLAYING;
            this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_STARTED);
        } else {
            this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_SONG_SET);
        }
    }

    @Override
    public void seek(long secs) {
        this.seekSong(null, secs);
    }

    @Override
    public void seekSong(MPDSong song, long secs) {
        List<String> response = null;
        String[] params = new String[2];
        params[1] = Long.toString(secs);
        if (song == null) {
            if ((long)this.getCurrentSong().getLength() > secs) {
                params[0] = Integer.toString(this.getCurrentSong().getId());
                response = this.commandExecutor.sendCommand(this.playerProperties.getSeekId(), params);
            }
        } else if ((long)song.getLength() >= secs) {
            params[0] = Integer.toString(song.getId());
            response = this.commandExecutor.sendCommand(this.playerProperties.getSeekId(), params);
        }
        if (response != null) {
            this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_SEEKING);
        }
    }

    @Override
    public void stop() {
        this.commandExecutor.sendCommand(this.playerProperties.getStop());
        this.status = Player.Status.STATUS_STOPPED;
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_STOPPED);
    }

    @Override
    public void pause() {
        this.commandExecutor.sendCommand(this.playerProperties.getPause());
        this.status = Player.Status.STATUS_PAUSED;
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_PAUSED);
    }

    @Override
    public void playNext() {
        this.commandExecutor.sendCommand(this.playerProperties.getNext());
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_NEXT);
    }

    @Override
    public void playPrevious() {
        this.commandExecutor.sendCommand(this.playerProperties.getPrevious());
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_PREVIOUS);
    }

    @Override
    public void mute() {
        this.oldVolume = this.getVolume();
        this.setVolume(0);
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_MUTED);
    }

    @Override
    public void unMute() {
        this.setVolume(this.oldVolume);
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_UNMUTED);
    }

    @Override
    public int getBitrate() {
        return this.serverStatus.getBitrate();
    }

    @Override
    public int getVolume() {
        return this.serverStatus.getVolume();
    }

    @Override
    public void setVolume(int volume) {
        if (volume < 0 || volume > 100) {
            LOGGER.warn("Not changing volume to {}", (Object)volume);
        } else {
            this.commandExecutor.sendCommand(this.playerProperties.getSetVolume(), volume);
            this.fireVolumeChangeEvent(volume);
        }
    }

    @Override
    public boolean isRepeat() {
        return this.serverStatus.isRepeat();
    }

    @Override
    public void setRepeat(boolean shouldRepeat) {
        String repeat = shouldRepeat ? "1" : "0";
        this.commandExecutor.sendCommand(this.playerProperties.getRepeat(), repeat);
    }

    @Override
    public boolean isRandom() {
        return this.serverStatus.isRandom();
    }

    @Override
    public void setRandom(boolean shouldRandom) {
        String random = shouldRandom ? "1" : "0";
        this.commandExecutor.sendCommand(this.playerProperties.getRandom(), random);
    }

    @Override
    public void randomizePlay() {
        this.setRandom(true);
    }

    @Override
    public void unRandomizePlay() {
        this.setRandom(false);
    }

    @Override
    public int getXFade() {
        return this.serverStatus.getXFade();
    }

    @Override
    public void setXFade(int xFade) {
        this.commandExecutor.sendCommand(this.playerProperties.getXFade(), xFade);
    }

    @Override
    public long getElapsedTime() {
        return this.serverStatus.getElapsedTime();
    }

    @Override
    public long getTotalTime() {
        return this.serverStatus.getTotalTime();
    }

    @Override
    public void setConsume(boolean pConsume) {
        String consume = pConsume ? "1" : "0";
        this.commandExecutor.sendCommand(this.playerProperties.getConsume(), consume);
    }

    @Override
    public void setSingle(boolean pSingle) {
        String single = pSingle ? "1" : "0";
        this.commandExecutor.sendCommand(this.playerProperties.getSingle(), single);
    }

    @Override
    public MPDAudioInfo getAudioDetails() {
        MPDAudioInfo info = null;
        String response = this.serverStatus.getAudio();
        if (!"".equals(response)) {
            info = new MPDAudioInfo();
            String[] split = response.split(":");
            MPDPlayer.parseSampleRate(info, split[0]);
            MPDPlayer.parseBitRate(info, split[1]);
            MPDPlayer.parseChannels(info, split[2]);
        }
        return info;
    }

    private static void parseSampleRate(MPDAudioInfo info, String sampleRate) {
        try {
            info.setSampleRate(Integer.parseInt(sampleRate));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format sample rate", (Throwable)nfe);
            info.setSampleRate(-1);
        }
    }

    @Override
    public Player.Status getStatus() {
        String currentStatus = this.serverStatus.getState();
        if (currentStatus.equalsIgnoreCase(Player.Status.STATUS_PLAYING.getPrefix())) {
            return Player.Status.STATUS_PLAYING;
        }
        if (currentStatus.equalsIgnoreCase(Player.Status.STATUS_PAUSED.getPrefix())) {
            return Player.Status.STATUS_PAUSED;
        }
        return Player.Status.STATUS_STOPPED;
    }

    private static void parseChannels(MPDAudioInfo info, String channels) {
        try {
            info.setChannels(Integer.parseInt(channels));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format channels", (Throwable)nfe);
            info.setChannels(-1);
        }
    }

    private static void parseBitRate(MPDAudioInfo info, String bitRate) {
        try {
            info.setBits(Integer.parseInt(bitRate));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format bits", (Throwable)nfe);
            info.setBits(-1);
        }
    }
}

