/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.playlist;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bff.javampd.album.MPDAlbum;
import org.bff.javampd.artist.MPDArtist;
import org.bff.javampd.command.CommandExecutor;
import org.bff.javampd.command.MPDCommand;
import org.bff.javampd.file.MPDFile;
import org.bff.javampd.genre.MPDGenre;
import org.bff.javampd.playlist.MPDSavedPlaylist;
import org.bff.javampd.playlist.Playlist;
import org.bff.javampd.playlist.PlaylistChangeEvent;
import org.bff.javampd.playlist.PlaylistChangeListener;
import org.bff.javampd.playlist.PlaylistProperties;
import org.bff.javampd.server.ServerStatus;
import org.bff.javampd.song.MPDSong;
import org.bff.javampd.song.SongConverter;
import org.bff.javampd.song.SongDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDPlaylist
implements Playlist {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDPlaylist.class);
    private int oldVersion = -1;
    private int version = -1;
    private List<PlaylistChangeListener> listeners;
    private SongDatabase songDatabase;
    private ServerStatus serverStatus;
    private PlaylistProperties playlistProperties;
    private CommandExecutor commandExecutor;
    private SongConverter songConverter;

    @Inject
    public MPDPlaylist(SongDatabase songDatabase, ServerStatus serverStatus, PlaylistProperties playlistProperties, CommandExecutor commandExecutor, SongConverter songConverter) {
        this.songDatabase = songDatabase;
        this.serverStatus = serverStatus;
        this.playlistProperties = playlistProperties;
        this.commandExecutor = commandExecutor;
        this.songConverter = songConverter;
        this.listeners = new ArrayList<PlaylistChangeListener>();
        this.playlistProperties = new PlaylistProperties();
    }

    @Override
    public synchronized void addPlaylistChangeListener(PlaylistChangeListener pcl) {
        this.listeners.add(pcl);
    }

    @Override
    public synchronized void removePlaylistStatusChangedListener(PlaylistChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    protected synchronized void firePlaylistChangeEvent(PlaylistChangeEvent.Event event) {
        PlaylistChangeEvent pce = new PlaylistChangeEvent(this, event);
        for (PlaylistChangeListener pcl : this.listeners) {
            pcl.playlistChanged(pce);
        }
    }

    protected synchronized void firePlaylistChangeEvent(PlaylistChangeEvent.Event event, String name) {
        PlaylistChangeEvent pce = new PlaylistChangeEvent(this, event, name);
        for (PlaylistChangeListener pcl : this.listeners) {
            pcl.playlistChanged(pce);
        }
    }

    @Override
    public void loadPlaylist(String playlistName) {
        String name = playlistName;
        if (name.endsWith(".m3u")) {
            name = name.substring(0, name.length() - 4);
        }
        this.commandExecutor.sendCommand(this.playlistProperties.getLoad(), name);
        this.updatePlaylist();
    }

    @Override
    public void addSong(MPDSong song) {
        this.addSong(song, true);
    }

    @Override
    public void addSong(MPDSong song, boolean fireEvent) {
        this.addSong(song.getFile(), fireEvent);
    }

    @Override
    public void addSong(String file) {
        this.addSong(file, true);
    }

    @Override
    public void addSong(String file, boolean fireEvent) {
        this.commandExecutor.sendCommand(this.playlistProperties.getAdd(), file);
        this.updatePlaylist();
        if (fireEvent) {
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.SONG_ADDED, file);
        }
    }

    @Override
    public boolean addSongs(List<MPDSong> songList) {
        return this.addSongs(songList, true);
    }

    @Override
    public boolean addSongs(List<MPDSong> songList, boolean fireEvent) {
        this.commandExecutor.sendCommands(songList.stream().map(song -> new MPDCommand(this.playlistProperties.getAdd(), song.getFile())).collect(Collectors.toList()));
        int oldCount = songList.size();
        this.updatePlaylist();
        if (fireEvent) {
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.MULTIPLE_SONGS_ADDED, Integer.toString(songList.size()));
        }
        return oldCount < songList.size();
    }

    @Override
    public void addFileOrDirectory(MPDFile file) {
        this.commandExecutor.sendCommand(this.playlistProperties.getAdd(), file.getPath());
        this.updatePlaylist();
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.FILE_ADDED, file.getPath());
    }

    @Override
    public void removeSong(MPDSong song) {
        if (song.getId() > -1) {
            this.updatePlaylist();
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.SONG_DELETED, song.getName());
            this.commandExecutor.sendCommand(this.playlistProperties.getRemoveId(), song.getId());
        } else {
            this.removeSong(song.getPosition());
        }
    }

    @Override
    public void removeSong(int position) {
        if (position > -1) {
            this.commandExecutor.sendCommand(this.playlistProperties.getRemove(), position);
            this.updatePlaylist();
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.SONG_DELETED);
        }
    }

    @Override
    public MPDSong getCurrentSong() {
        List<MPDSong> songs = this.convertResponseToSong(this.commandExecutor.sendCommand(this.playlistProperties.getCurrentSong()));
        return songs.isEmpty() ? null : songs.get(0);
    }

    private List<MPDSong> convertResponseToSong(List<String> response) {
        return this.songConverter.convertResponseToSong(response);
    }

    @Override
    public void clearPlaylist() {
        this.commandExecutor.sendCommand(this.playlistProperties.getClear());
        this.updatePlaylist();
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.PLAYLIST_CLEARED);
    }

    @Override
    public void deletePlaylist(MPDSavedPlaylist playlist) {
        this.deletePlaylist(playlist.getName());
    }

    @Override
    public void deletePlaylist(String playlistName) {
        this.commandExecutor.sendCommand(this.playlistProperties.getDelete(), playlistName);
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.PLAYLIST_DELETED);
    }

    @Override
    public void move(MPDSong song, int to) {
        if (song.getId() > -1) {
            this.commandExecutor.sendCommand(this.playlistProperties.getMoveId(), song.getId(), to);
        } else if (song.getPosition() > -1) {
            this.commandExecutor.sendCommand(this.playlistProperties.getMove(), song.getPosition(), to);
        }
        this.updatePlaylist();
    }

    @Override
    public void shuffle() {
        this.commandExecutor.sendCommand(this.playlistProperties.getShuffle());
        this.updatePlaylist();
    }

    @Override
    public void swap(MPDSong song1, MPDSong song2) {
        if (song1.getId() > -1 && song2.getId() > -1) {
            this.commandExecutor.sendCommand(this.playlistProperties.getSwapId(), song1.getId(), song2.getId());
        } else if (song1.getPosition() > -1 && song2.getPosition() > -1) {
            this.commandExecutor.sendCommand(this.playlistProperties.getSwap(), song1.getPosition(), song2.getPosition());
        }
        this.updatePlaylist();
    }

    @Override
    public boolean savePlaylist(String playlistName) {
        if (playlistName != null) {
            this.commandExecutor.sendCommand(this.playlistProperties.getSave(), playlistName);
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.PLAYLIST_SAVED);
            return true;
        }
        LOGGER.error("Playlist not saved since name was null");
        return false;
    }

    private void updatePlaylist() {
        this.setVersion(this.getPlaylistVersion());
        if (this.getPlaylistVersion() != this.oldVersion) {
            this.oldVersion = this.getVersion();
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.PLAYLIST_CHANGED);
        }
    }

    private int getPlaylistVersion() {
        return this.serverStatus.getPlaylistVersion();
    }

    private List<MPDSong> listSongs() {
        return this.convertResponseToSong(this.commandExecutor.sendCommand(this.playlistProperties.getInfo()));
    }

    @Override
    public void insertAlbum(MPDArtist artist, MPDAlbum album) {
        for (MPDSong song : this.songDatabase.findAlbumByArtist(artist, album)) {
            this.addSong(song, false);
        }
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.ALBUM_ADDED, album.getName());
    }

    @Override
    public void insertAlbum(String artist, String album) {
        for (MPDSong song : this.songDatabase.findAlbumByArtist(artist, album)) {
            this.addSong(song, false);
        }
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.ALBUM_ADDED, album);
    }

    @Override
    public void insertAlbum(MPDAlbum album) {
        for (MPDSong song : this.songDatabase.findAlbum(album)) {
            this.addSong(song, false);
        }
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.ALBUM_ADDED, album.getName());
    }

    @Override
    public void insertAlbum(String album) {
        for (MPDSong song : this.songDatabase.findAlbum(album)) {
            this.addSong(song, false);
        }
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.ALBUM_ADDED, album);
    }

    @Override
    public void removeAlbum(MPDArtist artist, MPDAlbum album) {
        this.removeAlbum(artist.getName(), album.getName());
    }

    @Override
    public void removeAlbum(String artistName, String albumName) {
        List<MPDSong> removeList = this.getSongList().stream().filter(song -> song.getArtistName().equals(artistName) && song.getAlbumName().equals(albumName)).collect(Collectors.toList());
        removeList.forEach(this::removeSong);
    }

    @Override
    public void insertArtist(MPDArtist artist) {
        this.insertArtist(artist.getName());
    }

    @Override
    public void insertArtist(String artistName) {
        for (MPDSong song : this.songDatabase.findArtist(artistName)) {
            this.addSong(song, false);
        }
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.ARTIST_ADDED, artistName);
    }

    @Override
    public void insertGenre(MPDGenre genre) {
        this.insertGenre(genre.getName());
    }

    @Override
    public void insertGenre(String genreName) {
        for (MPDSong song : this.songDatabase.findGenre(genreName)) {
            this.addSong(song, false);
        }
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.GENRE_ADDED, genreName);
    }

    @Override
    public void removeGenre(MPDGenre genre) {
        this.removeGenre(genre.getName());
    }

    @Override
    public void removeGenre(String genreName) {
        List<MPDSong> removeList = this.getSongList().stream().filter(song -> song.getGenre().equals(genreName)).collect(Collectors.toList());
        removeList.forEach(this::removeSong);
    }

    @Override
    public void insertYear(String year) {
        for (MPDSong song : this.songDatabase.findYear(year)) {
            this.addSong(song, false);
        }
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.YEAR_ADDED, year);
    }

    @Override
    public void removeYear(String year) {
        ArrayList<MPDSong> removeList = new ArrayList<MPDSong>();
        for (MPDSong song : this.getSongList()) {
            if (!song.getYear().equals(year)) continue;
            removeList.add(song);
        }
        removeList.forEach(this::removeSong);
    }

    @Override
    public void removeArtist(MPDArtist artist) {
        this.removeArtist(artist.getName());
    }

    @Override
    public void removeArtist(String artistName) {
        ArrayList<MPDSong> removeList = new ArrayList<MPDSong>();
        for (MPDSong song : this.getSongList()) {
            if (!song.getArtistName().equals(artistName)) continue;
            removeList.add(song);
        }
        removeList.forEach(this::removeSong);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private void setVersion(int version) {
        this.version = version;
    }

    @Override
    public List<MPDSong> getSongList() {
        return this.listSongs();
    }

    @Override
    public void swap(MPDSong song, int i) {
        this.commandExecutor.sendCommand(this.playlistProperties.getSwapId(), song.getId(), i);
        this.updatePlaylist();
    }
}

